/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.scheduler.quartz;

import com.nepxion.util.scheduler.quartz.QuartzConstants;
import com.nepxion.util.scheduler.quartz.QuartzContext;
import com.nepxion.util.scheduler.quartz.QuartzJobDetail;
import com.nepxion.util.scheduler.quartz.QuartzJobTrigger;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzManager
implements QuartzConstants {
    public static void start() throws SchedulerException {
        if (!QuartzContext.getScheduler().isStarted()) {
            QuartzContext.getScheduler().start();
        }
    }

    public static void scheduleJob(Class jobClass, int[] repeatInterval) throws SchedulerException {
        QuartzManager.scheduleJob(jobClass.getName(), jobClass.getName(), jobClass.getName(), jobClass.getName(), jobClass, null, null, repeatInterval);
    }

    public static void scheduleJob(String jobName, String jobGroup, String jobTriggerName, String jobTriggerGroup, Class jobClass, int[] repeatInterval) throws SchedulerException {
        QuartzManager.scheduleJob(jobName, jobGroup, jobTriggerName, jobTriggerGroup, jobClass, null, null, repeatInterval);
    }

    public static void scheduleJob(String jobName, String jobGroup, String jobTriggerName, String jobTriggerGroup, Class jobClass, Date startTime, Date endTime, int[] repeatInterval) throws SchedulerException {
        QuartzManager.scheduleJob(jobName, jobGroup, jobTriggerName, jobTriggerGroup, jobClass, startTime, endTime, -1, repeatInterval);
    }

    public static void scheduleJob(String jobName, String jobGroup, String jobTriggerName, String jobTriggerGroup, Class jobClass, Date startTime, Date endTime, int repeatCount, int[] repeatInterval) throws SchedulerException {
        QuartzManager.scheduleJob(jobName, jobGroup, jobTriggerName, jobTriggerGroup, jobClass, false, false, false, startTime, endTime, repeatCount, repeatInterval);
    }

    public static void scheduleJob(String jobName, String jobGroup, String jobTriggerName, String jobTriggerGroup, Class jobClass, boolean volatility, boolean durability, boolean recover, Date startTime, Date endTime, int repeatCount, int[] repeatInterval) throws SchedulerException {
        QuartzJobDetail jobDetail = new QuartzJobDetail(jobName, jobGroup, jobClass, volatility, durability, recover);
        QuartzJobTrigger jobTrigger = new QuartzJobTrigger(jobTriggerName, jobTriggerGroup, jobName, jobGroup, startTime != null ? startTime : new Date(), endTime, repeatCount, repeatInterval);
        QuartzManager.scheduleJob(jobDetail, jobTrigger);
    }

    public static void scheduleJob(QuartzJobDetail jobDetail, QuartzJobTrigger jobTrigger) throws SchedulerException {
        String jobName = jobDetail.getName();
        String jobGroup = jobDetail.getGroup();
        if (QuartzContext.getScheduler().getJobDetail(jobName, jobGroup) == null) {
            QuartzContext.getScheduler().scheduleJob((JobDetail)jobDetail, (Trigger)jobTrigger);
        }
    }

    public static void unscheduleJob(Class jobClass) throws SchedulerException {
        QuartzManager.unscheduleJob(jobClass.getName(), jobClass.getName());
    }

    public static void unscheduleJob(String jobName, String jobGroup) throws SchedulerException {
        if (QuartzContext.getScheduler().getJobDetail(jobName, jobGroup) != null) {
            QuartzContext.getScheduler().unscheduleJob(jobName, jobGroup);
        }
    }

    public static boolean isScheduled(Class jobClass) throws SchedulerException {
        return QuartzManager.isScheduled(jobClass.getName(), jobClass.getName());
    }

    public static boolean isScheduled(String jobName, String jobGroup) throws SchedulerException {
        return QuartzContext.getScheduler().getJobDetail(jobName, jobGroup) != null;
    }

    public static Scheduler getScheduler() {
        return QuartzContext.getScheduler();
    }

    public static void setContextObject(Object contextObject) throws SchedulerException {
        SchedulerContext schedulerContext = QuartzManager.getScheduler().getContext();
        if (schedulerContext.get((Object)"targetObject") == null) {
            schedulerContext.put((Object)"targetObject", contextObject);
        }
    }

    public static Object getContextObject() throws SchedulerException {
        SchedulerContext schedulerContext = QuartzManager.getScheduler().getContext();
        return schedulerContext.get((Object)"targetObject");
    }
}

