/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.AlarmStateStatistics;
import twaver.TDataBox;
import twaver.TWaverUtil;
import twaver.web.TWebView;
import twaver.web.table.TWebTable;
import twaver.web.table.TWebTableColumn;

public class TWebAlarmStatTable
extends TWebTable
implements TWebView {
    private String \u01cf = "alarmstattable";
    private AlarmStateStatistics \u01d1 = null;
    private AlarmSeverityChangeListener \u01d0 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            TWebAlarmStatTable.this.dirty = true;
            return false;
        }
    };
    private PropertyChangeListener \u01ce = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TWebAlarmStatTable.this.dirty = true;
        }
    };

    public TWebAlarmStatTable() {
        this(new TDataBox());
    }

    public TWebAlarmStatTable(TDataBox box) {
        this(box, null);
    }

    public TWebAlarmStatTable(TDataBox box, List alarmSeverities) {
        this.\u01d1 = new AlarmStateStatistics(box, alarmSeverities);
        this.\u01d1.getPropertyChangeSupport().addPropertyChangeListener("alarmstate", this.\u01ce);
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u01d0);
        this.rawData = this.\u01d1.getSeverityList();
        this.setColumns(TWebAlarmStatTable.M());
    }

    public AlarmStateStatistics getAlarmStateStatistics() {
        return this.\u01d1;
    }

    public TDataBox getDataBox() {
        return this.\u01d1.getDataBox();
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new NullPointerException("Cannot set a null TDataBox");
        }
        this.\u01d1.setDataBox(box);
    }

    protected Object[] getRowData(TWebTableColumn[] visibleColumns, Object row) {
        AlarmSeverity severity = (AlarmSeverity)row;
        Object[] rowData = new Object[visibleColumns.length];
        for (int i2 = 0; i2 < visibleColumns.length; ++i2) {
            Serializable value = null;
            TWebTableColumn column = visibleColumns[i2];
            String name = column.getName();
            if (name.equals("AlarmSeverity")) {
                value = severity;
            } else if (name.equals("AlarmNew")) {
                value = new Integer(this.\u01d1.getNewAlarmCount(severity));
            } else if (name.equals("AlarmAcked")) {
                value = new Integer(this.\u01d1.getAcknowledgedAlarmCount(severity));
            } else if (name.equals("AlarmTotal")) {
                value = new Integer(this.\u01d1.getTotalAlarmCount(severity));
            } else if (name.equals("AlarmColor")) {
                value = severity.getColor();
            }
            rowData[i2] = value;
        }
        return rowData;
    }

    private static TWebTableColumn[] M() {
        return new TWebTableColumn[]{new TWebTableColumn("AlarmSeverity", TWaverUtil.getString("AlarmSeverity")), new TWebTableColumn("AlarmNew", TWaverUtil.getString("AlarmNew")), new TWebTableColumn("AlarmAcked", TWaverUtil.getString("AlarmAcked")), new TWebTableColumn("AlarmTotal", TWaverUtil.getString("AlarmTotal")), new TWebTableColumn("AlarmColor", TWaverUtil.getString("AlarmColor"))};
    }

    public void updateTViewUI() {
        this.dirty = true;
    }

    public String getType() {
        return this.\u01cf;
    }

    public void setType(String type) {
        this.\u01cf = type;
    }
}

