/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.Element;
import twaver.Generator;
import twaver.Layer;
import twaver.LayerModel;
import twaver.Link;
import twaver.MovableFilter;
import twaver.ResizableFilter;
import twaver.SelectableFilter;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.VisibleFilter;
import twaver.base.A.D.C;
import twaver.base.A.D.F;
import twaver.base.A.E.H;
import twaver.base.A.E.M;
import twaver.base.A.E.b;
import twaver.base.A.E.m;
import twaver.base.A.F.E.E;
import twaver.base.A.H.I;
import twaver.base.A.I.B;
import twaver.network.background.AbstractBackground;
import twaver.network.background.Background;
import twaver.network.background.ColorBackground;
import twaver.network.background.ImageBackground;
import twaver.web.TWebView;
import twaver.web.svg.network.DefaultSVGBlinkingRule;
import twaver.web.svg.network.SVGBlinkingRule;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.ui.ElementSVGUI;

public class TSVGNetwork
implements B,
TWebView {
    private String \u03ac = "network";
    protected TDataBox box = new TDataBox();
    protected Map elementUIs = new HashMap();
    protected TSubNetwork currentSubNetwork = null;
    private int \u03b4 = TUIManager.getInt("network.straight.link.gap");
    private int \u03b8 = TUIManager.getInt("network.straight.link.offset");
    private int \u03b2 = TUIManager.getInt("network.parallel.link.gap");
    private int \u03c0 = TUIManager.getInt("network.parallel.link.offset");
    private boolean \u03be = TUIManager.getBoolean("network.enable.illegal.link.visible");
    private boolean \u03af = TUIManager.getBoolean("network.apply.background.through.subnetwork");
    private boolean \u03b5 = TUIManager.getBoolean("network.show.link.bundle.handler");
    private boolean \u03b9 = TUIManager.getBoolean("network.link.bundle.compact");
    private boolean \u03b6 = TUIManager.getBoolean("network.link.bundle.alternate");
    protected boolean enableZoomAndPan = TUIManager.getBoolean("web.svg.enable.zoomandpan");
    private boolean \u03ba = TUIManager.getBoolean("network.alarm.balloon.visible");
    private int \u03c2 = 20;
    protected boolean exportBackground = true;
    protected float backgroundFillOpacity = -1.0f;
    private transient ResizableFilter \u03b1 = null;
    private transient List \u03ae;
    private transient List \u03c1;
    private transient List \u03c5;
    private transient Generator \u03ab = null;
    private transient Generator \u03bc = E.A;
    private transient Generator \u03bf = null;
    private transient Generator \u03b3 = null;
    private transient Generator \u03bb = null;
    private transient Generator \u03c4 = null;
    private transient Generator \u03c3 = null;
    private transient Generator \u03b7 = null;
    private SVGBlinkingRule \u03bd = new DefaultSVGBlinkingRule();
    private static final String \u03ad = "twaver.web.svg.network.ui";
    private transient DataBoxListener \u03b0 = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
        }

        public void elementRemoved(DataBoxEvent e2) {
            Element element = e2.getElement();
            TSVGNetwork.this.elementUIs.remove(element);
        }

        public void elementsCleared(DataBoxEvent e2) {
            TSVGNetwork.this.elementUIs.clear();
        }
    };

    public TSVGNetwork() {
        this(new TDataBox());
    }

    public TSVGNetwork(TDataBox box) {
        this.setDataBox(box);
        this.initTransientProperty();
    }

    public Generator getElementBodyColorGenerator() {
        return this.\u03bb;
    }

    public void setElementBodyColorGenerator(Generator elementBodyColorGenerator) {
        this.\u03bb = elementBodyColorGenerator;
    }

    public Generator getElementStateOutlineColorGenerator() {
        return this.\u03b3;
    }

    public void setElementStateOutlineColorGenerator(Generator elementOutlineColorGenerator) {
        this.\u03b3 = elementOutlineColorGenerator;
    }

    public boolean isShowLinkBundleHandler() {
        return this.\u03b5;
    }

    public void setShowLinkBundleHandler(boolean showLinkBundleHandler) {
        this.\u03b5 = showLinkBundleHandler;
    }

    public void setElementLabelGenerator(Generator elementLabelGenerator) {
        this.\u03bf = elementLabelGenerator;
    }

    public Generator getElementLabelGenerator() {
        return this.\u03bf;
    }

    public Generator getElementSelectColorGenerator() {
        return this.\u03bc;
    }

    public Color getElementSelectColor(Element element) {
        return (Color)this.\u03bc.generate(element);
    }

    public void setElementSelectColorGenerator(Generator elementSelectColorGenerator) {
        this.\u03bc = elementSelectColorGenerator == null ? E.A : elementSelectColorGenerator;
    }

    public Generator getElementToolTipTextGenerator() {
        return this.\u03ab;
    }

    public void setElementToolTipTextGenerator(Generator elementToolTipTextGenerator) {
        this.\u03ab = elementToolTipTextGenerator;
    }

    public String getCanvasToolTipText(Element element) {
        Object text = null;
        if (this.\u03ab != null) {
            text = this.\u03ab.generate(element);
        }
        return M.A(text);
    }

    public void setNetworkBackground(Background background) {
        this.box.setBackground(background);
    }

    public Background getNetworkBackground() {
        return this.box.getBackground();
    }

    public boolean isApplyBackgroundThroughSubNetwork() {
        return this.\u03af;
    }

    public void setApplyBackgroundThroughSubNetwork(boolean applyBackgroundThroughSubNetwork) {
        this.\u03af = applyBackgroundThroughSubNetwork;
    }

    public void setCurrentSubNetwork(TSubNetwork currentSubNetwork) {
        this.currentSubNetwork = currentSubNetwork;
    }

    public TSubNetwork getCurrentSubNetwork() {
        return this.currentSubNetwork;
    }

    public Background getCurrentBackground() {
        if (this.currentSubNetwork == null) {
            return this.box.getBackground();
        }
        Background b2 = this.currentSubNetwork.getBackground();
        if (b2 == null && this.\u03af) {
            return this.box.getBackground();
        }
        return b2;
    }

    public void setCurrentBackground(Background background) {
        if (this.currentSubNetwork == null) {
            this.setNetworkBackground(background);
        } else {
            this.currentSubNetwork.setBackground(background);
        }
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.\u03ae.contains(visibleFilter)) {
            this.\u03ae.add(visibleFilter);
        }
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.\u03ae.remove(visibleFilter);
        }
    }

    public List getVisibleFilters() {
        return new ArrayList(this.\u03ae);
    }

    public boolean isVisible(Element element) {
        if (element == null || !this.box.containsByID(element.getID())) {
            return false;
        }
        Iterator it = this.\u03ae.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return this.getDataBox().getLayerModel().isVisible(element);
    }

    public void addMovableFilter(MovableFilter filter) {
        if (filter != null && !this.\u03c1.contains(filter)) {
            this.\u03c1.add(filter);
        }
    }

    public void removeMovableFilter(MovableFilter filter) {
        if (filter != null) {
            this.\u03c1.remove(filter);
        }
    }

    public void clearMovableFilters() {
        this.\u03c1.clear();
    }

    public List getMovableFilters() {
        return new ArrayList(this.\u03c1);
    }

    public boolean isMovable(Element element) {
        if (element instanceof Link) {
            return false;
        }
        Iterator it = this.\u03c1.iterator();
        while (it.hasNext()) {
            MovableFilter filter = (MovableFilter)it.next();
            if (filter.isMovable(element)) continue;
            return false;
        }
        return this.getDataBox().getLayerModel().isMovable(element);
    }

    public void addSelectableFilter(SelectableFilter filter) {
        if (filter != null && !this.\u03c5.contains(filter)) {
            this.\u03c5.add(filter);
        }
    }

    public void removeSelectableFilter(SelectableFilter filter) {
        if (filter != null) {
            this.\u03c5.remove(filter);
        }
    }

    public List getSelectableFilters() {
        return new ArrayList(this.\u03c5);
    }

    public boolean isSelectable(Element element) {
        if (element == null) {
            return false;
        }
        Iterator it = this.\u03c5.iterator();
        while (it.hasNext()) {
            SelectableFilter filter = (SelectableFilter)it.next();
            if (filter.isSelectable(element)) continue;
            return false;
        }
        return this.getDataBox().getLayerModel().isSelectable(element);
    }

    public void setResizableFilter(ResizableFilter resizableFilter) {
        this.\u03b1 = resizableFilter;
    }

    public ResizableFilter getResizableFilter() {
        return this.\u03b1;
    }

    public boolean isResizable(Element element) {
        if (!this.getDataBox().getLayerModel().isResizable(element)) {
            return false;
        }
        return this.\u03b1 != null && this.\u03b1.isResizable(element);
    }

    public boolean isEnableIllegalLinkVisible() {
        return this.\u03be;
    }

    public void setEnableIllegalLinkVisible(boolean enableIllegalLinkVisible) {
        this.\u03be = enableIllegalLinkVisible;
    }

    public void setDataBox(TDataBox box) {
        if (this.box == box) {
            return;
        }
        if (box == null) {
            throw new NullPointerException("Cannot set a null TDataBox.");
        }
        if (this.box != null) {
            this.box.removeDataBoxListener(this.\u03b0);
        }
        this.box = box;
        this.box.addDataBoxListener(this.\u03b0);
    }

    public TDataBox getDataBox() {
        return this.box;
    }

    public void updateTViewUI() {
    }

    protected int[] getNetworkViewPortSize(SVGContext context) {
        Dimension defalutSize = context.getMinBackgroundSize();
        int width = defalutSize.width;
        int height = defalutSize.height;
        return new int[]{width, height};
    }

    public String toSVG() {
        return this.toSVG(new SVGContext());
    }

    public String toSVG(SVGContext context) {
        Iterator it;
        SVGStruct backgroundSVGStruct;
        StringBuffer sb = new StringBuffer();
        Object csnID = this.currentSubNetwork == null ? null : this.currentSubNetwork.getID();
        context.setCurrentSubNetworkID(csnID);
        int[] size = this.getNetworkViewPortSize(context);
        int width = size[0];
        int height = size[1];
        if (this.exportBackground) {
            Rectangle backgroundBounds;
            backgroundSVGStruct = null;
            Background background = this.getCurrentBackground();
            if (background != null) {
                if (background instanceof AbstractBackground) {
                    if (this.backgroundFillOpacity >= 0.0f) {
                        ((AbstractBackground)background).setAlpha(this.backgroundFillOpacity);
                    }
                    if ((backgroundSVGStruct = ((AbstractBackground)background).toSVG(context)).getSvg() != null) {
                        sb.append(backgroundSVGStruct.getSvg());
                    }
                }
            } else {
                ColorBackground colorBackground = new ColorBackground(context.getDefaultBackgroundColor());
                if (this.backgroundFillOpacity >= 0.0f) {
                    colorBackground.setAlpha(this.backgroundFillOpacity);
                }
                backgroundSVGStruct = colorBackground.toSVG(context);
                sb.append(backgroundSVGStruct.getSvg());
            }
            if (context.isSizeByImageBackgroundSize() && background instanceof ImageBackground && (backgroundBounds = backgroundSVGStruct.getBounds()) != null) {
                width = backgroundBounds.width;
                height = backgroundBounds.height;
            }
        } else {
            backgroundSVGStruct = null;
            ColorBackground colorBackground = new ColorBackground(context.getDefaultBackgroundColor());
            colorBackground.setAlpha(this.backgroundFillOpacity);
            backgroundSVGStruct = colorBackground.toSVG(context);
            sb.append(backgroundSVGStruct.getSvg());
        }
        LinkedList<String> messages = new LinkedList<String>();
        LinkedList<String> alarms = new LinkedList<String>();
        LayerModel layerModel = this.box.getLayerModel();
        int layerSize = layerModel.size();
        for (int index = 0; index < layerSize; ++index) {
            Layer layer = layerModel.getLayerByIndex(index);
            it = this.box.listIterator(this.box.size());
            while (it.hasPrevious()) {
                String message;
                String alarm;
                Rectangle structBounds;
                ElementSVGUI ui;
                SVGStruct svgStruct;
                Element element = (Element)it.previous();
                if (!layerModel.contains(element, layer) || !this.isVisible(element) || !this.isOutput(element) || (svgStruct = (ui = this.getElementSVGUI(element)).toSVG(context)) == null) continue;
                if (this.exportBackground && (structBounds = svgStruct.getBounds()) != null) {
                    int structWidth = structBounds.x + structBounds.width + this.\u03c2;
                    width = width > structWidth ? width : structWidth;
                    int structHeight = structBounds.y + structBounds.height + this.\u03c2;
                    height = height > structHeight ? height : structHeight;
                }
                sb.append(svgStruct);
                if (this.\u03ba && (alarm = context.getAlarmAttachmentSVG(element)) != null) {
                    alarms.add(alarm);
                }
                if ((message = context.getMessageAttachmentSVG(element)) == null) continue;
                messages.add(message);
            }
        }
        StringBuffer result = new StringBuffer();
        I.B(context, result);
        result.append("<svg boxid='").append(this.getDataBox().getID()).append("' width='").append(width).append("' height='").append(height).append("' ").append(context.getSVGXMLNS());
        I.A(context, result);
        if (this.box.getUndoRedoManager().canRedo()) {
            result.append(" canRedo = 'true' ");
        }
        if (this.box.getUndoRedoManager().canUndo()) {
            result.append(" canUndo = 'true' ");
        }
        if (!this.enableZoomAndPan) {
            result.append(" zoomAndPan='disable'");
        }
        if (!context.isEnableInteract()) {
            I.C(result);
        }
        context.D(result);
        TSVGNetwork.C(result);
        TSVGNetwork.B(result);
        result.append(" CSNID='" + csnID + "'");
        result.append(" >");
        context.B(result);
        result.append("<defs id='").append(context.getDefsNodeID()).append("'>");
        context.appendGradientDefinitionSVG(result);
        context.E(result);
        context.A(result);
        context.G(result);
        context.C(result);
        result.append("</defs>");
        result.append("<g ");
        result.append(" id='").append(context.getOutGNodeID()).append("' ");
        context.F(result);
        result.append(">\n");
        result.append(sb);
        Iterator itm = messages.iterator();
        while (itm.hasNext()) {
            result.append(itm.next());
        }
        it = alarms.iterator();
        while (it.hasNext()) {
            result.append(it.next());
        }
        result.append("</g>");
        twaver.base.A.G.C.A(context, result);
        result.append("</svg>");
        context.A();
        return result.toString();
    }

    private static void C(StringBuffer result) {
        result.append(" twaverlicense='" + twaver.base.A.G.C.E().O() + "'");
    }

    private static void B(StringBuffer result) {
        result.append(" twaverinformation ='" + twaver.base.A.G.C.E().A() + "'");
    }

    protected boolean isOutput(Element element) {
        return true;
    }

    public ElementSVGUI getElementSVGUI(Element element) {
        ElementSVGUI ui = (ElementSVGUI)this.elementUIs.get(element);
        if (ui == null) {
            if (!this.box.contains(element)) {
                return null;
            }
            String uiClassID = element.getSVGUIClassID();
            try {
                Object[] params = new Object[]{this, element};
                Class clazz = H.A(uiClassID, \u03ad);
                ui = (ElementSVGUI)clazz.getConstructors()[0].newInstance(params);
                if (ui != null) {
                    this.elementUIs.put(element, ui);
                }
            }
            catch (Exception ex) {
                TWaverUtil.handleError("Can't load UI class '" + uiClassID + "'.", ex);
            }
        }
        return ui;
    }

    public boolean isLinkBundleCompact() {
        return this.\u03b9;
    }

    public void setLinkBundleCompact(boolean isLinkBundleCompact) {
        this.\u03b9 = isLinkBundleCompact;
    }

    public boolean isEnableZoomAndPan() {
        return this.enableZoomAndPan;
    }

    public void setEnableZoomAndPan(boolean enableZoomAndPan) {
        this.enableZoomAndPan = enableZoomAndPan;
    }

    public void setStraightLinkGap(int straightLinkGap) {
        this.\u03b4 = straightLinkGap;
    }

    public int getStraightLinkGap() {
        return this.\u03b4;
    }

    public void setStraightLinkOffset(int straightLinkOffset) {
        this.\u03b8 = straightLinkOffset;
    }

    public int getStraightLinkOffset() {
        return this.\u03b8;
    }

    public void setParallelLinkGap(int parallelLinkGap) {
        this.\u03b2 = parallelLinkGap;
    }

    public int getParallelLinkGap() {
        return this.\u03b2;
    }

    public void setParallelLinkOffset(int parallelLinkOffset) {
        this.\u03c0 = parallelLinkOffset;
    }

    public int getParallelLinkOffset() {
        return this.\u03c0;
    }

    public Generator getMessageContentGenerator() {
        return this.\u03b7;
    }

    public void setMessageContentGenerator(Generator messageContentGenerator) {
        this.\u03b7 = messageContentGenerator;
    }

    public String getMessageContent(Element element) {
        Generator generator = this.getMessageContentGenerator();
        if (generator == null) {
            return b.Q(element, "message.content");
        }
        return (String)generator.generate(element);
    }

    public float getBackgroundFillOpacity() {
        return this.backgroundFillOpacity;
    }

    public void setBackgroundFillOpacity(float backgroundFillOpacity) {
        this.backgroundFillOpacity = backgroundFillOpacity;
    }

    public void setImageBackground(String imageURL) {
        this.setBackground(new ImageBackground(imageURL));
    }

    public void setBackground(Background background) {
        this.box.setBackground(background);
    }

    public SVGBlinkingRule getBlinkingRule() {
        return this.\u03bd;
    }

    public void setBlinkingRule(SVGBlinkingRule blinkingRule) {
        this.\u03bd = blinkingRule;
    }

    public boolean isAlarmBalloonVisible() {
        return this.\u03ba;
    }

    public void setAlarmBalloonVisible(boolean alarmBalloonVisible) {
        this.\u03ba = alarmBalloonVisible;
    }

    public void layoutToRectangle(Rectangle rect) {
        this.layoutToRectangle(rect, true);
    }

    public Generator getAlarmLabelGenerator() {
        return this.\u03c4;
    }

    public void setAlarmLabelGenerator(Generator alarmLabelGenerator) {
        this.\u03c4 = alarmLabelGenerator;
    }

    public Generator getAlarmColorGenerator() {
        return this.\u03c3;
    }

    public void setAlarmColorGenerator(Generator alarmColorGenerator) {
        this.\u03c3 = alarmColorGenerator;
    }

    public void layoutToRectangle(Rectangle rect, boolean distort) {
        Element element;
        double width = 0.0;
        double height = 0.0;
        LayerModel layerModel = this.box.getLayerModel();
        int layerSize = layerModel.size();
        for (int index = 0; index < layerSize; ++index) {
            Layer layer = layerModel.getLayerByIndex(index);
            ListIterator it = this.box.listIterator(this.box.size());
            while (it.hasPrevious()) {
                Element element2 = (Element)it.previous();
                if (!layerModel.contains(element2, layer) || !this.isVisible(element2)) continue;
                double x = element2.getX() + (double)element2.getWidth();
                double y = element2.getY() + (double)element2.getHeight();
                width = width > x ? width : x;
                height = height > y ? height : y;
            }
        }
        double xf = rect.getWidth() / width;
        double yf = rect.getHeight() / height;
        if (!distort) {
            double factor;
            xf = factor = Math.min(xf, yf);
            yf = factor;
        }
        double xFactor = xf;
        double yFactor = yf;
        double startX = rect.getX();
        double startY = rect.getY();
        List<Element> list = new ArrayList();
        Iterator it = this.box.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (!this.isVisible(element) || !this.isMovable(element)) continue;
            list.add(element);
        }
        list = TWaverUtil.filterMovingElements(list.iterator());
        it = list.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            Point point = element.getCenterLocation();
            if (point == null) continue;
            element.setCenterLocation(startX + point.getX() * xFactor, startY + point.getY() * yFactor);
        }
    }

    public boolean isLinkBundleAlternate() {
        return this.\u03b6;
    }

    public void setLinkBundleAlternate(boolean isLinkBundleAlternate) {
        this.\u03b6 = isLinkBundleAlternate;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientProperty();
    }

    protected void initTransientProperty() {
        this.\u03ae = new LinkedList();
        this.\u03c1 = new LinkedList();
        this.\u03c5 = new LinkedList();
        this.\u03ab = TUIManager.getElementToolTipTextGenerator();
        this.\u03bc = E.A;
        this.\u03bf = TUIManager.getElementNetworkLabelGenerator();
        this.\u03b3 = TUIManager.getElementStateOutlineColorGenerator();
        this.\u03bb = TUIManager.getElementBodyColorGenerator();
        this.\u03c4 = TUIManager.getAlarmLabelGenerator();
        this.\u03c3 = TUIManager.getAlarmColorGenerator();
        this.\u03ae.add(new C(this));
        this.\u03c1.add(F.A);
    }

    public void sendToTop(Element element) {
        m.A(this, element);
    }

    public String getType() {
        return this.\u03ac;
    }

    public void setType(String type) {
        this.\u03ac = type;
    }
}

