/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.TDataBox;
import twaver.TWaverUtil;
import twaver.Task;
import twaver.TaskAdapter;
import twaver.ZoomListener;
import twaver.base.A.D.B.E;
import twaver.base.A.E.D;
import twaver.network.PaintAttachmentFilter;
import twaver.network.TNetwork;

public class OverviewPane
extends JPanel {
    static final String N = "update.overview";
    public static final int FILL_NONE_SIDE = 0;
    public static final int FILL_ONE_SIDE = 1;
    public static final int FILL_BOTH_SIDE = 2;
    private static final Map V = new HashMap();
    private static final Map J = new HashMap();
    private TNetwork c;
    private int Y = 1;
    private PropertyChangeListener W = null;
    private PropertyChangeListener A = null;
    private DataBoxListener F = null;
    private ChangeListener Z = null;
    private PropertyChangeListener P = null;
    private ZoomListener C = null;
    private double d;
    private double b;
    private double D;
    private double M;
    private double G;
    private double E;
    private double T;
    private double B;
    private Point S = null;
    private Point X = null;
    private boolean O = true;
    private int a = 1000;
    private boolean L = true;
    private Color I = new Color(200, 200, 200, 210);
    private boolean U = true;
    private Color R = new Color(150, 150, 150);
    private int K = 250;
    private int _ = 250;
    private BufferedImage Q = null;
    private PaintAttachmentFilter H = null;

    public OverviewPane(TNetwork network) {
        this(network, 250, 250);
    }

    public OverviewPane(TNetwork network, int width, int height) {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                OverviewPane.this.B();
            }

            public void componentShown(ComponentEvent e2) {
                OverviewPane.this.B();
            }
        });
        this.W = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (OverviewPane.this.A(evt.getPropertyName())) {
                    OverviewPane.this.O = true;
                }
            }
        };
        this.A = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("background".equals(evt.getPropertyName())) {
                    OverviewPane.this.O = true;
                }
            }
        };
        this.F = new DataBoxListener(){

            public void elementAdded(DataBoxEvent e2) {
                OverviewPane.this.O = true;
            }

            public void elementRemoved(DataBoxEvent e2) {
                OverviewPane.this.O = true;
            }

            public void elementsCleared(DataBoxEvent e2) {
                OverviewPane.this.O = true;
            }
        };
        this.Z = new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                OverviewPane.this.repaint();
            }
        };
        this.C = new ZoomListener(){

            public void zoomChanged(double oldZoomer, double newZoomer) {
                OverviewPane.this.B();
            }
        };
        this.P = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (!V.containsKey(propertyName)) {
                    return;
                }
                if (propertyName.equals("databox")) {
                    TDataBox box = (TDataBox)evt.getOldValue();
                    if (box != null) {
                        box.removePropertyChangeListener(OverviewPane.this.A);
                        box.removeElementPropertyChangeListener(OverviewPane.this.W);
                        box.removeDataBoxListener(OverviewPane.this.F);
                    }
                    if ((box = (TDataBox)evt.getNewValue()) != null) {
                        box.addPropertyChangeListener(OverviewPane.this.A);
                        box.addElementPropertyChangeListener(OverviewPane.this.W);
                        box.addDataBoxListener(OverviewPane.this.F);
                    }
                }
                OverviewPane.this.O = true;
            }
        };
        this.setNetwork(network);
        this.A();
        this.A(width, height);
        this.A(new TaskAdapter(){

            public void run(long clock) {
                if (OverviewPane.this.c != null && OverviewPane.this.O && OverviewPane.this.isShowing()) {
                    OverviewPane.this.B();
                }
            }

            public int getInterval() {
                return OverviewPane.this.a;
            }
        });
    }

    private void A(final Task task) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e2) {
                if (OverviewPane.this.isShowing()) {
                    twaver.base.A.D.B.E.B().A().register(task);
                    OverviewPane.this.B();
                } else {
                    twaver.base.A.D.B.E.B().A().unregister(task);
                }
            }
        });
    }

    private void A(int imageWidth, int imageHeight) {
        this.K = imageWidth;
        this._ = imageHeight;
        this.Q = null;
        this.repaint();
    }

    private void A() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                if (OverviewPane.this.getNetwork() == null) {
                    return;
                }
                OverviewPane.this.S = null;
                OverviewPane.this.X = null;
                if (SwingUtilities.isRightMouseButton(e2)) {
                    Point point = e2.getPoint();
                    if (OverviewPane.this.A(point)) {
                        OverviewPane.this.S = new Point(point.x - (int)OverviewPane.this.G, point.y - (int)OverviewPane.this.E);
                    }
                } else {
                    if (e2.getClickCount() == 2 && OverviewPane.this.getNetwork() != null) {
                        OverviewPane.this.getNetwork().getZoomer().zoomReset();
                    }
                    OverviewPane.this.A(e2);
                }
                OverviewPane.this.repaint();
            }

            public void mouseReleased(MouseEvent e2) {
                if (OverviewPane.this.getNetwork() == null) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e2)) {
                    Rectangle rect = TWaverUtil.getRectangle(OverviewPane.this.S, OverviewPane.this.X);
                    if (twaver.base.A.E.D.A(rect) > 10.0) {
                        double zoom = OverviewPane.this.getNetwork().getZoomer().getZoom();
                        rect.x = (int)((double)rect.x / OverviewPane.this.d * zoom);
                        rect.y = (int)((double)rect.y / OverviewPane.this.b * zoom);
                        rect.width = (int)((double)rect.width / OverviewPane.this.d * zoom);
                        rect.height = (int)((double)rect.height / OverviewPane.this.b * zoom);
                        OverviewPane.this.getNetwork().getZoomer().zoomToRect(rect);
                    } else {
                        JPopupMenu popupMenu = OverviewPane.this.getPopupMenu();
                        if (popupMenu != null) {
                            popupMenu.show(OverviewPane.this, e2.getPoint().x, e2.getPoint().y);
                        }
                    }
                }
                OverviewPane.this.S = null;
                OverviewPane.this.X = null;
                OverviewPane.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e2) {
                if (OverviewPane.this.getNetwork() == null) {
                    return;
                }
                if (OverviewPane.this.S != null) {
                    Point point = e2.getPoint();
                    if (OverviewPane.this.A(point)) {
                        OverviewPane.this.X = new Point(point.x - (int)OverviewPane.this.G, point.y - (int)OverviewPane.this.E);
                    }
                } else {
                    OverviewPane.this.A(e2);
                }
                OverviewPane.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e2) {
                if (OverviewPane.this.getNetwork() == null) {
                    return;
                }
                OverviewPane.this.A(e2);
                OverviewPane.this.repaint();
            }
        });
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenu menu = new JMenu(TWaverUtil.getString("Overview.FillMode"));
        popupMenu.add(menu);
        ButtonGroup group = new ButtonGroup();
        JMenuItem item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.FillNoneSide"), this.Y == 0);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setFillMode(0);
            }
        });
        item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.FillOneSide"), this.Y == 1);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setFillMode(1);
            }
        });
        item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.FillBothSide"), this.Y == 2);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setFillMode(2);
            }
        });
        menu = new JMenu(TWaverUtil.getString("Overview.UpdateInterval"));
        popupMenu.add(menu);
        group = new ButtonGroup();
        item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.50ms"), this.a == 50);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setUpdateInterval(50);
            }
        });
        item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.500ms"), this.a == 500);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setUpdateInterval(500);
            }
        });
        item = new JRadioButtonMenuItem(TWaverUtil.getString("Overview.1000ms"), this.a == 1000);
        menu.add(item);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setUpdateInterval(1000);
            }
        });
        item = new JCheckBoxMenuItem(TWaverUtil.getString("Overview.ViewMask"), this.L);
        popupMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setViewMask(((JCheckBoxMenuItem)e2.getSource()).isSelected());
            }
        });
        item = new JCheckBoxMenuItem(TWaverUtil.getString("Overview.ViewBorder"), this.U);
        popupMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                OverviewPane.this.setViewBorder(((JCheckBoxMenuItem)e2.getSource()).isSelected());
            }
        });
        return popupMenu;
    }

    private boolean A(String propertyName) {
        return J.containsKey(propertyName);
    }

    private boolean A(Point point) {
        if (this.c != null) {
            double x = (double)point.x - this.G;
            double y = (double)point.y - this.E;
            if (x >= 0.0 && y >= 0.0 && x <= this.D && y <= this.M) {
                return true;
            }
        }
        return false;
    }

    private void A(MouseEvent e2) {
        if (this.c != null) {
            Point point = e2.getPoint();
            double x = (double)point.x - this.G;
            double y = (double)point.y - this.E;
            if (x >= 0.0 && y >= 0.0 && x <= this.D && y <= this.M) {
                Point centerPoint = new Point((int)(x / this.d), (int)(y / this.b));
                this.c.setLogicalCenterPoint(centerPoint);
            }
        }
    }

    private void A(MouseWheelEvent e2) {
        if (this.c != null) {
            if (e2.getWheelRotation() > 0) {
                this.c.getZoomer().wheelZoomOut();
            } else {
                this.c.getZoomer().wheelZoomIn();
            }
        }
    }

    public TNetwork getNetwork() {
        return this.c;
    }

    public void setNetwork(TNetwork network) {
        TDataBox box;
        if (this.c != null) {
            this.c.getCanvasScrollPane().getViewport().removeChangeListener(this.Z);
            this.c.removePropertyChangeListener(this.P);
            this.c.getZoomer().removeZoomListener(this.C);
            box = this.c.getDataBox();
            if (box != null) {
                box.removePropertyChangeListener(this.A);
                box.removeElementPropertyChangeListener(this.W);
                box.removeDataBoxListener(this.F);
            }
        }
        this.c = network;
        if (this.c != null) {
            this.c.getCanvasScrollPane().getViewport().addChangeListener(this.Z);
            this.c.addPropertyChangeListener(this.P);
            this.c.getZoomer().addZoomListener(this.C);
            box = this.c.getDataBox();
            if (box != null) {
                box.addPropertyChangeListener(this.A);
                box.addElementPropertyChangeListener(this.W);
                box.addDataBoxListener(this.F);
            }
        }
    }

    private void B() {
        if (this.Q == null || this.c == null) {
            return;
        }
        Dimension size = new Dimension(this.getWidth() - 1, this.getHeight() - 1);
        if (size.height <= 0 || size.width <= 0) {
            return;
        }
        if (size.width > this.K) {
            size.width = this.K;
        }
        if (size.height > this._) {
            size.height = this._;
        }
        double zoom = this.c.getZoom();
        double networkWidth = (double)this.c.getCanvas().getWidth() / zoom;
        double networkHeight = (double)this.c.getCanvas().getHeight() / zoom;
        this.T = size.getWidth();
        this.B = this.T / networkWidth * networkHeight;
        if (this.B > size.getHeight()) {
            this.B = size.getHeight();
            this.T = this.B / networkHeight * networkWidth;
        }
        zoom = this.T / networkWidth;
        Graphics2D g2 = (Graphics2D)this.Q.getGraphics();
        g2.setColor(this.c.getCanvas().getBackground());
        g2.fillRect(0, 0, (int)this.T, (int)this.B);
        PaintAttachmentFilter oldValue = this.c.getPaintAttachmentFilter();
        this.c.setPaintAttachmentFilter(this.H);
        this.c.setPaintState(1);
        this.c.paintNetworkContent(g2, zoom, zoom, false);
        this.c.setPaintState(0);
        this.c.setPaintAttachmentFilter(oldValue);
        if (this.Y == 0) {
            this.G = ((double)this.getWidth() - this.T) / 2.0;
            this.E = ((double)this.getHeight() - this.B) / 2.0;
            this.D = this.T;
            this.M = this.B;
        } else if (this.Y == 1) {
            this.G = 0.0;
            this.D = this.getWidth();
            this.M = (double)this.getWidth() / this.T * this.B;
            this.E = ((double)this.getHeight() - this.M) / 2.0;
            if (this.E < 0.0) {
                this.E = 0.0;
                this.M = this.getHeight();
                this.D = (double)this.getHeight() / this.B * this.T;
                this.G = ((double)this.getWidth() - this.D) / 2.0;
            }
        } else {
            this.G = 0.0;
            this.E = 0.0;
            this.D = this.getWidth();
            this.M = this.getHeight();
        }
        this.d = this.D / networkWidth;
        this.b = this.M / networkHeight;
        this.O = false;
        this.repaint();
    }

    public void paintComponent(Graphics g2) {
        Rectangle zoomToRect;
        super.paintComponent(g2);
        if (!this.isShowing() || this.c == null) {
            return;
        }
        if (this.Q == null) {
            this.Q = new BufferedImage(this.K, this._, 2);
            this.B();
        }
        Graphics2D g22 = (Graphics2D)g2;
        Rectangle clipBounds = new Rectangle((int)this.G, (int)this.E, (int)this.D + 1, (int)this.M + 1);
        if (this.Y != 2) {
            Area area = new Area(new Rectangle(this.getWidth(), this.getHeight()));
            area.subtract(new Area(clipBounds));
            g22.setColor(Color.BLACK);
            g22.fill(area);
        }
        g22.drawImage(this.Q, (int)this.G, (int)this.E, (int)(this.G + this.D), (int)(this.E + this.M), 0, 0, (int)this.T, (int)this.B, this);
        double zoom = this.c.getZoom();
        JViewport viewPort = this.c.getCanvasScrollPane().getViewport();
        double x = viewPort.getViewPosition().getX() / zoom * this.d;
        double y = viewPort.getViewPosition().getY() / zoom * this.b;
        double width = (double)viewPort.getWidth() / zoom * this.d;
        double height = (double)viewPort.getHeight() / zoom * this.b;
        Rectangle2D.Double rect = new Rectangle2D.Double(this.G + x, this.E + y, width - 1.0, height - 1.0);
        if (this.L) {
            g22.setColor(this.I);
            Area coveredArea = new Area(clipBounds);
            coveredArea.subtract(new Area(rect));
            g22.fill(coveredArea);
        }
        if (this.U) {
            g22.setXORMode(this.R);
            g22.draw(rect);
        }
        if ((zoomToRect = TWaverUtil.getRectangle(this.S, this.X)) != null) {
            zoomToRect.x = (int)((double)zoomToRect.x + this.G);
            zoomToRect.y = (int)((double)zoomToRect.y + this.E);
            g22.setXORMode(this.R);
            g22.draw(zoomToRect);
        }
    }

    public boolean hasViewBorder() {
        return this.U;
    }

    public void setViewBorder(boolean viewBorder) {
        this.U = viewBorder;
        this.repaint();
    }

    public Color getViewBorderColor() {
        return this.R;
    }

    public void setViewBorderColor(Color viewBorderColor) {
        this.R = viewBorderColor;
        this.repaint();
    }

    public boolean hasViewMask() {
        return this.L;
    }

    public void setViewMask(boolean viewMask) {
        this.L = viewMask;
        this.repaint();
    }

    public Color getViewMaskColor() {
        return this.I;
    }

    public void setViewMaskColor(Color viewMaskColor) {
        this.I = viewMaskColor;
        this.repaint();
    }

    public int getUpdateInterval() {
        return this.a;
    }

    public void setUpdateInterval(int updateInterval) {
        this.a = updateInterval;
    }

    public int getFillMode() {
        return this.Y;
    }

    public void setFillMode(int fillMode) {
        if (fillMode == 0 || fillMode == 1 || fillMode == 2) {
            this.Y = fillMode;
            this.B();
        }
    }

    public PaintAttachmentFilter getPaintAttachmentFilter() {
        return this.H;
    }

    public void setPaintAttachmentFilter(PaintAttachmentFilter paintAttachmentFilter) {
        this.H = paintAttachmentFilter;
    }

    static {
        V.put("databox", null);
        V.put("currentSubNetwork", null);
        V.put(N, null);
        J.put("background", null);
        J.put("selected", null);
        J.put("location", null);
        J.put("expand", null);
    }
}

