/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import twaver.ShapeNode;
import twaver.TWaverUtil;

public class ShapeImage
extends ShapeNode {
    private ImageIcon U = null;
    private BufferedImage T = null;

    public ShapeImage() {
        this.J();
    }

    public ShapeImage(Object id) {
        super(id);
        this.J();
    }

    private void J() {
        this.setShapeNodeType(2);
        this.getClientProperties().put("custom.draw.fill", Boolean.FALSE);
        this.getClientProperties().put("custom.draw.outline", Boolean.FALSE);
        this.getClientProperties().put("custom.draw.outline.stroke", "solid.middle");
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        points.add(new Point2D.Double(50.0, 50.0));
        points.add(new Point2D.Double(100.0, 50.0));
        points.add(new Point2D.Double(100.0, 150.0));
        points.add(new Point2D.Double(50.0, 150.0));
        this.setPoints(points);
    }

    public String getUIClassID() {
        return "ShapeImageUI";
    }

    public ImageIcon getCachedImage() {
        ImageIcon imageIcon;
        if (this.U != null) {
            return this.U;
        }
        if (this.points.size() == 4 && (imageIcon = this.getImage()) != null) {
            if (this.T == null) {
                this.T = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
                Graphics2D g2 = this.T.createGraphics();
                g2.drawImage(imageIcon.getImage(), 0, 0, null);
                g2.dispose();
            }
            this.U = TWaverUtil.createDistortedImage(this.T, this.getPoint(0).getX(), this.getPoint(0).getY(), this.getPoint(1).getX(), this.getPoint(1).getY(), this.getPoint(2).getX(), this.getPoint(2).getY(), this.getPoint(3).getX(), this.getPoint(3).getY());
        }
        return this.U;
    }

    public void invalidateCachedImage() {
        this.U = null;
        this.T = null;
    }

    public void firePointsChange() {
        super.firePointsChange();
        this.U = null;
    }

    public void setImage(String url) {
        super.setImage(url);
        this.invalidateCachedImage();
    }
}

