/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.gadget;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import twaver.A.A.A.A;
import twaver.GeoCoordinate;
import twaver.gis.GeographyMap;
import twaver.gis.event.MapEvent;
import twaver.gis.event.MapListener;
import twaver.gis.utils.GisToolkits;
import twaver.swing.TableLayout;

public class StatusBar
extends JPanel
implements MouseListener,
MouseMotionListener,
MapListener {
    private ArrayList F;
    private JLabel E;
    private JLabel H;
    private JLabel G;
    private GeographyMap B;
    private JComponent C;
    private JLabel A;
    private static final String D = "";
    private MapListener J;
    boolean I;

    public StatusBar(GeographyMap map, JComponent container) {
        this.E();
        this.setMap(map);
        this.F = new ArrayList();
        this.setContainer(container);
        this.D();
    }

    private void D() {
        this.J = new MapListener(){

            public void mapChanged(MapEvent evt) {
                if (5 == StatusBar.this.B.getMapMode()) {
                    StatusBar.this.F.clear();
                    StatusBar.this.setDistance(StatusBar.this.caculateDistance());
                }
            }
        };
        this.B.addMapListener(this.J);
    }

    private void A() {
        double[] col = new double[]{-1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0};
        double[] row = new double[]{-2.0};
        this.setLayout((LayoutManager)new TableLayout(col, row));
        this.add((Component)this.G, "0,0");
        this.add((Component)new JSeparator(1), "1,0");
        this.add((Component)this.E, "2,0");
        this.add((Component)new JSeparator(1), "3,0");
        this.add((Component)this.H, "4,0");
        this.add((Component)new JSeparator(1), "5,0");
        this.add((Component)this.A, "6,0");
    }

    private void E() {
        this.A = new JLabel("             ");
        this.G = new JLabel(this.C());
        this.E = new JLabel(String.valueOf(twaver.A.A.A.A.E("longitude")) + " : ");
        this.H = new JLabel(String.valueOf(twaver.A.A.A.A.E("latitude")) + " : ");
        this.A();
    }

    public void setContainer(JComponent container) {
        if (this.C != null) {
            this.C.removeMouseMotionListener(this);
            this.C.removeMouseListener(this);
        }
        this.C = container;
        if (this.C != null) {
            this.C.addMouseListener(this);
            this.C.addMouseMotionListener(this);
        }
    }

    public void setMap(GeographyMap map) {
        if (this.B != null) {
            this.B.removeMapListener(this);
        }
        this.B = map;
        if (this.B != null) {
            this.B.addMapListener(this);
            this.setScale(map.getZoom());
        }
    }

    private String A(double value) {
        if (value >= 0.0) {
            return twaver.A.A.A.A.E("eastlongitude");
        }
        return twaver.A.A.A.A.E("westlongitude");
    }

    private String B(double value) {
        if (value >= 0.0) {
            return twaver.A.A.A.A.E("northlatitude");
        }
        return twaver.A.A.A.A.E("southlatitude");
    }

    static double[] C(double degree) {
        double[] result = new double[3];
        degree = Math.abs(degree);
        result[0] = Math.floor(degree);
        double decimalPart = degree - result[0];
        result[1] = Math.floor(decimalPart *= 60.0);
        result[2] = (decimalPart -= result[1]) * 60.0;
        return result;
    }

    public void setxValue(double value) {
        double[] dms = StatusBar.C(value);
        String result = this.A(value);
        dms[2] = Math.round(dms[2]);
        result = String.valueOf((int)dms[0]) + "&ordm;" + (int)dms[1] + "'" + (int)dms[2] + "\" " + result + "</html>";
        this.E.setText("<html>" + twaver.A.A.A.A.E("longitude") + ": " + result);
    }

    public void setyValue(double value) {
        double[] dms = StatusBar.C(value);
        String result = this.B(value);
        dms[2] = Math.round(dms[2]);
        result = String.valueOf((int)dms[0]) + "&ordm;" + (int)dms[1] + "'" + (int)dms[2] + "\" " + result + "</html>";
        this.H.setText("<html>" + twaver.A.A.A.A.E("latitude") + ": " + result);
    }

    public void setScale(int scale) {
        this.G.setText(String.valueOf(this.C()) + scale);
    }

    private String C() {
        if (this.B != null) {
            return String.valueOf(twaver.A.A.A.A.E("ZoomLevel")) + " :";
        }
        return D;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.B == null) {
            return;
        }
        GeoCoordinate co = GisToolkits.convertScreenToLatLong(this.B, e.getPoint());
        if (co != null) {
            this.setxValue(co.getLongitude());
            this.setyValue(co.getLatitude());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.B.getMapMode() != 5) {
            return;
        }
        int clickCount = e.getClickCount();
        if (clickCount == 1) {
            this.F.add(e.getPoint());
            this.setDistance(this.caculateDistance());
        } else if (clickCount == 2) {
            this.setDistance(this.caculateDistance());
            this.F.clear();
            JOptionPane.showMessageDialog(null, this.A.getText());
        }
    }

    public double caculateDistance() {
        if (this.F.size() == 0) {
            return 0.0;
        }
        Point start = (Point)this.F.get(0);
        int length = this.F.size();
        GeoCoordinate startGeo = GisToolkits.convertScreenToLatLong(this.B, start);
        double distance = 0.0;
        int i = 1;
        while (i < length) {
            Point point = (Point)this.F.get(i);
            GeoCoordinate toGeo = GisToolkits.convertScreenToLatLong(this.B, point);
            distance += this.B.getDistance(startGeo.getLongitude(), startGeo.getLatitude(), toGeo.getLongitude(), toGeo.getLatitude());
            startGeo = toGeo;
            ++i;
        }
        return distance;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setDistance(double distance) {
        double result = distance / 1000.0;
        result = (double)((int)(result * 100.0)) / 100.0;
        this.A.setText(String.valueOf(twaver.A.A.A.A.E("distance")) + " : " + result + " " + twaver.A.A.A.A.E("kilometer"));
    }

    private void B() {
        this.F.clear();
        this.A.setText(D);
    }

    public void mapChanged(MapEvent evt) {
        int type = evt.getEventType();
        if (type == 5 && this.B.getMapMode() != 5) {
            this.B();
        }
        if (type == 3) {
            this.setScale(this.B.getZoom());
        }
    }
}

