/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.AlarmStateStatistics;
import twaver.TDataBox;
import twaver.TWaverConst;
import twaver.chart.Item;
import twaver.web.TWebView;
import twaver.web.svg.chart.SVGBarChart;
import twaver.web.svg.chart.SVGPieChart;
import twaver.web.svg.network.SVGContext;
import twaver.web.table.TWebAlarmStatTable;

public class TSVGAlarmOverview
implements TWebView {
    private String \u01c8 = "alarmoverview";
    private TDataBox \u01c4 = new TDataBox();
    private TDataBox \u01c9 = new TDataBox();
    private boolean \u01ca = false;
    private AlarmStateStatistics \u01c1;
    private List \u01c6;
    private SVGBarChart \u01c7;
    private SVGPieChart \u01c2;
    private TWebAlarmStatTable \u01c5;
    private AlarmSeverityChangeListener \u01c3 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            Iterator it = TSVGAlarmOverview.this.\u01c9.iterator();
            while (it.hasNext()) {
                Item item = (Item)it.next();
                AlarmSeverity severity = (AlarmSeverity)item.getUserObject();
                item.setColor(severity.getColor());
                item.setName(severity.getNickName());
            }
            return false;
        }
    };

    public boolean isTextEscape() {
        return this.\u01ca;
    }

    public void setTextEscape(boolean textEscape) {
        this.\u01ca = textEscape;
    }

    public TSVGAlarmOverview(TDataBox box) {
        this(box, null);
    }

    public TSVGAlarmOverview(TDataBox box, List alarmSeverities) {
        this.A(alarmSeverities);
        this.setDataBox(box);
        this.\u01c7 = new SVGBarChart(this.\u01c9);
        this.\u01c2 = new SVGPieChart(this.\u01c9);
        this.\u01c5 = new TWebAlarmStatTable(box);
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u01c3);
    }

    private void A(List alarmSeverities) {
        this.\u01c6 = alarmSeverities;
        if (alarmSeverities == null) {
            this.\u01c6 = AlarmSeverity.getAllSeverity();
        }
    }

    public void setDataBox(TDataBox box) {
        this.\u01c4 = box;
        this.\u01c1 = new AlarmStateStatistics(box, this.\u01c6);
        PropertyChangeSupport support = this.\u01c1.getPropertyChangeSupport();
        support.addPropertyChangeListener("alarmstate", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TSVGAlarmOverview.this.updateTViewUI();
            }
        });
        this.updateTViewUI();
    }

    public TDataBox getDataBox() {
        return this.\u01c4;
    }

    private void L() {
        this.\u01c9.clear();
        Iterator it = this.\u01c1.getSeverityList().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            Item item = new Item(severity.getNickName(), 0.0, severity.getColor(), null, TWaverConst.DEFAULT_INT_FORMATER);
            item.setUserObject(severity);
            this.\u01c9.addElement(item);
        }
    }

    public void updateTViewUI() {
        this.L();
        Iterator it = this.\u01c9.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            AlarmSeverity severity = (AlarmSeverity)item.getUserObject();
            int totalCount = this.\u01c1.getTotalAlarmCount(severity);
            item.setValue(totalCount);
        }
    }

    public String toBarChartSVG(SVGContext context, int width, int height) {
        return this.\u01c7.toSVG(context, width, height);
    }

    public String toPieChartSVG(SVGContext context, int width, int height) {
        return this.\u01c2.toSVG(context, width, height);
    }

    public SVGBarChart getBarChart() {
        return this.\u01c7;
    }

    public SVGPieChart getPieChart() {
        return this.\u01c2;
    }

    public String toXML(int width, int height) {
        return this.toXML(new SVGContext(), width, height);
    }

    public String toXML(SVGContext context, int width, int height) {
        if (context == null) {
            context = new SVGContext();
        }
        context.setSvgHeader(false);
        StringBuffer result = new StringBuffer();
        result.append("<twaver." + this.\u01c5.getType() + ">");
        if (this.isTextEscape()) {
            result.append("<![CDATA[");
        }
        result.append(this.\u01c5.toJSON());
        if (this.isTextEscape()) {
            result.append("]]>");
        }
        result.append("</twaver." + this.\u01c5.getType() + ">");
        result.append("<twaver.alarmOverviewPieChart>");
        result.append(this.\u01c2.toSVG(context, width, height));
        result.append("</twaver.alarmOverviewPieChart>");
        result.append("<twaver.alarmOverviewBarChart>");
        result.append(this.\u01c7.toSVG(context, width, height));
        result.append("</twaver.alarmOverviewBarChart>");
        return result.toString();
    }

    public String getType() {
        return this.\u01c8;
    }

    public void setType(String type) {
        this.\u01c8 = type;
    }
}

