/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.statusbar;

import com.nepxion.swing.border.ButtonBorder;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.swing.statusbar.JStatusItem;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class JStatusBar
extends JBasicToolBar
implements SwingConstants {
    private JPanel leftPanel = new JPanel();
    private JPanel rightPanel;
    private int leftIndex = 0;
    private int rightIndex = 0;
    private int separatorHeight = 17;
    private boolean isCornerVisible = true;

    public JStatusBar() {
        this.leftPanel.setOpaque(false);
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
        this.rightPanel = new JPanel();
        this.rightPanel.setOpaque(false);
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
        this.add(this.leftPanel);
        this.add(Box.createHorizontalGlue());
        this.add(this.rightPanel);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorderVisible(true);
    }

    @Override
    public void setBorderVisible(boolean isBorderVisible) {
        if (isBorderVisible) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 23));
            this.setBorder(new ButtonBorder(1));
        } else {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 21));
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setCornerVisible(boolean isCornerVisible) {
        this.isCornerVisible = isCornerVisible;
    }

    public void setSeparatorHeight(int separatorHeight) {
        this.separatorHeight = separatorHeight;
    }

    public void addItem(JStatusItem item, int width) {
        this.addItem(item, width, true);
    }

    public void addItem(JStatusItem item, int width, boolean isSeparator) {
        this.addItem(item, width, 2, isSeparator);
    }

    public void addItem(JStatusItem item, int width, int justification) {
        this.addItem(item, width, justification, true);
    }

    public void addItem(JStatusItem item, int width, int justification, boolean isSeparator) {
        this.addItem(item, width, justification, "RaisedStyle", isSeparator);
    }

    public void addItem(JStatusItem item, int width, int justification, String style) {
        this.addItem(item, width, justification, style, true);
    }

    public void addItem(JStatusItem item, int width, int justification, String style, boolean isSeparator) {
        int cornerWidth = 0;
        JBasicSeparator separator = null;
        if (isSeparator) {
            separator = new JBasicSeparator(style, this.separatorHeight != -1 ? this.separatorHeight : this.getPreferredSize().height);
            separator.setBackground(this.getBackground());
        }
        if (justification == 2) {
            this.leftPanel.add(item);
            if (separator != null) {
                this.leftPanel.add(separator);
            }
            item.setIndex(this.leftIndex);
            ++this.leftIndex;
        } else if (justification == 4) {
            if (this.rightPanel.getComponentCount() == 0) {
                cornerWidth = 15;
            }
            if (separator != null) {
                this.rightPanel.add((Component)separator, 0);
                this.rightPanel.add((Component)item, 1);
            } else {
                this.leftPanel.add(item);
            }
            item.setIndex(this.rightIndex);
            ++this.rightIndex;
        }
        DimensionManager.setDimension(item, new Dimension(width + cornerWidth, this.getPreferredSize().height));
    }

    public JStatusItem getItem(int index, int justification) {
        if (justification == 2) {
            return this.getItem(index, this.leftPanel);
        }
        if (justification == 4) {
            return this.getItem(index, this.rightPanel);
        }
        return null;
    }

    private JStatusItem getItem(int index, JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JStatusItem item;
            Component component = panel.getComponent(i);
            if (!(component instanceof JStatusItem) || (item = (JStatusItem)component).getIndex() != index) continue;
            return item;
        }
        return null;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isCornerVisible) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(Color.white);
            g.drawLine(w, h - 12, w - 12, h);
            g.drawLine(w, h - 8, w - 8, h);
            g.drawLine(w, h - 4, w - 4, h);
            g.setColor(Color.gray);
            g.drawLine(w, h - 11, w - 11, h);
            g.drawLine(w, h - 10, w - 10, h);
            g.drawLine(w, h - 7, w - 7, h);
            g.drawLine(w, h - 6, w - 6, h);
            g.drawLine(w, h - 3, w - 3, h);
            g.drawLine(w, h - 2, w - 2, h);
        }
        g.setColor(UIManager.getColor("Panel.background"));
    }
}

