/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class CellRendererLabel
extends JLabel {
    private boolean isSelected;
    private boolean hasFocus;

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension.width += 2;
        }
        return dimension;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }

    @Override
    public void setBackground(Color background) {
        if (background instanceof ColorUIResource) {
            background = null;
        }
        super.setBackground(background);
    }

    @Override
    public void paint(Graphics g) {
        String text = this.getText();
        if (text != null && text.length() > 0) {
            if (this.isSelected) {
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
            } else {
                g.setColor(UIManager.getColor("Tree.textBackground"));
            }
            Dimension d = this.getPreferredSize();
            int imageOffset = 0;
            Icon icon = this.getIcon();
            if (icon != null) {
                imageOffset = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
            if (this.hasFocus) {
                g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
            }
        }
        super.paint(g);
    }
}

