/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.text.SimpleDateFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.P;
import twaver.table.editor.ActionTableCellEditor;

public class SpinnerDateEditor
extends ActionTableCellEditor {
    protected JSpinner spinner = (JSpinner)this.component;

    public SpinnerDateEditor() {
        this("null", "null", "yyyy-MM-dd HH:mm:ss");
    }

    public SpinnerDateEditor(String startDate, String endDate) {
        this(startDate, endDate, "yyyy-MM-dd HH:mm:ss");
    }

    public SpinnerDateEditor(String startDate, String endDate, String pattern) {
        this(startDate, endDate, pattern, "true");
    }

    public SpinnerDateEditor(String startDate, String endDate, String pattern, String isClearable) {
        super(new JSpinner(new SpinnerDateModel()), false, TWaverUtil.stringToBoolean(isClearable));
        SpinnerDateModel model = (SpinnerDateModel)this.spinner.getModel();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            model.setStart(format.parse(startDate));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            model.setEnd(format.parse(endDate));
        }
        catch (Exception ex) {
            // empty catch block
        }
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.spinner, pattern);
        this.spinner.setEditor(editor);
        JFormattedTextField textField = editor.getTextField();
        TWaverUtil.setHorizontalAlignment(textField, TUIManager.getString("table.alignment.date"));
        P.A(textField, this);
    }

    public void setComponentValue() {
        if (this.value != null) {
            this.spinner.setValue(this.value);
        }
        this.spinner.putClientProperty("isClear", Boolean.FALSE);
    }

    public void clearPerformed() {
        this.spinner.putClientProperty("isClear", Boolean.TRUE);
        this.stopCellEditing();
    }

    public Object getCellEditorValue() {
        if (Boolean.TRUE.equals(this.spinner.getClientProperty("isClear"))) {
            return null;
        }
        return this.spinner.getValue();
    }
}

