/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.Follower;
import twaver.Link;
import twaver.Node;
import twaver.TWaverUtil;
import twaver.UndoRedoEvent;
import twaver.UndoRedoManager;
import twaver.base.A.E.P;
import twaver.base.A.E.m;
import twaver.network.CanvasMarker;
import twaver.network.DraggingSpeed;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public abstract class AbstractMoveInputHandler
extends InputAdapter
implements CanvasMarker {
    protected TNetwork network = null;
    protected Point2D.Double mousePressedPoint = null;
    protected Point2D.Double mouseDragPoint = null;
    protected KeyEvent currentKeyEvent = null;
    protected Element parent = null;
    protected Node host = null;

    public AbstractMoveInputHandler(TNetwork network) {
        this.network = network;
    }

    public void keyReleased(KeyEvent e2) {
        this.currentKeyEvent = null;
    }

    public void keyPressed(KeyEvent e2) {
        this.currentKeyEvent = e2;
    }

    public TNetwork getNetwork() {
        return this.network;
    }

    protected abstract void dragProcess(MouseEvent var1, double var2, double var4);

    protected abstract Rectangle getSelectionBounds();

    protected abstract void releaseProcess(MouseEvent var1, double var2, double var4);

    protected abstract boolean isDraggable(int var1);

    public void mousePressed(MouseEvent e2) {
        if (!SwingUtilities.isLeftMouseButton(e2)) {
            return;
        }
        this.network.getCanvas().requestFocus();
        Element element = this.network.getSelectedElementPhysicalAt(e2.getPoint());
        if (element == null) {
            return;
        }
        this.mousePressedPoint = new Point2D.Double(e2.getX(), e2.getY());
        this.parentProcess(e2, false);
        this.hostProcess(e2, false);
    }

    public void mouseDragged(MouseEvent e2) {
        Rectangle rect;
        double yOffset;
        double xOffset;
        if (!SwingUtilities.isLeftMouseButton(e2)) {
            return;
        }
        if (this.mousePressedPoint == null || e2.isAltDown() || !this.hasDraggableSelectedElement() || m.A(this.network) || P.C(e2)) {
            return;
        }
        m.A(this.network, true, this);
        if (this.mouseDragPoint == null) {
            xOffset = (double)e2.getX() - this.mousePressedPoint.getX();
            if (!this.isDraggable((int)(xOffset * xOffset + (yOffset = (double)e2.getY() - this.mousePressedPoint.getY()) * yOffset))) {
                return;
            }
            this.mouseDragPoint = new Point2D.Double(this.mousePressedPoint.getX(), this.mousePressedPoint.getY());
        }
        xOffset = (double)e2.getX() - this.mouseDragPoint.getX();
        yOffset = (double)e2.getY() - this.mouseDragPoint.getY();
        double zoom = this.network.getZoomer().getZoom();
        xOffset /= zoom;
        yOffset /= zoom;
        double dx = 0.0;
        double dy = 0.0;
        if (this.network.isLimitElementInPositiveLocation() && (rect = this.getSelectionBounds()) != null) {
            if ((double)rect.x + xOffset < 0.0) {
                dx = xOffset + (double)rect.x;
                xOffset = -rect.x;
            }
            if ((double)rect.y + yOffset < 0.0) {
                dy = yOffset + (double)rect.y;
                yOffset = -rect.y;
            }
        }
        this.dragProcess(e2, xOffset, yOffset);
        this.mouseDragPoint.x = (double)e2.getX() - dx * zoom;
        this.mouseDragPoint.y = (double)e2.getY() - dy * zoom;
        DraggingSpeed.adjustCanvas(e2.getPoint(), this.network);
        this.parentProcess(e2, false);
        this.hostProcess(e2, false);
    }

    public void mouseReleased(MouseEvent e2) {
        if (!SwingUtilities.isLeftMouseButton(e2)) {
            return;
        }
        if (this.mousePressedPoint != null && !e2.isAltDown() && this.hasDraggableSelectedElement() && !m.A(this.network) && !P.C(e2)) {
            Element element;
            Iterator it;
            Rectangle rect;
            double yOffset;
            double xOffset;
            m.A(this.network, true, this);
            if (this.mouseDragPoint == null) {
                xOffset = (double)e2.getX() - this.mousePressedPoint.getX();
                if (!this.isDraggable((int)(xOffset * xOffset + (yOffset = (double)e2.getY() - this.mousePressedPoint.getY()) * yOffset))) {
                    m.A(this.network, false, this);
                    this.mousePressedPoint = null;
                    this.mouseDragPoint = null;
                    return;
                }
                this.mouseDragPoint = new Point2D.Double(this.mousePressedPoint.getX(), this.mousePressedPoint.getY());
            }
            xOffset = (double)e2.getX() - this.mouseDragPoint.getX();
            yOffset = (double)e2.getY() - this.mouseDragPoint.getY();
            double zoom = this.network.getZoomer().getZoom();
            xOffset /= zoom;
            yOffset /= zoom;
            if (this.network.isLimitElementInPositiveLocation() && (rect = this.getSelectionBounds()) != null) {
                if ((double)rect.x + xOffset < 0.0) {
                    xOffset = -rect.x;
                }
                if ((double)rect.y + yOffset < 0.0) {
                    yOffset = -rect.y;
                }
            }
            this.releaseProcess(e2, xOffset, yOffset);
            if (this.isParenting()) {
                if (this.parent == null) {
                    this.parent = this.network.getCurrentSubNetwork();
                }
                it = this.network.getDataBox().getSelectionModel().getToppestSelectedElement().iterator();
                while (it.hasNext()) {
                    element = (Element)it.next();
                    element.setParent(this.parent);
                }
            }
            if (this.isHosting()) {
                it = this.network.getDataBox().getSelectionModel().getToppestSelectedElement().iterator();
                while (it.hasNext()) {
                    element = (Element)it.next();
                    if (!(element instanceof Follower)) continue;
                    ((Follower)element).setHost(this.host);
                }
            }
        }
        m.A(this.network, false, this);
        this.mousePressedPoint = null;
        this.mouseDragPoint = null;
        this.parentProcess(e2, true);
        this.hostProcess(e2, true);
    }

    public Rectangle getElementBounds() {
        Iterator iterator = this.network.selection();
        Rectangle result = null;
        while (iterator.hasNext()) {
            Rectangle bounds;
            Element element = (Element)iterator.next();
            if (!this.network.isVisible(element) || element instanceof Link || (bounds = this.network.getElementBounds(element)) == null) continue;
            if (result == null) {
                result = bounds;
                continue;
            }
            result.add(bounds);
        }
        return result;
    }

    public boolean hasDraggableSelectedElement() {
        if (m.G(this.network)) {
            return false;
        }
        Iterator it = this.network.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!this.network.isMovable(element)) continue;
            return true;
        }
        return false;
    }

    protected void fireBatchMoveEvent(double xOffset, double yOffset) {
        if (xOffset == 0.0 && yOffset == 0.0) {
            return;
        }
        UndoRedoManager manager = this.network.getDataBox().getUndoRedoManager();
        if (manager.getLimit() > 0) {
            ArrayList<Element> elements = new ArrayList<Element>();
            Iterator it = this.network.selection();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!this.network.isMovable(element)) continue;
                elements.add(element);
            }
            manager.addEvent(new UndoRedoEvent(elements, xOffset, yOffset));
        }
    }

    protected boolean isParenting() {
        return this.mouseDragPoint != null && this.currentKeyEvent != null && this.currentKeyEvent.getKeyCode() == 80;
    }

    protected boolean isHosting() {
        boolean ret;
        boolean bl = ret = this.mouseDragPoint != null && this.currentKeyEvent != null && this.currentKeyEvent.getKeyCode() == 72;
        if (ret) {
            Iterator it = this.network.selection();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!(element instanceof Follower)) continue;
                return true;
            }
        }
        return false;
    }

    protected void parentProcess(MouseEvent e2, boolean released) {
        Rectangle rect = null;
        if (this.parent != null) {
            rect = this.network.getElementBounds(this.parent);
            this.parent = null;
        }
        if (!released && this.isParenting()) {
            Iterator it = this.network.getElementsPhysicalAt(e2.getPoint()).iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (element.isSelected()) continue;
                this.parent = element;
                break;
            }
        }
        if (this.parent != null) {
            if (rect == null) {
                rect = this.network.getElementBounds(this.parent);
            } else {
                rect.add(this.network.getElementBounds(this.parent));
            }
        }
        if (rect != null) {
            this.network.getRenderer().repaintLogicalBounds(rect);
        }
    }

    protected void hostProcess(MouseEvent e2, boolean released) {
        Rectangle rect = null;
        if (this.host != null) {
            rect = this.network.getElementBounds(this.host);
            this.host = null;
        }
        if (!released && this.isHosting()) {
            Iterator it = this.network.getElementsPhysicalAt(e2.getPoint()).iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!(element instanceof Node) || element.isSelected()) continue;
                this.host = (Node)element;
                break;
            }
        }
        if (this.host != null) {
            if (rect == null) {
                rect = this.network.getElementBounds(this.host);
            } else {
                rect.add(this.network.getElementBounds(this.host));
            }
        }
        if (rect != null) {
            this.network.getRenderer().repaintLogicalBounds(rect);
        }
    }

    public void mark(Graphics2D g2) {
        Rectangle rect;
        if (this.parent != null) {
            rect = this.network.getElementBounds(this.parent);
            TWaverUtil.drawDashRectangle(g2, rect, 1.0);
        }
        if (this.host != null) {
            rect = this.network.getElementBounds(this.host);
            TWaverUtil.drawDashRectangle(g2, rect, 1.0);
        }
    }
}

