/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.AlarmSeverity;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.Element;
import twaver.TDataBox;
import twaver.VisibleFilter;

public class AlarmStateStatistics {
    DataBoxListener B = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            AlarmStateStatistics.this.A(e2.getElement());
            AlarmStateStatistics.this.fireAlarmStateChange();
        }

        public void elementRemoved(DataBoxEvent e2) {
            Element element = e2.getElement();
            AlarmStateStatistics.this.B(element);
            AlarmStateStatistics.this.fireAlarmStateChange();
        }

        public void elementsCleared(DataBoxEvent e2) {
            AlarmStateStatistics.this.A();
            AlarmStateStatistics.this.fireAlarmStateChange();
        }
    };
    PropertyChangeListener D = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("alarmState".equals(propName)) {
                Element element = (Element)evt.getSource();
                AlarmStateStatistics.this.B(element);
                AlarmStateStatistics.this.A(element);
                AlarmStateStatistics.this.fireAlarmStateChange();
            }
        }
    };
    private int E = 0;
    private int H = 0;
    private int J = 0;
    private TDataBox G = null;
    private List C = new ArrayList();
    private Map A = new HashMap();
    private Map I = new HashMap();
    private VisibleFilter F = null;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public AlarmStateStatistics() {
        this(new TDataBox());
    }

    public AlarmStateStatistics(TDataBox box) {
        this(box, null);
    }

    public AlarmStateStatistics(TDataBox box, List alarmSeverities) {
        this.C = alarmSeverities == null ? AlarmSeverity.getAllSeverity() : alarmSeverities;
        Iterator it = this.C.iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.I.put(severity, new _B());
        }
        this.setDataBox(box);
    }

    public TDataBox getDataBox() {
        return this.G;
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new NullPointerException("Cannot set a null TDataBox");
        }
        TDataBox oldValue = this.G;
        if (this.G != null) {
            this.G.removeDataBoxListener(this.B);
            this.G.removeElementPropertyChangeListener(this.D);
            this.A();
        }
        this.G = box;
        this.G.addDataBoxListener(this.B);
        this.G.addElementPropertyChangeListener(this.D);
        this.firePropertyChange("databox", oldValue, this.G);
        Iterator it = this.G.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.A(element);
        }
        this.fireAlarmStateChange();
    }

    protected void fireAlarmStateChange() {
        this.E = 0;
        this.H = 0;
        this.J = 0;
        for (int i2 = 0; i2 < this.C.size(); ++i2) {
            AlarmSeverity severity = (AlarmSeverity)this.C.get(i2);
            int iNew = this.getNewAlarmCount(severity);
            int iAck = this.getAcknowledgedAlarmCount(severity);
            int iTotal = this.getTotalAlarmCount(severity);
            this.E += iNew;
            this.H += iAck;
            this.J += iTotal;
        }
        this.firePropertyChange("alarmstate", Boolean.TRUE, Boolean.FALSE);
    }

    public int getNewAlarmCount() {
        return this.E;
    }

    public int getTotalAlarmCount() {
        return this.J;
    }

    public int getAcknowledgedAlarmCount() {
        return this.H;
    }

    public int getTotalAlarmCount(AlarmSeverity severity) {
        _B summary = (_B)this.I.get(severity);
        if (summary == null) {
            return 0;
        }
        return summary.A();
    }

    public int getNewAlarmCount(AlarmSeverity severity) {
        _B summary = (_B)this.I.get(severity);
        if (summary == null) {
            return 0;
        }
        return summary.D();
    }

    public int getAcknowledgedAlarmCount(AlarmSeverity severity) {
        _B summary = (_B)this.I.get(severity);
        if (summary == null) {
            return 0;
        }
        return summary.B();
    }

    private void A(Element element) {
        if (!this.isVisible(element)) {
            return;
        }
        HashMap<AlarmSeverity, _A> map = new HashMap<AlarmSeverity, _A>();
        this.A.put(element.getID(), map);
        for (int i2 = 0; i2 < this.C.size(); ++i2) {
            AlarmSeverity severity = (AlarmSeverity)this.C.get(i2);
            _A severityInfo = new _A(element, severity);
            map.put(severity, severityInfo);
            _B summary = (_B)this.I.get(severity);
            summary.A(severityInfo);
        }
    }

    private void B(Element element) {
        Map map = (Map)this.A.remove(element.getID());
        if (map != null) {
            for (int i2 = 0; i2 < this.C.size(); ++i2) {
                AlarmSeverity severity = (AlarmSeverity)this.C.get(i2);
                _A severityInfo = (_A)map.remove(severity);
                _B summary = (_B)this.I.get(severity);
                summary.B(severityInfo);
            }
        }
    }

    private void A() {
        this.A.clear();
        for (int i2 = 0; i2 < this.C.size(); ++i2) {
            AlarmSeverity severity = (AlarmSeverity)this.C.get(i2);
            _B summary = (_B)this.I.get(severity);
            summary.C();
        }
    }

    public void reset() {
        this.A();
        Iterator it = this.G.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.A(element);
        }
        this.fireAlarmStateChange();
    }

    public VisibleFilter getVisibleFilter() {
        return this.F;
    }

    public void setVisibleFilter(VisibleFilter visibleFilter) {
        this.F = visibleFilter;
        this.reset();
    }

    public boolean isVisible(Element element) {
        if (this.F == null) {
            return true;
        }
        return this.F.isVisible(element);
    }

    public List getSeverityList() {
        return this.C;
    }

    class _B {
        private int C = 0;
        private int B = 0;
        private int A = 0;

        _B() {
        }

        public void A(_A severityInfo) {
            this.C += severityInfo.C();
            this.B += severityInfo.B();
            this.A += severityInfo.A();
        }

        public void B(_A severityInfo) {
            this.C -= severityInfo.C();
            this.B -= severityInfo.B();
            this.A -= severityInfo.A();
        }

        public void C() {
            this.C = 0;
            this.B = 0;
            this.A = 0;
        }

        public int B() {
            return this.B;
        }

        public int D() {
            return this.C;
        }

        public int A() {
            return this.A;
        }
    }

    class _A {
        private int C = 0;
        private int B = 0;
        private int A = 0;

        public _A(Element element, AlarmSeverity severity) {
            this.C = element.getAlarmState().getNewAlarmCount(severity);
            this.B = element.getAlarmState().getAcknowledgedAlarmCount(severity);
            this.A = this.C + this.B;
        }

        public int B() {
            return this.B;
        }

        public int C() {
            return this.C;
        }

        public int A() {
            return this.A;
        }
    }
}

