/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.net.http.apache;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.net.http.HttpConfig;
import com.nepxion.util.net.http.IClientRequest;
import com.nepxion.util.net.http.apache.ClientLogger;
import java.util.List;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;

public class ClientRequestGet
extends HttpGet
implements IClientRequest {
    private HttpConfig httpConfig;
    private String urlParameter = "";

    public ClientRequestGet() {
    }

    public ClientRequestGet(HttpConfig httpConfig) {
        super(httpConfig.toURI());
        this.httpConfig = httpConfig;
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Override
    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.setURI(httpConfig.toURI());
    }

    @Override
    public String getURLParameter() {
        return this.urlParameter;
    }

    public void setParameterEntity(List parameterEntity) {
        this.setParameterEntity(parameterEntity, EncoderContext.getHttpCharset());
    }

    public void setParameterEntity(List parameterEntity, String charset) {
        ClientLogger.requestInfo("Get", charset, "List - [URL Parameter]", parameterEntity);
        String format = URLEncodedUtils.format((List)parameterEntity, (String)charset);
        if (format != null) {
            this.urlParameter = "?" + format;
        }
    }
}

