/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.utils;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import twaver.GeoCoordinate;
import twaver.gis.GeographyFeature;
import twaver.gis.GeographyMap;
import twaver.gis.utils.GisToolkits;
import twaver.gis.utils.XMLUtils;

public class TWaverGisXML {
    public static final String TAG_LAYER = "layer";
    public static final String TAG_LAYERNAME = "layername";
    public static final String TAG_FEATURE = "feature";
    public static final String TAG_NONEGEOMETRY_ATTRIBUTES = "attribute";
    public static final String TAG_FEATURESHAPE = "shape";
    private static final String C = "p";
    private static final String K = "s";
    private static final String E = "m";
    private static final String G = "x";
    private static final String F = "y";
    private static final String D = "a";
    private static final String I = "n";
    private static final String J = "v";
    private static double[] H = new double[6];
    private static final DecimalFormat A = new DecimalFormat("####.00");
    private static final double B = 3.0;

    public static String wrapFeature(GeographyMap map, GeographyFeature feature) {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.wrapTagHead(TAG_FEATURE));
        sb.append(TWaverGisXML.wrapShape(GisToolkits.getGeographyFeatureShape(map, feature)));
        sb.append(XMLUtils.wrapTagTail(TAG_FEATURE));
        return sb.toString();
    }

    public static String wrapFeatureToTShape(GeographyMap map, GeographyFeature feature, String[] attributeNames) {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.wrapTagHead(TAG_FEATURE));
        sb.append(TWaverGisXML.A(feature, attributeNames));
        sb.append(TWaverGisXML.wrapShape(GisToolkits.getGeographyFeatureShape(map, feature)));
        sb.append(XMLUtils.wrapTagTail(TAG_FEATURE));
        return sb.toString();
    }

    public static String wrapFeatureToTGeoShape(GeographyMap map, GeographyFeature feature, String[] attributeNames) {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.wrapTagHead(TAG_FEATURE));
        sb.append(TWaverGisXML.A(feature, attributeNames));
        sb.append(TWaverGisXML.wrapFeatureGeoShape(map, feature));
        sb.append(XMLUtils.wrapTagTail(TAG_FEATURE));
        return sb.toString();
    }

    public static String wrapFeatureGeoShape(GeographyMap map, GeographyFeature feature) {
        StringBuffer sb = new StringBuffer();
        Vector shape = feature.getPoints();
        Object s = shape.get(0);
        Point2D.Double cache = new Point2D.Double();
        sb.append("<shape>\n");
        if (s instanceof GeoCoordinate) {
            switch (shape.size()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        } else if (s instanceof List && shape.size() == 2) {
            sb.append("<lines>\n");
            List ps = (List)shape.get(0);
            List segments = (List)shape.get(1);
            int count = segments.size();
            int i = 0;
            while (i < count) {
                GeoCoordinate geo;
                Point2D sp;
                if ((Integer)segments.get(i) == 0) {
                    if (i > 0) {
                        int bi = sb.lastIndexOf(" ");
                        sb.replace(bi, bi + 1, "");
                        sb.append("</l>\n");
                    }
                    sb.append("<l>\n");
                }
                if (GisToolkits.A(sp = GisToolkits.convertLatLongToScreen(map, geo = (GeoCoordinate)ps.get(i)), cache, GisToolkits.A(map))) {
                    sb.append(String.valueOf(geo.getLatitude()) + "," + geo.getLongitude() + " ");
                }
                ++i;
            }
            int bi = sb.lastIndexOf(" ");
            sb.replace(bi, bi + 1, "");
            sb.append("\n</l>\n");
            sb.append("</lines>\n");
        }
        sb.append("</shape>\n");
        return sb.toString();
    }

    private static String A(GeographyFeature feature, String[] attributeNames) {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.wrapTagHead(TAG_NONEGEOMETRY_ATTRIBUTES));
        int i = 0;
        while (i < attributeNames.length) {
            StringBuffer attributes = new StringBuffer();
            attributes.append(XMLUtils.wrapValue(I, attributeNames[i]));
            attributes.append(XMLUtils.wrapValue(J, feature.getAttribute(attributeNames[i])));
            sb.append(XMLUtils.wrapTagWithAttributes(D, attributes.toString()));
            ++i;
        }
        sb.append(XMLUtils.wrapTagTail(TAG_NONEGEOMETRY_ATTRIBUTES));
        return sb.toString();
    }

    public static String wrapShape(Shape s) {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.wrapTagHead(TAG_FEATURESHAPE));
        PathIterator pi = s.getPathIterator(null);
        Vector<GeoCoordinate> collection = new Vector<GeoCoordinate>();
        StringBuffer shapeBuilder = sb;
        while (!pi.isDone()) {
            GeoCoordinate coordinate = new GeoCoordinate();
            if (TWaverGisXML.A(coordinate, pi)) {
                StringBuffer builder;
                if (collection.size() > 0) {
                    TWaverGisXML.A(collection, shapeBuilder, true);
                    builder = new StringBuffer();
                    builder.append(XMLUtils.wrapValue(K, E));
                    builder.append(XMLUtils.wrapValue(G, TWaverGisXML.getFormatNumber(coordinate.x)));
                    builder.append(XMLUtils.wrapValue(F, TWaverGisXML.getFormatNumber(coordinate.y)));
                    shapeBuilder.append(XMLUtils.wrapTagWithAttributes(C, builder.toString()));
                    collection.clear();
                } else {
                    builder = new StringBuffer();
                    builder.append(XMLUtils.wrapValue(K, E));
                    builder.append(XMLUtils.wrapValue(G, TWaverGisXML.getFormatNumber(coordinate.x)));
                    builder.append(XMLUtils.wrapValue(F, TWaverGisXML.getFormatNumber(coordinate.y)));
                    shapeBuilder.append(XMLUtils.wrapTagWithAttributes(C, builder.toString()));
                }
            }
            collection.add(coordinate);
            pi.next();
        }
        if (collection.size() > 0) {
            TWaverGisXML.A(collection, shapeBuilder, true);
            collection.clear();
        }
        sb.append(XMLUtils.wrapTagTail(TAG_FEATURESHAPE));
        return sb.toString();
    }

    private static boolean A(GeoCoordinate coordinate, PathIterator pathiterator) {
        boolean result = false;
        int type = pathiterator.currentSegment(H);
        switch (type) {
            case 0: {
                coordinate.x = H[0];
                coordinate.y = H[1];
                result = true;
                break;
            }
            case 1: {
                coordinate.x = H[0];
                coordinate.y = H[1];
                break;
            }
        }
        return result;
    }

    public static String getFormatNumber(double value) {
        String result = A.format(Math.abs(value));
        return result;
    }

    private static void A(Vector collection, StringBuffer sb, boolean all) {
        int length = 0;
        length = all ? collection.size() : collection.size() - 1;
        GeoCoordinate[] ss = new GeoCoordinate[length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = (GeoCoordinate)collection.get(i);
            ++i;
        }
        StringBuffer builder = new StringBuffer();
        int i2 = 1;
        while (i2 < ss.length) {
            builder = new StringBuffer();
            builder.append(XMLUtils.wrapValue(G, TWaverGisXML.getFormatNumber(ss[i2].x)));
            builder.append(XMLUtils.wrapValue(F, TWaverGisXML.getFormatNumber(ss[i2].y)));
            sb.append(XMLUtils.wrapTagWithAttributes(C, builder.toString()));
            ++i2;
        }
    }
}

