/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.util.HashMap;
import java.util.Map;
import y.io.gml.GMLTokenizer;

public class ItemParser
implements GMLTokenizer.Callback {
    protected int level;
    protected Map childMap;
    protected Map attributes = new HashMap();
    protected ItemParser delegate;

    public ItemParser() {
        this.childMap = new HashMap();
    }

    public void addChild(String string, ItemParser itemParser) {
        this.childMap.put(string, itemParser);
    }

    public void beginScope(String string) {
        if (this.level == 0) {
            ItemParser itemParser = (ItemParser)this.childMap.get(string);
            if (itemParser != null) {
                this.delegate = itemParser;
                this.delegate.begin();
            }
        } else if (this.delegate != null) {
            this.delegate.beginScope(string);
        }
        ++this.level;
    }

    public void endScope(String string) {
        --this.level;
        if (this.level == 0 && this.delegate != null) {
            this.delegate.end();
            this.childFinished(this.delegate);
            this.delegate = null;
        }
        if (this.delegate != null) {
            this.delegate.endScope(string);
        }
    }

    public void attribute(String string, String string2) {
        if (this.level == 0) {
            this.addAttribute(string, string2);
        }
        if (this.delegate != null) {
            this.delegate.attribute(string, string2);
        }
    }

    public void attribute(String string, Number number) {
        if (this.level == 0) {
            this.addAttribute(string, number);
        }
        if (this.delegate != null) {
            this.delegate.attribute(string, number);
        }
    }

    public void addAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public boolean getBoolean(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            if (v instanceof Number) {
                return ((Number)v).intValue() != 0;
            }
            return "true".equals(v.toString());
        }
        return false;
    }

    public String getString(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return v.toString();
        }
        return "";
    }

    public double getDouble(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return ((Number)v).doubleValue();
        }
        return 0.0;
    }

    public double getDouble(String string, double d2) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return ((Number)v).doubleValue();
        }
        return d2;
    }

    public int getInt(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return ((Number)v).intValue();
        }
        return 0;
    }

    public int getInt(String string, int n) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return ((Number)v).intValue();
        }
        return n;
    }

    public void begin() {
        this.attributes.clear();
    }

    public void end() {
    }

    public Object getItem() {
        return this.attributes;
    }

    public void childFinished(ItemParser itemParser) {
    }

    public int getLevel() {
        return this.level;
    }

    public Map getAttributes() {
        return this.attributes;
    }
}

