/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import java.awt.Color;
import twaver.AlarmSeverity;
import twaver.Element;
import twaver.Generator;
import twaver.network.ui.ElementUI;

public class TAlarmFacadeAdapter {
    public TAlarmFacadeAdapter(TGraph graph) {
        graph.setElementBodyColorGenerator(new Generator(){

            public Object generate(Object object) {
                if (!(object instanceof Element)) {
                    return null;
                }
                Element element = (Element)object;
                AlarmSeverity propagateSeverity = element.getAlarmState().getPropagateSeverity();
                if (propagateSeverity != null) {
                    return propagateSeverity.getColor();
                }
                AlarmSeverity severity = element.getAlarmState().getHighestNativeAlarmSeverity();
                if (severity != null) {
                    return severity.getColor();
                }
                Color elementBodyColor = (Color)element.getClientProperty((Object)"render.color");
                if (elementBodyColor != null) {
                    return elementBodyColor;
                }
                return null;
            }
        });
        graph.setElementStateOutlineColorGenerator(new Generator(){

            public Object generate(Object object) {
                if (!(object instanceof Element)) {
                    return null;
                }
                Element element = (Element)object;
                Color elementOutlineColor = (Color)element.getClientProperty((Object)"state.outline.color");
                if (elementOutlineColor != null) {
                    return elementOutlineColor;
                }
                return null;
            }
        });
        graph.setAlarmColorGenerator(new Generator(){

            public Object generate(Object object) {
                Element element = null;
                if (object instanceof ElementUI) {
                    ElementUI elementUI = (ElementUI)object;
                    element = elementUI.getElement();
                } else {
                    element = (Element)object;
                }
                AlarmSeverity propagateSeverity = element.getAlarmState().getPropagateSeverity();
                if (propagateSeverity != null) {
                    return propagateSeverity.getColor();
                }
                AlarmSeverity severity = element.getAlarmState().getHighestNativeAlarmSeverity();
                if (severity != null) {
                    return severity.getColor();
                }
                Color elementBodyColor = (Color)element.getClientProperty((Object)"render.color");
                if (elementBodyColor != null) {
                    return elementBodyColor;
                }
                return null;
            }
        });
        graph.setAlarmLabelGenerator(new Generator(){

            public Object generate(Object object) {
                Element element = null;
                if (object instanceof ElementUI) {
                    ElementUI elementUI = (ElementUI)object;
                    element = elementUI.getElement();
                } else {
                    element = (Element)object;
                }
                AlarmSeverity propagateSeverity = element.getAlarmState().getPropagateSeverity();
                if (propagateSeverity != null) {
                    int severityCount = element.getAlarmState().getNewAlarmCount(propagateSeverity);
                    String bubbleString = severityCount + propagateSeverity.getNickName();
                    if (element.getAlarmState().hasLessSevereNewAlarms()) {
                        bubbleString = bubbleString + "+";
                    }
                    return bubbleString;
                }
                AlarmSeverity severity = element.getAlarmState().getHighestNativeAlarmSeverity();
                if (severity != null) {
                    int highestSeverityCount = element.getAlarmState().getNewAlarmCount(severity);
                    String bubbleString = highestSeverityCount + severity.getNickName();
                    if (element.getAlarmState().hasLessSevereNewAlarms()) {
                        bubbleString = bubbleString + "+";
                    }
                    return bubbleString;
                }
                return null;
            }
        });
    }
}

