/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.renderer.list.CellRendererLabel;
import com.nepxion.swing.renderer.list.RadioButtonCellRendererPanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RadioButtonListCellRenderer
extends RadioButtonCellRendererPanel
implements ListCellRenderer {
    private JList list;
    private int cellHeight = -1;
    private JRadioButton radioButton;
    private CellRendererLabel cellLabel;

    public RadioButtonListCellRenderer(JList list) {
        this(list, -1);
    }

    public RadioButtonListCellRenderer(JList list, int cellHeight) {
        this.list = list;
        this.radioButton = this.getRadioButton();
        this.cellLabel = this.getLabel();
        list.addListSelectionListener(new RadioButtonListSelectionListener());
        list.addMouseListener(new RadioButtonListMouseListener());
        this.setCellHeight(cellHeight);
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        if (this.list != null && cellHeight > 0) {
            this.list.setFixedCellHeight(cellHeight);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        IElementNode elementNode = (IElementNode)value;
        this.radioButton.setSelected(elementNode.isSelected());
        this.cellLabel.setText(elementNode.getText());
        this.cellLabel.setIcon(elementNode.getIcon());
        this.cellLabel.setToolTipText(elementNode.getToolTipText());
        this.cellLabel.setSelected(isSelected);
        this.cellLabel.setFont(list.getFont());
        this.cellLabel.setFocus(hasFocus);
        this.cellLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.cellLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setToolTipText(elementNode.getToolTipText());
        return this;
    }

    private void adaptSelection() {
        int index = this.list.getSelectedIndex();
        if (index > -1) {
            for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                IElementNode elementNode = (IElementNode)this.list.getModel().getElementAt(i);
                if (index == i) {
                    if (!elementNode.isSelected()) {
                        elementNode.setSelected(true);
                    }
                } else {
                    elementNode.setSelected(false);
                }
                Rectangle rectangle = this.list.getCellBounds(i, i);
                this.list.repaint(rectangle);
            }
        }
    }

    public class RadioButtonListMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            RadioButtonListCellRenderer.this.adaptSelection();
        }
    }

    public class RadioButtonListSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            RadioButtonListCellRenderer.this.adaptSelection();
        }
    }
}

