/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.gradient;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class JTexturePainter {
    private static Map texturePaintMap;

    public static TexturePaint getCacheTexturePaint(Image image) {
        TexturePaint texturePaint;
        if (texturePaintMap == null) {
            texturePaintMap = new HashMap();
        }
        if ((texturePaint = (TexturePaint)texturePaintMap.get(image)) == null) {
            texturePaint = JTexturePainter.getTexturePaint(image);
        }
        texturePaintMap.put(image, texturePaint);
        return texturePaint;
    }

    public static TexturePaint getTexturePaint(Image image) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, imageWidth, imageHeight));
    }
}

