/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import y.base.Edge;
import y.base.Node;
import y.view.Bend;
import y.view.EdgeLabel;
import y.view.Graph2D;
import y.view.HitInfo;
import y.view.ViewContainer;
import y.view.ViewMode;

public abstract class PopupMode
extends ViewMode {
    private PopupMenuListener bw;
    private boolean bv = true;
    private boolean by = false;
    private boolean bx = true;

    public PopupMode() {
    }

    public PopupMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.c(this.translateX(mouseEvent.getX()), this.translateY(mouseEvent.getY()));
        }
        if (this.by) {
            this.bv = true;
        }
    }

    public void reactivateParent() {
        if (!this.bv) {
            super.reactivateParent();
        }
        this.bv = false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reactivateParent();
    }

    void c(double d2, double d3) {
        this.by = true;
        Graph2D graph2D = this.getGraph2D();
        PopupMenuListener popupMenuListener = new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                PopupMode.this.by = false;
                PopupMode.this.reactivateParent();
            }
        };
        HitInfo hitInfo = this.getHitInfo(d2, d3);
        Node node = hitInfo.getHitNode();
        if (node != null && graph2D.selectedNodes().size() <= 1) {
            JPopupMenu jPopupMenu = this.getNodePopup(node);
            if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
                this.by = false;
                this.reactivateParent();
            } else {
                jPopupMenu.addPopupMenuListener(popupMenuListener);
                if (this.bx) {
                    graph2D.unselectAll();
                    graph2D.setSelected(node, true);
                    graph2D.updateViews();
                }
                this.view.showPopup(jPopupMenu, d2, d3);
            }
            return;
        }
        Bend bend = hitInfo.getHitBend();
        if (bend != null) {
            JPopupMenu jPopupMenu = this.getBendPopup(bend);
            if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
                this.by = false;
                this.reactivateParent();
            } else {
                jPopupMenu.addPopupMenuListener(popupMenuListener);
                if (this.bx) {
                    graph2D.unselectAll();
                    bend.setSelected(true);
                    graph2D.updateViews();
                }
                this.view.showPopup(jPopupMenu, d2, d3);
            }
            return;
        }
        Edge edge = hitInfo.getHitEdge();
        if (edge != null && graph2D.selectedEdges().size() <= 1) {
            JPopupMenu jPopupMenu = this.getEdgePopup(edge);
            if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
                this.by = false;
                this.reactivateParent();
            } else {
                jPopupMenu.addPopupMenuListener(popupMenuListener);
                if (this.bx) {
                    graph2D.unselectAll();
                    graph2D.setSelected(edge, true);
                    graph2D.updateViews();
                }
                this.view.showPopup(jPopupMenu, d2, d3);
            }
            return;
        }
        EdgeLabel edgeLabel = hitInfo.getHitEdgeLabel();
        if (edgeLabel != null) {
            JPopupMenu jPopupMenu = this.getEdgeLabelPopup(edgeLabel);
            if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
                this.by = false;
                this.reactivateParent();
            } else {
                jPopupMenu.addPopupMenuListener(popupMenuListener);
                if (this.bx) {
                    graph2D.unselectAll();
                    edgeLabel.getOwner().setSelected(true);
                    graph2D.updateViews();
                }
                this.view.showPopup(jPopupMenu, d2, d3);
            }
            return;
        }
        JPopupMenu jPopupMenu = graph2D.isSelectionEmpty() ? this.getPaperPopup(d2, d3) : this.getSelectionPopup(d2, d3);
        if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
            this.by = false;
            this.reactivateParent();
        } else {
            jPopupMenu.addPopupMenuListener(popupMenuListener);
            this.view.showPopup(jPopupMenu, d2, d3);
        }
    }

    public JPopupMenu getNodePopup(Node node) {
        return new JPopupMenu();
    }

    public JPopupMenu getBendPopup(Bend bend) {
        return new JPopupMenu();
    }

    public JPopupMenu getEdgePopup(Edge edge) {
        return new JPopupMenu();
    }

    public JPopupMenu getPaperPopup(double d2, double d3) {
        return new JPopupMenu();
    }

    public JPopupMenu getSelectionPopup(double d2, double d3) {
        return new JPopupMenu();
    }

    public JPopupMenu getEdgeLabelPopup(EdgeLabel edgeLabel) {
        return new JPopupMenu();
    }

    public void setSelectSubject(boolean bl) {
        this.bx = bl;
    }

    public boolean getSelectSubject() {
        return this.bx;
    }
}

