/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import twaver.Branch;
import twaver.Node;
import twaver.PolyLine;

public class Segment
implements Serializable {
    private boolean D = true;
    private Color G = null;
    private Point A = null;
    private Point F = null;
    private Node H = null;
    private Node E = null;
    private PolyLine B = null;
    private Branch I = null;
    private Map C;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Segment() {
    }

    public Segment(Node fromNode, Node toNode, Point fromPoint, Point toPoint) {
        this.setFromNode(fromNode);
        this.setToNode(toNode);
        this.setFromPoint(fromPoint);
        this.setToPoint(toPoint);
    }

    public Segment(Node fromNode, Node toNode) {
        this.setFromNode(fromNode);
        this.setToNode(toNode);
    }

    public Segment(Point fromPoint, Point toPoint) {
        this.setFromPoint(fromPoint);
        this.setToPoint(toPoint);
    }

    public Segment(Node fromNode, Point toPoint) {
        this.setFromNode(fromNode);
        this.setToPoint(toPoint);
    }

    public Segment(Point fromPoint, Node toNode) {
        this.setFromPoint(fromPoint);
        this.setToNode(toNode);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Object getClientProperty(Object key) {
        if (this.C == null) {
            return null;
        }
        return this.getClientProperties().get(key);
    }

    public Map getClientProperties() {
        if (this.C == null) {
            this.C = new LinkedHashMap();
        }
        return this.C;
    }

    public void putClientProperty(Object key, Object value) {
        Object oldValue = this.getClientProperties().get(key);
        if (value != null) {
            this.getClientProperties().put(key, value);
        } else if (oldValue != null) {
            this.getClientProperties().remove(key);
        }
        String propertyName = "CP:" + key.toString();
        this.firePropertyChange(propertyName, oldValue, value);
    }

    public boolean isVisible() {
        return this.D;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.D;
        this.D = visible;
        this.firePropertyChange("visible", oldValue, this.D);
    }

    public Color getLineColor() {
        return this.G;
    }

    public void setLineColor(Color lineColor) {
        Color oldValue = this.G;
        this.G = lineColor;
        this.firePropertyChange("lineColor", oldValue, this.G);
    }

    public Node getFromNode() {
        return this.H;
    }

    public void setFromNode(Node fromNode) {
        Node oldValue = this.H;
        this.H = fromNode;
        this.firePropertyChange("fromNode", oldValue, this.H);
    }

    public Point getFromPoint() {
        return this.A;
    }

    public void setFromPoint(Point fromPoint) {
        Point oldValue = this.A;
        this.A = fromPoint;
        this.firePropertyChange("fromPoint", oldValue, this.A);
    }

    public Node getToNode() {
        return this.E;
    }

    public void setToNode(Node toNode) {
        Node oldValue = this.E;
        this.E = toNode;
        this.firePropertyChange("toNode", oldValue, this.E);
    }

    public Point getToPoint() {
        return this.F;
    }

    public void setToPoint(Point toPoint) {
        Point oldValue = this.F;
        this.F = toPoint;
        this.firePropertyChange("toPoint", oldValue, this.F);
    }

    public PolyLine getPolyLine() {
        return this.B;
    }

    public void setPolyLine(PolyLine polyLine) {
        this.B = polyLine;
    }

    public Branch getBranch() {
        return this.I;
    }

    public void setBranch(Branch branch) {
        this.I = branch;
    }

    public Point getFromLocation() {
        Point fromLocation = null;
        if (this.H != null) {
            fromLocation = this.H.getCenterLocation();
        }
        if (fromLocation == null) {
            fromLocation = this.getFromPoint();
        }
        return fromLocation;
    }

    public Point getToLocation() {
        Point toLocation = null;
        if (this.E != null) {
            toLocation = this.E.getCenterLocation();
        }
        if (toLocation == null) {
            toLocation = this.getToPoint();
        }
        return toLocation;
    }
}

