/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import twaver.PolyLine;
import twaver.Segment;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.LinkSVGUI;

public class PolyLineSVGUI
extends LinkSVGUI {
    private PolyLine M;

    public PolyLineSVGUI(TSVGNetwork network, PolyLine polyLine) {
        super(network, polyLine);
        this.M = polyLine;
    }

    protected SVGStruct toLabelAttachmentSVG(SVGContext context) {
        return SVGStruct.EMPTY;
    }

    protected SVGStruct toAlarmAttachmentSVG(SVGContext context) {
        return SVGStruct.EMPTY;
    }

    protected SVGStruct toIconAttachmentSVG(SVGContext context) {
        return SVGStruct.EMPTY;
    }

    protected SVGStruct toBodySVG(SVGContext context) {
        GeneralPath path = new GeneralPath();
        HashMap<Line2D.Double, Color> colorSegmentMap = new HashMap<Line2D.Double, Color>();
        List segments = this.M.getOrderSegments();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            Point to;
            Point from;
            Segment segment = (Segment)segments.get(i2);
            if (!segment.isVisible() || (from = segment.getFromLocation()) == null || (to = segment.getToLocation()) == null) continue;
            path.moveTo(from.x, from.y);
            path.lineTo(to.x, to.y);
            if (segment.getLineColor() == null) continue;
            Line2D.Double line = new Line2D.Double(from.getX(), from.getY(), to.getX(), to.getY());
            colorSegmentMap.put(line, segment.getLineColor());
        }
        context.registerLinkPath(this.M, path);
        String id = I.A(context, (Shape)path);
        StringBuffer sb = new StringBuffer();
        Color bodyColor = this.getPaintBodyColor(this.M.getLinkColor());
        this.toLinkPathSVG(context, sb, id, bodyColor);
        this.toLinkFlowingSVG(context, sb, id);
        if (!colorSegmentMap.isEmpty()) {
            Iterator it = colorSegmentMap.keySet().iterator();
            while (it.hasNext()) {
                Shape shape = (Shape)it.next();
                Color color = (Color)colorSegmentMap.get(shape);
                id = I.A(context, shape);
                this.toLinkPathSVG(context, sb, id, this.getPaintBodyColor(color));
                this.toLinkFlowingSVG(context, sb, id);
            }
        }
        return new SVGStruct(sb.toString(), null);
    }
}

