/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import twaver.Generator;
import twaver.TWaverUtil;
import twaver.base.A.E.b;
import twaver.network.ui.ComponentAttachment;
import twaver.network.ui.ElementUI;

public class MessageAttachment
extends ComponentAttachment {
    private static final JLabel \u00d6 = new JLabel(){
        {
            this.setHorizontalAlignment(0);
            this.setDoubleBuffered(false);
        }
    };
    private static JTextPane \u00d5 = new JTextPane(){
        {
            this.setDoubleBuffered(false);
            this.setOpaque(false);
        }
    };
    private static final SimpleAttributeSet \u00d4 = new SimpleAttributeSet();
    private boolean \u00d8;

    public MessageAttachment(String name, ElementUI ui) {
        super(name, ui, b.K(ui.getElement(), "message.minimized"), b.K(ui.getElement(), "message.shrinked"));
        this.\u00d8 = b.K(this.element, "message.shown.on.top");
        this.E();
    }

    public boolean isShownOnTop() {
        return this.\u00d8;
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        super.elementPropertyChange(evt);
        String name = evt.getPropertyName();
        if (name.equals("CP:message.shrinked")) {
            this.setShrinked(b.K(this.element, "message.shrinked"));
        } else if (name.equals("CP:message.minimized")) {
            this.setMinimized(b.K(this.element, "message.minimized"));
        } else if (name.equals("CP:message.shown.on.top")) {
            this.\u00d8 = b.K(this.element, "message.shown.on.top");
        }
    }

    private void E() {
        int gap;
        int xGap = b.J(this.element, "message.xgap") * 2;
        int yGap = b.J(this.element, "message.ygap") * 2;
        int type = b.J(this.element, "message.component");
        if (type == 2) {
            gap = 0;
            if (this.getComponent() != \u00d5) {
                this.setComponent(\u00d5);
            }
            try {
                \u00d5.setFont(b.D(this.element, "message.font"));
                StyleConstants.setForeground(\u00d4, b.P(this.element, "message.foreground"));
                Document doc = \u00d5.getDocument();
                doc.remove(0, doc.getLength());
                String context = this.getMessageContent();
                if (context != null) {
                    doc.insertString(0, context, \u00d4);
                }
            }
            catch (BadLocationException e2) {
                TWaverUtil.handleError(null, e2);
            }
        } else {
            gap = 4;
            if (this.getComponent() != \u00d6) {
                this.setComponent(\u00d6);
            }
            \u00d6.setText(this.getMessageContent());
            \u00d6.setFont(b.D(this.element, "message.font"));
            \u00d6.setForeground(b.P(this.element, "message.foreground"));
        }
        this.setBorderColor(b.P(this.element, "message.border.color"));
        this.setBorderVisible(b.K(this.element, "message.border.visible"));
        this.setBorderStroke(b.F(this.element, "message.border.stroke"));
        this.setClosable(b.K(this.element, "message.closable"));
        this.setShrinkable(b.K(this.element, "message.shrinkable"));
        this.setMinimizable(b.K(this.element, "message.minimizable"));
        this.setAutoAdjustDirection(b.K(this.element, "message.auto.adjust.direction"));
        this.setBodyColor(b.P(this.element, "message.background"));
        this.setBodyGradient(b.K(this.element, "message.gradient"));
        this.setBodyGradientColor(b.P(this.element, "message.gradient.color"));
        this.setBodyGradientType(b.J(this.element, "message.gradient.factory"));
        this.setBodyVisible(b.K(this.element, "message.opaque"));
        this.setShadowVisible(b.K(this.element, "message.shadow.visible"));
        this.setShadowColor(b.P(this.element, "message.shadow.color"));
        this.setStyle(b.J(this.element, "message.style"));
        this.setArc(b.J(this.element, "message.arc"));
        this.setTail(b.J(this.element, "message.tail"));
        this.setPosition(b.J(this.element, "message.position"));
        this.setDirection(b.J(this.element, "message.direction"));
        this.setXOffset(b.J(this.element, "message.xoffset"));
        this.setYOffset(b.J(this.element, "message.yoffset"));
        this.setMinimizedIcon(TWaverUtil.getIcon(b.Q(this.element, "message.minimized.icon")));
        JComponent component = this.getComponent();
        int w = b.J(this.element, "message.width");
        int h2 = b.J(this.element, "message.height");
        if (w <= 0 && h2 > 0) {
            component.setSize(10000, 18);
            Dimension size = component.getPreferredSize();
            w = size.height * size.width / h2;
            if (w <= 0) {
                w = 2;
            }
            component.setSize(w, 10000);
            this.setWidth(w + xGap);
            this.setHeight(component.getPreferredSize().height + gap + yGap);
        } else if (w > 0 && h2 <= 0) {
            component.setSize(10000, 18);
            Dimension size = component.getPreferredSize();
            if (w > size.width) {
                w = size.width;
            }
            component.setSize(w, 10000);
            this.setWidth(w + xGap);
            this.setHeight(component.getPreferredSize().height + gap + yGap);
        } else if (w > 0 && h2 > 0) {
            this.setWidth(w + xGap);
            this.setHeight(h2 + yGap);
        } else {
            component.setSize(0, 0);
            Dimension size = component.getPreferredSize();
            this.setWidth(size.width + gap + xGap);
            this.setHeight(size.height + gap + yGap);
        }
    }

    protected void update() {
        this.E();
        this.invalidate();
        super.update();
    }

    public void paint(Graphics2D g2d) {
        String text = this.getMessageContent();
        if (text != null) {
            super.paint(g2d);
        }
    }

    public Rectangle getBounds() {
        String text = this.getMessageContent();
        if (text == null) {
            return null;
        }
        return super.getBounds();
    }

    protected String getMessageContent() {
        Generator generator = this.network.getMessageContentGenerator();
        if (generator == null) {
            return b.Q(this.element, "message.content");
        }
        return (String)generator.generate(this.element);
    }
}

