/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.color;

import com.nepxion.swing.border.LineBorder;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.icon.paint.ColorIcon;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.swing.style.button.lite.JYellowLiteButtonStyle;
import com.nepxion.swing.style.button.lite.LiteButtonUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public abstract class JColorSelector
extends JPanel
implements SwingConstants {
    public static final int BORDER_STYLE_ALL = 0;
    public static final int BORDER_STYLE_TOP = 1;
    public static final int BORDER_STYLE_CENTER = 2;
    public static final int BORDER_STYLE_BOTTOM = 3;
    protected Border selectedBorder = BorderFactory.createCompoundBorder(new LineBorder(new Color(239, 72, 16)), new LineBorder(new Color(255, 226, 148)));
    protected Border hoverBorder = BorderFactory.createCompoundBorder(new LineBorder(new Color(242, 148, 54)), new LineBorder(new Color(255, 226, 148)));
    protected List colorList;
    protected Map colorItemMap;
    protected ColorItem selectedColorItem;
    protected Color selectedColor;

    public JColorSelector() {
        this.initColors();
        this.initComponents();
    }

    private void initColors() {
        this.colorList = new ArrayList();
        this.colorList.add(new Color(255, 255, 255));
        this.colorList.add(new Color(0, 0, 0));
        this.colorList.add(new Color(238, 236, 225));
        this.colorList.add(new Color(31, 73, 125));
        this.colorList.add(new Color(79, 129, 189));
        this.colorList.add(new Color(192, 80, 77));
        this.colorList.add(new Color(155, 187, 90));
        this.colorList.add(new Color(128, 100, 162));
        this.colorList.add(new Color(75, 172, 198));
        this.colorList.add(new Color(247, 150, 70));
        this.colorList.add(new Color(242, 242, 242));
        this.colorList.add(new Color(127, 127, 127));
        this.colorList.add(new Color(221, 217, 195));
        this.colorList.add(new Color(198, 217, 241));
        this.colorList.add(new Color(219, 229, 241));
        this.colorList.add(new Color(242, 219, 219));
        this.colorList.add(new Color(234, 241, 221));
        this.colorList.add(new Color(229, 223, 236));
        this.colorList.add(new Color(218, 238, 243));
        this.colorList.add(new Color(253, 233, 217));
        this.colorList.add(new Color(217, 217, 217));
        this.colorList.add(new Color(89, 89, 89));
        this.colorList.add(new Color(196, 188, 150));
        this.colorList.add(new Color(141, 179, 226));
        this.colorList.add(new Color(184, 204, 228));
        this.colorList.add(new Color(229, 184, 183));
        this.colorList.add(new Color(214, 227, 188));
        this.colorList.add(new Color(204, 192, 217));
        this.colorList.add(new Color(182, 221, 232));
        this.colorList.add(new Color(251, 212, 180));
        this.colorList.add(new Color(191, 191, 191));
        this.colorList.add(new Color(64, 64, 64));
        this.colorList.add(new Color(148, 138, 84));
        this.colorList.add(new Color(84, 141, 212));
        this.colorList.add(new Color(149, 179, 215));
        this.colorList.add(new Color(217, 149, 148));
        this.colorList.add(new Color(194, 214, 155));
        this.colorList.add(new Color(178, 161, 199));
        this.colorList.add(new Color(146, 205, 220));
        this.colorList.add(new Color(250, 191, 143));
        this.colorList.add(new Color(166, 166, 166));
        this.colorList.add(new Color(38, 38, 38));
        this.colorList.add(new Color(74, 68, 42));
        this.colorList.add(new Color(23, 54, 93));
        this.colorList.add(new Color(54, 95, 145));
        this.colorList.add(new Color(148, 54, 52));
        this.colorList.add(new Color(118, 146, 60));
        this.colorList.add(new Color(95, 73, 122));
        this.colorList.add(new Color(49, 132, 155));
        this.colorList.add(new Color(227, 108, 10));
        this.colorList.add(new Color(128, 128, 128));
        this.colorList.add(new Color(13, 13, 13));
        this.colorList.add(new Color(29, 27, 17));
        this.colorList.add(new Color(15, 36, 62));
        this.colorList.add(new Color(36, 64, 97));
        this.colorList.add(new Color(99, 36, 35));
        this.colorList.add(new Color(79, 98, 40));
        this.colorList.add(new Color(64, 49, 82));
        this.colorList.add(new Color(33, 88, 104));
        this.colorList.add(new Color(152, 72, 6));
        this.colorList.add(new Color(192, 0, 0));
        this.colorList.add(new Color(255, 0, 0));
        this.colorList.add(new Color(255, 192, 0));
        this.colorList.add(new Color(255, 255, 0));
        this.colorList.add(new Color(146, 208, 80));
        this.colorList.add(new Color(0, 176, 80));
        this.colorList.add(new Color(0, 176, 240));
        this.colorList.add(new Color(0, 112, 192));
        this.colorList.add(new Color(0, 32, 96));
        this.colorList.add(new Color(112, 48, 160));
        this.colorItemMap = new LinkedHashMap();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.setBackground(Color.white);
        this.setLayout(new FiledLayout(0, 2, 2));
        JPanel themePanel = this.createThemePanel();
        this.add(themePanel);
        JPanel standardPanel = this.createStandardPanel();
        this.add(standardPanel);
        JPanel buttonPanel = this.createButtonPanel();
        this.add(buttonPanel);
    }

    private JPanel createThemePanel() {
        JPanel labelPanel = this.createLabelPanel(SwingLocale.getString("theme_color"));
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        topPanel.setLayout(new GridLayout(1, 10, 4, 0));
        for (int i = 0; i < 10; ++i) {
            Color color = (Color)this.colorList.get(i);
            int borderStyle = 0;
            ColorItem colorItem = new ColorItem(color, borderStyle);
            topPanel.add(colorItem);
            this.colorItemMap.put(color, colorItem);
        }
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(Color.white);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        centerPanel.setLayout(new GridLayout(5, 10, 4, 0));
        for (int i = 10; i < 60; ++i) {
            Color color = (Color)this.colorList.get(i);
            int borderStyle = 0;
            borderStyle = i / 10 == 1 ? 1 : (i / 10 == 5 ? 3 : 2);
            ColorItem colorItem = new ColorItem(color, borderStyle);
            centerPanel.add(colorItem);
            this.colorItemMap.put(color, colorItem);
        }
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new FiledLayout(0, 2, 0));
        panel.add(labelPanel);
        panel.add(topPanel);
        panel.add(centerPanel);
        return panel;
    }

    private JPanel createStandardPanel() {
        JPanel labelPanel = this.createLabelPanel(SwingLocale.getString("standard_color"));
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        topPanel.setLayout(new GridLayout(1, 10, 4, 0));
        for (int i = 60; i < 70; ++i) {
            Color color = (Color)this.colorList.get(i);
            int borderStyle = 0;
            ColorItem colorItem = new ColorItem(color, borderStyle);
            topPanel.add(colorItem);
            this.colorItemMap.put(color, colorItem);
        }
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new FiledLayout(0, 2, 0));
        panel.add(labelPanel);
        panel.add(topPanel);
        return panel;
    }

    private JPanel createButtonPanel() {
        JBasicButton noColorButton = new JBasicButton(SwingLocale.getString("no_color"), new ColorIcon(null, new Color(226, 228, 231), 16, 16), SwingLocale.getString("no_color"));
        noColorButton.setUI(new LiteButtonUI(new JYellowLiteButtonStyle()));
        ButtonManager.setButtonLayout(noColorButton, new int[]{0, 2});
        noColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorSelector.this.hideParent();
                JColorSelector.this.setColor(null);
                JColorSelector.this.executeSelection();
            }
        });
        JBasicButton otherColorColorButton = new JBasicButton(SwingLocale.getString("other_color") + "...", IconFactory.getSwingIcon("palette.png"), SwingLocale.getString("other_color") + "...");
        otherColorColorButton.setUI(new LiteButtonUI(new JYellowLiteButtonStyle()));
        ButtonManager.setButtonLayout(otherColorColorButton, new int[]{0, 2});
        otherColorColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorSelector.this.hideParent();
                JColorSelector.this.setColor(JColorChooser.showDialog(HandleManager.getFrame(JColorSelector.this), SwingLocale.getString("color_selector"), JColorSelector.this.selectedColor));
                JColorSelector.this.executeSelection();
            }
        });
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new FiledLayout(0, 2, 0));
        panel.add(noColorButton);
        panel.add(new JBasicSeparator(0, "LoweredStyle", 22));
        panel.add(otherColorColorButton);
        return panel;
    }

    private JPanel createLabelPanel(String title) {
        JLabel label = new JLabel(title);
        label.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        JPanel labelPanel = new JPanel();
        labelPanel.setBackground(new Color(239, 243, 246));
        labelPanel.setPreferredSize(new Dimension(labelPanel.getPreferredSize().width, 22));
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(label);
        return labelPanel;
    }

    private void hideParent() {
        Component dialog;
        Component menu = HandleManager.getComponent(this, MenuElement.class);
        if (menu != null) {
            menu.setVisible(false);
        }
        if ((dialog = HandleManager.getComponent(this, Dialog.class)) != null) {
            dialog.setVisible(false);
        }
    }

    public Color getColor() {
        return this.selectedColor;
    }

    public void setColor(Color color) {
        this.selectedColor = color;
        for (ColorItem colorItem : this.colorItemMap.values()) {
            if (colorItem.getColor().equals(color)) {
                colorItem.setSelected(true);
                continue;
            }
            colorItem.setSelected(false);
        }
    }

    public abstract void executeSelection();

    public class ColorItem
    extends JPanel
    implements MouseListener {
        protected Color color;
        protected boolean selected;
        protected LineBorder normalBorder = new LineBorder(new Color(227, 228, 232));

        public ColorItem(Color color, int borderStyle) {
            this.color = color;
            switch (borderStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    this.normalBorder.setColor(null, 5);
                    break;
                }
                case 2: {
                    this.normalBorder.setColor(null, 1);
                    this.normalBorder.setColor(null, 5);
                    break;
                }
                case 3: {
                    this.normalBorder.setColor(null, 1);
                }
            }
            this.setBackground(color);
            this.setBorder(this.normalBorder);
            this.setToolTipText(SwingLocale.getString("red_short") + " " + color.getRed() + ", " + SwingLocale.getString("green_short") + " " + color.getGreen() + ", " + SwingLocale.getString("blue_short") + " " + color.getBlue());
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(13, 13);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            if (selected) {
                this.setBorder(JColorSelector.this.selectedBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JColorSelector.this.hideParent();
            JColorSelector.this.setColor(this.color);
            JColorSelector.this.executeSelection();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setBorder(JColorSelector.this.hoverBorder);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBorder(this.selected ? JColorSelector.this.selectedBorder : this.normalBorder);
        }
    }
}

