/*
 * Decompiled with CFR 0.152.
 */
package twaver.web;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.beans.BeanInfo;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.AlarmSeverity;
import twaver.AlarmState;
import twaver.Element;
import twaver.ElementAttribute;
import twaver.ElementAttributeVisibleFilter;
import twaver.EnumType;
import twaver.EnumTypeManager;
import twaver.TDataBox;
import twaver.TPropertyDescriptor;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.E.H;
import twaver.base.A.E.M;
import twaver.base.A.F.B.F;
import twaver.base.A.I.D;
import twaver.base.A.J.A;
import twaver.table.Category;
import twaver.table.renderer.AlarmStateRenderer;
import twaver.table.renderer.BooleanRenderer;
import twaver.table.renderer.ColorRenderer;
import twaver.table.renderer.DateRenderer;
import twaver.table.renderer.EnumTypeRenderer;
import twaver.table.renderer.FontRenderer;
import twaver.table.renderer.IconRenderer;
import twaver.table.renderer.IconURLRenderer;
import twaver.table.renderer.NumberRenderer;
import twaver.table.renderer.PointRenderer;
import twaver.table.renderer.StringRenderer;
import twaver.web.TWebView;

public class TWebPropertySheet
implements D,
TWebView {
    private String \u0297 = "sheet";
    public static final String StringRenderer = "";
    public static final String NumberRenderer = "numberRenderer";
    public static final String ColorRenderer = "colorRenderer";
    public static final String BooleanRenderer = "booleanRenderer";
    public static final String ImageRenderer = "imageRenderer";
    public static final String DateRenderer = "dateRenderer";
    public static final String PointRenderer = "pointRenderer";
    public static final String FontRenderer = "fontRenderer";
    public static final String AlarmStateRenderer = "alarmStateRenderer";
    private TDataBox \u028c = null;
    private int \u028d = TUIManager.getInt("sheet.mode");
    private int \u028f = TUIManager.getInt("sheet.property.distinct.level");
    private boolean \u028e = TUIManager.getBoolean("sheet.sorting.categories");
    private boolean \u0295 = TUIManager.getBoolean("sheet.sorting.properties");
    private Comparator \u0289 = null;
    private Comparator \u0293 = null;
    protected boolean isEditable = TUIManager.getBoolean("sheet.editable");
    private boolean \u028b = TUIManager.getBoolean("sheet.property.extra.indent");
    private boolean \u0287 = TUIManager.getBoolean("sheet.single.root.category.visible");
    private boolean \u0292 = TUIManager.getBoolean("sheet.category.font.bold");
    private boolean \u0296 = TUIManager.getBoolean("sheet.indent.opaque");
    private boolean \u0294 = TUIManager.getBoolean("sheet.sorting.ascending");
    private boolean \u0288 = TUIManager.getBoolean("sheet.restore.category.state");
    private ElementAttributeVisibleFilter \u0290 = null;
    private boolean \u0291 = false;
    private Map \u028a = new HashMap();

    public TWebPropertySheet() {
        this(new TDataBox());
    }

    public TWebPropertySheet(TDataBox box) {
        this.setDataBox(box);
        this.setPropertyExtraIndent(true);
    }

    public Iterator getSelection() {
        if (this.\u028c != null) {
            return this.\u028c.selection();
        }
        return null;
    }

    public Element getLastSelectedElement() {
        if (this.\u028c != null) {
            return this.\u028c.getLastSelectedElement();
        }
        return null;
    }

    public void setDataBox(TDataBox dataBox) {
        this.\u028c = dataBox;
    }

    public TDataBox getDataBox() {
        return this.\u028c;
    }

    public void updateTViewUI() {
    }

    public Comparator getCategorySortingComparator() {
        return this.\u0289;
    }

    public void setCategorySortingComparator(Comparator categorySortingComparator) {
        this.\u0289 = categorySortingComparator;
    }

    public boolean isIndentOpaque() {
        return this.\u0296;
    }

    public void setIndentOpaque(boolean indentOpaque) {
        this.\u0296 = indentOpaque;
    }

    public boolean isCategoryFontBold() {
        return this.\u0292;
    }

    public void setCategoryFontBold(boolean isCategoryFontBold) {
        this.\u0292 = isCategoryFontBold;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isRestoreCategoryState() {
        return this.\u0288;
    }

    public void setRestoreCategoryState(boolean isRestoreCategoryState) {
        this.\u0288 = isRestoreCategoryState;
    }

    public boolean isPropertyExtraIndent() {
        return this.\u028b;
    }

    public void setPropertyExtraIndent(boolean isPropertyExtraIndent) {
        this.\u028b = isPropertyExtraIndent;
    }

    public boolean isSingleRootCategoryVisible() {
        return this.\u0287;
    }

    public void setSingleRootCategoryVisible(boolean isSingleRootCategoryVisible) {
        this.\u0287 = isSingleRootCategoryVisible;
    }

    public int getMode() {
        return this.\u028d;
    }

    public void setMode(int mode) {
        this.\u028d = mode;
    }

    public int getPropertyDistinctLevel() {
        return this.\u028f;
    }

    public void setPropertyDistinctLevel(int propertyDistinctLevel) {
        this.\u028f = propertyDistinctLevel;
    }

    public Comparator getPropertySortingComparator() {
        return this.\u0293;
    }

    public void setPropertySortingComparator(Comparator propertySortingComparator) {
        this.\u0293 = propertySortingComparator;
    }

    public boolean isSortingCategories() {
        return this.\u028e;
    }

    public void setSortingCategories(boolean sortingCategories) {
        this.\u028e = sortingCategories;
    }

    public boolean isSortingProperties() {
        return this.\u0295;
    }

    public void setSortingProperties(boolean sortingProperties) {
        this.\u0295 = sortingProperties;
    }

    public boolean isSortingAscending() {
        return this.\u0294;
    }

    public void setSortingAscending(boolean sortingAscending) {
        this.\u0294 = sortingAscending;
    }

    public ElementAttributeVisibleFilter getElementAttributeVisibleFilter() {
        return this.\u0290;
    }

    public void setElementAttributeVisibleFilter(ElementAttributeVisibleFilter elementAttributeVisibleFilter) {
        this.\u0290 = elementAttributeVisibleFilter;
    }

    public boolean isVisible(ElementAttribute attribute) {
        if (attribute == null || !attribute.isVisible()) {
            return false;
        }
        int count = this.\u028c.getSelectionModel().size();
        if (count > 1 && !attribute.isEnableBatch()) {
            return false;
        }
        return this.\u0290 == null || this.\u0290.isVisible(attribute);
    }

    public void registerElementClassXML(Class elementClass, String url) {
        this.\u028a.put(elementClass, url);
    }

    public void registerElementClassXML(Class elementClass, InputStream inputStream) {
        List attributes = TWaverUtil.createElementAttributes(elementClass, inputStream);
        if (attributes != null) {
            this.registerElementClassAttributes(elementClass, attributes);
        }
    }

    public void registerElementClassAttributes(Class elementClass, List attributes) {
        BeanInfo beanInfo = H.A(elementClass, attributes);
        ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
        list.add(beanInfo);
        this.\u028a.put(elementClass, list);
    }

    public List getAllBeanInfo(Element element) {
        if (element == null) {
            return TWaverConst.EMPTY_LIST;
        }
        Class<?> elementClass = element.getClass();
        Object value = this.\u028a.get(elementClass);
        if (value instanceof String) {
            String url = value.toString();
            BeanInfo beanInfo = F.A().A(elementClass, url, false);
            if (beanInfo == null) {
                throw new NullPointerException("can not find xml '" + url + "'");
            }
            ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
            list.add(beanInfo);
            this.\u028a.put(elementClass, list);
            return list;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return F.A().E(elementClass);
    }

    private A C(final Element element) {
        return new A(this){

            public Iterator K() {
                ArrayList<Element> list = new ArrayList<Element>();
                list.add(element);
                return list.iterator();
            }

            public Element E() {
                return element;
            }
        };
    }

    public List getAllPropertyDescriptors(Element element) {
        return this.C(element).J();
    }

    public String toJSON(Element element) {
        if (element == null) {
            return StringRenderer;
        }
        StringBuffer sb = new StringBuffer("[");
        A model = this.C(element);
        try {
            model.D();
            model.I();
            Iterator it = model.A().iterator();
            while (it.hasNext()) {
                int i2;
                StringBuffer blank;
                int indet;
                Object object = it.next();
                StringBuffer displayName = new StringBuffer();
                if (object instanceof Category) {
                    Category category = (Category)object;
                    indet = model.A(category);
                    displayName = displayName.append(category.getDisplayName());
                    blank = new StringBuffer();
                    for (i2 = 0; i2 < indet; ++i2) {
                        blank = new StringBuffer("&nbsp;&nbsp;").append(blank);
                    }
                    displayName = blank.append(displayName);
                    sb.append("{\"name\":\"").append(displayName).append("\",\"value\":\"\"},");
                    continue;
                }
                TPropertyDescriptor property = (TPropertyDescriptor)object;
                displayName = displayName.append(property.getDisplayName());
                indet = model.B(property);
                blank = new StringBuffer();
                for (i2 = 0; i2 < indet; ++i2) {
                    blank = new StringBuffer("&nbsp;&nbsp;&nbsp;&nbsp;").append(blank);
                }
                displayName = blank.append(displayName);
                String[] displayValueAndRenderer = this.getElementDisplayValueAndRenderer(element, property);
                if (displayValueAndRenderer == null) {
                    sb.append("{\"name\":\"").append(displayName).append("\",\"value\":\"\"},");
                    continue;
                }
                if (StringRenderer.equals(displayValueAndRenderer[1])) {
                    sb.append("{\"name\":\"").append(displayName).append("\",\"value\":\"").append(displayValueAndRenderer[0]).append("\"},");
                    continue;
                }
                sb.append("{\"name\":\"").append(displayName).append("\",\"value\":\"").append(displayValueAndRenderer[0]).append("\",\"renderer\":\"").append(displayValueAndRenderer[1]).append("\"},");
            }
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
        }
        return sb.deleteCharAt(sb.length() - 1).append("]").toString();
    }

    protected String[] getElementDisplayValueAndRenderer(Element element, TPropertyDescriptor property) {
        ElementAttribute attribute = property.getElementAttribute();
        Object propertyValue = element.getPropertyValue(property);
        if (propertyValue == null) {
            return null;
        }
        String[] results = this.getElementPreDefineDisplayValueAndRenderer(attribute, propertyValue);
        return results == null ? this.getElementCustomDisplayValueAndRenderer(attribute, propertyValue) : results;
    }

    protected String[] getElementPreDefineDisplayValueAndRenderer(ElementAttribute attribute, Object propertyValue) {
        if (propertyValue instanceof Font) {
            return new String[]{M.A((Font)propertyValue), StringRenderer};
        }
        if (propertyValue instanceof Color) {
            return new String[]{M.A((Color)propertyValue, false), ColorRenderer};
        }
        if (propertyValue instanceof AlarmState) {
            AlarmState state = (AlarmState)propertyValue;
            if (state.getAlarmCount() < 1) {
                return new String[]{StringRenderer, StringRenderer};
            }
            StringBuffer alarmJSON = new StringBuffer();
            alarmJSON.append("[");
            Iterator iterator = AlarmSeverity.iterator();
            while (iterator.hasNext()) {
                AlarmSeverity severity = (AlarmSeverity)iterator.next();
                int newAlarms = state.getNewAlarmCount(severity);
                int ackAlarms = state.getAcknowledgedAlarmCount(severity);
                if (newAlarms == 0 && ackAlarms == 0) continue;
                alarmJSON.append("{'color':'" + M.A(severity.getColor(), false) + "',");
                alarmJSON.append("'newal':'" + newAlarms + "',");
                alarmJSON.append("'acknowal':'" + ackAlarms + "'},");
            }
            if (alarmJSON.length() > 5) {
                alarmJSON.deleteCharAt(alarmJSON.length() - 1);
            }
            alarmJSON.append("]");
            return new String[]{alarmJSON.toString(), AlarmStateRenderer};
        }
        return null;
    }

    protected String[] getElementCustomDisplayValueAndRenderer(ElementAttribute attribute, Object propertyValue) {
        String rendererClass = attribute.getRendererClass();
        if (rendererClass != null && rendererClass.startsWith(EnumTypeRenderer.class.getName())) {
            String enumTypeName = rendererClass.substring(rendererClass.indexOf("@") + 1, rendererClass.length());
            EnumType enumType = EnumTypeManager.getInstance().getEnumType(enumTypeName, propertyValue);
            return new String[]{enumType.getDisplayName(), StringRenderer};
        }
        String displayRenderer = this.getJavascriptRenderer(rendererClass, propertyValue);
        return new String[]{propertyValue.toString(), displayRenderer};
    }

    protected String getJavascriptRenderer(String rendererClass, Object value) {
        if (value == null) {
            return StringRenderer;
        }
        if (rendererClass != null) {
            if (rendererClass.startsWith(StringRenderer.class.getName())) {
                return StringRenderer;
            }
            if (rendererClass.startsWith(NumberRenderer.class.getName())) {
                return NumberRenderer;
            }
            if (rendererClass.startsWith(BooleanRenderer.class.getName())) {
                return BooleanRenderer;
            }
            if (rendererClass.startsWith(IconRenderer.class.getName()) || rendererClass.startsWith(IconURLRenderer.class.getName())) {
                return ImageRenderer;
            }
            if (rendererClass.startsWith(DateRenderer.class.getName())) {
                return DateRenderer;
            }
            if (rendererClass.startsWith(PointRenderer.class.getName())) {
                return PointRenderer;
            }
            if (rendererClass.startsWith(FontRenderer.class.getName())) {
                return FontRenderer;
            }
            if (rendererClass.startsWith(ColorRenderer.class.getName())) {
                return ColorRenderer;
            }
            if (rendererClass.startsWith(AlarmStateRenderer.class.getName())) {
                return AlarmStateRenderer;
            }
        } else {
            if (value instanceof Boolean) {
                return BooleanRenderer;
            }
            if (value instanceof Number) {
                return NumberRenderer;
            }
            if (value instanceof Image) {
                return ImageRenderer;
            }
            if (value instanceof java.util.Date || value instanceof Date) {
                return DateRenderer;
            }
            if (value instanceof Point2D) {
                return PointRenderer;
            }
            if (value instanceof Font) {
                return FontRenderer;
            }
            if (value instanceof Color) {
                return ColorRenderer;
            }
        }
        return StringRenderer;
    }

    public boolean isShowDescriptionColumn() {
        return this.\u0291;
    }

    public void setShowDescriptionColumn(boolean showDescriptionColumn) {
        this.\u0291 = showDescriptionColumn;
    }

    public Object getDescription(Element element, TPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getElementAttribute().getDescription();
    }

    public String getType() {
        return this.\u0297;
    }

    public void setType(String type) {
        this.\u0297 = type;
    }
}

