/*
 * Decompiled with CFR 0.152.
 */
package twaver.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.Group;
import twaver.TDataBox;
import twaver.TWaverUtil;
import twaver.UndoRedoEvent;
import twaver.base.A.E.H;
import twaver.tree.AbstractTTreeNode;
import twaver.tree.DnDHandler;
import twaver.tree.ElementNode;
import twaver.tree.TTree;

public class DefaultDnDHandler
implements DnDHandler {
    public static final StringSelection TRANSFERABLE = new StringSelection("box.selected.elements");

    public void drag(TTree tree, DragGestureEvent e2) {
        e2.startDrag(DragSource.DefaultMoveDrop, TRANSFERABLE, null);
    }

    public void drop(TTree tree, DropTargetDropEvent e2, Object target) {
        if (target == null || !(target instanceof AbstractTTreeNode)) {
            e2.rejectDrop();
            return;
        }
        if ((e2.getSourceActions() & 1) != 0) {
            e2.acceptDrop(1);
        } else if ((e2.getSourceActions() & 2) != 0) {
            e2.acceptDrop(2);
        } else {
            e2.rejectDrop();
            return;
        }
        try {
            Element targetElement = null;
            if (target instanceof ElementNode) {
                targetElement = ((ElementNode)target).getElement();
            }
            if (e2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)e2.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if ("box.selected.elements".equals(data)) {
                    this.dropProcess(tree, targetElement);
                } else {
                    this.dropProcess(tree, targetElement, data);
                }
            } else {
                this.dropProcess(tree, targetElement, e2);
            }
            e2.dropComplete(true);
            tree.requestFocus();
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            e2.rejectDrop();
        }
    }

    protected void dropProcess(TTree tree, Element targetElement, DropTargetDropEvent e2) {
    }

    protected void dropProcess(TTree tree, Element targetElement, String className) {
        if (className == null) {
            return;
        }
        if (className.startsWith("className:")) {
            className = className.substring("className:".length());
        }
        try {
            Element element = (Element)H.A(className).newInstance();
            element.setName(className.substring(className.lastIndexOf(".") + 1));
            element.setLocation(100.0, 100.0);
            element.setParent(targetElement);
            this.preProcess(element);
            tree.getDataBox().addElement(element);
        }
        catch (Exception e2) {
            TWaverUtil.handleError(null, e2);
        }
    }

    protected void preProcess(Element element) {
    }

    protected void dropProcess(TTree tree, Element targetElement) {
        List selectedElements = tree.getDataBox().getSelectionModel().getAllSelectedElement();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        if (selectedElements.contains(targetElement)) {
            return;
        }
        TDataBox box = tree.getDataBox();
        Iterator it = selectedElements.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (targetElement != null && targetElement.isDescendantOf(element)) continue;
            UndoRedoEvent event = null;
            if (box.getUndoRedoManager().getLimit() > 0) {
                event = new UndoRedoEvent(element, element.getParent(), targetElement);
            }
            tree.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            element.setParent(targetElement);
            tree.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
            if (event == null) continue;
            box.getUndoRedoManager().addEvent(event);
        }
        if (targetElement instanceof Group) {
            ((Group)targetElement).setExpand(true);
        }
    }
}

