/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Insets;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.TextActionTableCellEditor;

public class InsetsEditor
extends TextActionTableCellEditor {
    protected String toText(Object value) {
        if (value instanceof Insets) {
            Insets insets = (Insets)value;
            return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
        }
        return "0,0,0,0";
    }

    protected Object toValue(String text) {
        try {
            String[] values = text.split("\\,");
            return new Insets(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
        }
        catch (Exception ex) {
            return this.value;
        }
    }

    public InsetsEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public InsetsEditor(String alignment) {
        super(false, true, false, true);
        TWaverUtil.setHorizontalAlignment(this.textField, alignment);
    }

    public void setComponentValue() {
        this.textField.setText(this.toText(this.value));
    }

    public Object getCellEditorValue() {
        if (this.isClear) {
            return null;
        }
        String text = this.textField.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        return this.toValue(text);
    }
}

