/*
 * Decompiled with CFR 0.152.
 */
package twaver.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SingleFiledLayout
implements LayoutManager,
Serializable {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static int DEFAULT_GAP = 5;
    protected int orientation;
    protected int justification;
    protected int gap;

    public SingleFiledLayout() {
        this(0, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int orientation) {
        this(orientation, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int orientation, int justification) {
        this(orientation, justification, DEFAULT_GAP);
    }

    public SingleFiledLayout(int orientation, int justification, int gap) {
        if (orientation != 1) {
            orientation = 0;
        }
        if (justification != 1 && justification != 2 && justification != 4) {
            justification = 0;
        }
        if (gap < 0) {
            gap = 0;
        }
        this.orientation = orientation;
        this.justification = justification;
        this.gap = gap;
    }

    public void layoutContainer(Container container) {
        Dimension size = container.getSize();
        Insets inset = container.getInsets();
        int x = inset.left;
        int y = inset.top;
        Component[] component = container.getComponents();
        if (this.orientation == 0) {
            for (int counter = 0; counter < component.length; ++counter) {
                Dimension d2 = component[counter].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        x = inset.left;
                        break;
                    }
                    case 1: {
                        x = (size.width - d2.width >> 1) + inset.left - inset.right;
                        break;
                    }
                    case 2: {
                        x = inset.left;
                        d2.width = size.width - inset.left - inset.right;
                        break;
                    }
                    case 4: {
                        x = size.width - d2.width - inset.right;
                    }
                }
                component[counter].setBounds(x, y, d2.width, d2.height);
                y += d2.height + this.gap;
            }
        } else {
            for (int counter = 0; counter < component.length; ++counter) {
                Dimension d3 = component[counter].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        y = inset.top;
                        break;
                    }
                    case 1: {
                        y = (size.height - d3.height >> 1) + inset.top - inset.bottom;
                        break;
                    }
                    case 2: {
                        y = inset.top;
                        d3.height = size.height - inset.top - inset.bottom;
                        break;
                    }
                    case 3: {
                        y = size.height - d3.height - inset.bottom;
                    }
                }
                component[counter].setBounds(x, y, d3.width, d3.height);
                x += d3.width + this.gap;
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        int counter;
        int totalWidth = 0;
        int totalHeight = 0;
        Component[] component = container.getComponents();
        if (this.orientation == 0) {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d2 = component[counter].getPreferredSize();
                if (totalWidth < d2.width) {
                    totalWidth = d2.width;
                }
                totalHeight += d2.height + this.gap;
            }
            totalHeight -= this.gap;
        } else {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d3 = component[counter].getPreferredSize();
                totalWidth += d3.width + this.gap;
                if (totalHeight >= d3.height) continue;
                totalHeight = d3.height;
            }
            totalWidth -= this.gap;
        }
        Insets inset = container.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int counter;
        int totalWidth = 0;
        int totalHeight = 0;
        Component[] component = container.getComponents();
        if (this.orientation == 0) {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d2 = component[counter].getMinimumSize();
                if (totalWidth < d2.width) {
                    totalWidth = d2.width;
                }
                totalHeight += d2.height + this.gap;
            }
            totalHeight -= this.gap;
        } else {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d3 = component[counter].getMinimumSize();
                totalWidth += d3.width + this.gap;
                if (totalHeight >= d3.height) continue;
                totalHeight = d3.height;
            }
            totalWidth = -this.gap;
        }
        Insets inset = container.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

