/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.element;

import com.nepxion.cots.twaver.element.TElement;
import com.nepxion.cots.twaver.locale.TLocale;
import twaver.Element;
import twaver.GeoCoordinate;
import twaver.Node;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverUtil;

public class TNode
extends Node
implements TElement {
    private boolean isMovable = true;
    private boolean isChildrenHidden = false;
    private boolean isChildrenHiddenPermitted = false;
    private boolean isLeaf = false;
    private boolean isCategory = false;
    private boolean isSpecial = false;
    private boolean isDeletePermitted = true;

    public TNode() {
        this.initComponents();
    }

    public TNode(Object id) {
        super(id);
        this.initComponents();
    }

    private void initComponents() {
        this.putClientProperty("label.yoffset", TWaverUtil.valueOf((int)4));
    }

    public GeoCoordinate getGeoCoordinate() {
        GeoCoordinate geoCoordinate = (GeoCoordinate)this.getClientProperty("geocoordinates");
        return geoCoordinate;
    }

    public void setGeoCoordinate(GeoCoordinate geoCoordinate) {
        this.putClientProperty("geocoordinates", geoCoordinate);
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
        if (this.isMovable) {
            this.removeAttachment("pin");
        } else {
            this.addAttachment("pin");
        }
    }

    public boolean isChildrenHidden() {
        return this.isChildrenHidden;
    }

    public void setChildrenHidden(boolean isChildrenHidden) {
        this.isChildrenHidden = isChildrenHidden;
        if (this.isChildrenHiddenPermitted) {
            if (this.isChildrenHidden) {
                this.addAttachment("expand");
                this.removeAttachment("collapse");
            } else {
                this.addAttachment("collapse");
                this.removeAttachment("expand");
            }
        }
    }

    public void enableChildrenHidden() {
        if (this.childrenSize() == 0) {
            this.isChildrenHiddenPermitted = false;
            this.removeAttachment("expand");
            this.removeAttachment("collapse");
        } else {
            this.isChildrenHiddenPermitted = true;
            this.setChildrenHidden(this.isChildrenHidden);
        }
    }

    public Element copy() {
        TNode node = (TNode)super.copy();
        this.copyProperty(node, true);
        return node;
    }

    public Element copy(Object id) {
        TNode node = (TNode)super.copy(id);
        this.copyProperty(node, true);
        return node;
    }

    public Element copy(TDataBox box) {
        TNode node = (TNode)super.copy(box);
        this.copyProperty(node, true);
        return node;
    }

    public Element copy(Object id, TDataBox box) {
        TNode node = (TNode)super.copy(id, box);
        this.copyProperty(node, true);
        return node;
    }

    public Element copyAll() {
        TNode node = (TNode)super.copy();
        this.copyProperty(node, false);
        node.setUserObject(this.getUserObject());
        return node;
    }

    private void copyProperty(TNode node, boolean changeName) {
        if (changeName) {
            node.setName(TLocale.getString("element_copied") + " " + this.getName());
        }
        node.setMovable(true);
        node.enableChildrenHidden();
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public boolean isCategory() {
        return this.isCategory;
    }

    @Override
    public void setCategory(boolean isCategory) {
        this.isCategory = isCategory;
    }

    @Override
    public boolean isSpecial() {
        return this.isSpecial;
    }

    @Override
    public void setSpecial(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @Override
    public boolean isDeletePermitted() {
        return this.isDeletePermitted;
    }

    @Override
    public void setDeletePermitted(boolean isDeletePermitted) {
        this.isDeletePermitted = isDeletePermitted;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TUIManager.registerAttachment((String)"expand", (String)"/com/nepxion/cots/twaver/icon/image/expand.png", (int)6, (int)-15, (int)13);
        TUIManager.registerAttachment((String)"collapse", (String)"/com/nepxion/cots/twaver/icon/image/collapse.png", (int)6, (int)-15, (int)13);
        TUIManager.registerAttachment((String)"pin", (String)"/com/nepxion/cots/twaver/icon/image/pin.png", (int)7, (int)20, (int)13);
    }
}

