/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.pie;

import com.nepxion.swing.chart.ChartConstants;
import com.nepxion.swing.chart.pie.IPieChartPlot;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;

public class PieSelectionAdapter
implements ChartMouseListener,
ChartConstants {
    private IPieChartPlot piePlot;

    public void chartMouseMoved(ChartMouseEvent e) {
        this.adaptSelection(e, true);
    }

    public void chartMouseClicked(ChartMouseEvent e) {
        this.adaptSelection(e, false);
    }

    private void adaptSelection(ChartMouseEvent e, boolean isMouseOver) {
        JFreeChart chart = e.getChart();
        ChartEntity chartEntity = e.getEntity();
        if (chartEntity instanceof PieSectionEntity) {
            this.piePlot = (IPieChartPlot)chart.getPlot();
            PieSectionEntity pieSectionEntity = (PieSectionEntity)chartEntity;
            Comparable key = pieSectionEntity.getSectionKey();
            if (isMouseOver) {
                this.piePlot.dispatchMouseOver(key);
            } else {
                this.piePlot.dispatchMouseDown(key);
            }
        } else if (this.piePlot != null) {
            if (isMouseOver) {
                this.piePlot.dispatchMouseOver(null);
            } else {
                this.piePlot.dispatchMouseDown(null);
            }
        }
    }
}

