/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.time;

import com.nepxion.util.time.TimeConstants;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class TimeUtil
implements TimeConstants {
    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getCurrentDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getCurrentHour() {
        return Calendar.getInstance().get(11);
    }

    public static int getCurrentMinute() {
        return Calendar.getInstance().get(12);
    }

    public static int getCurrentSecond() {
        return Calendar.getInstance().get(13);
    }

    public static int getCurrentMillisecond() {
        return Calendar.getInstance().get(14);
    }

    public static String getCurrentDateTime() {
        return TimeUtil.getDateTime(new Date());
    }

    public static String getDateTime(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getDateTimeFormat());
    }

    public static String getMillisecondDateTime(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getMillisecondDateTimeFormat());
    }

    public static String getTimeZoneDateTime(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getTimeZoneDateTimeFormat());
    }

    public static String getCurrentDate() {
        return TimeUtil.getDate(new Date());
    }

    public static String getDate(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getDateFormat());
    }

    public static String getCurrentTime() {
        return TimeUtil.getTime(new Date());
    }

    public static String getTime(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getTimeFormat());
    }

    public static String getCurrentMillisecondTime() {
        return TimeUtil.getMillisecondTime(new Date());
    }

    public static String getMillisecondTime(Date date) {
        return TimeUtil.getFormatString(date, TimeUtil.getMillisecondTimeFormat());
    }

    public static String getFormatString(Date date, DateFormat dateFormat) {
        return dateFormat.format(date);
    }

    public static int getCurrentDayOfWeek() {
        return Calendar.getInstance().get(7);
    }

    public static int getDayOfWeek(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
        return calendar.get(7);
    }

    public static int getCurrentWeekOfMonth() {
        return Calendar.getInstance().get(4);
    }

    public static int getWeekOfMonth(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
        return calendar.get(4);
    }

    public static int getCurrentWeekOfYear() {
        return Calendar.getInstance().get(3);
    }

    public static int getWeekOfYear(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
        return calendar.get(3);
    }

    public static Date parseDateTime(String date) {
        return TimeUtil.parseFormatDate(date, TimeUtil.getDateTimeFormat());
    }

    public static Date parseTimeZoneDateTime(String date) {
        return TimeUtil.parseFormatDate(date, TimeUtil.getTimeZoneDateTimeFormat());
    }

    public static Date parseDate(String date) {
        return TimeUtil.parseFormatDate(date, TimeUtil.getDateFormat());
    }

    public static Date parseTime(String time) {
        return TimeUtil.parseFormatDate(time, TimeUtil.getTimeFormat());
    }

    public static Date parseFormatDate(String dateString, DateFormat dateFormat) {
        dateString = dateString.trim();
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static GregorianCalendar getCalendar(String dateTime) {
        GregorianCalendar gc = new GregorianCalendar();
        Date date = TimeUtil.parseDateTime(dateTime);
        gc.setTime(date);
        return gc;
    }

    public static int getDSTOffset(Date date) {
        return TimeUtil.getDSTOffset(date, TimeZone.getDefault());
    }

    public static int getDSTOffset(Date date, TimeZone timeZone) {
        if (timeZone.inDaylightTime(date)) {
            int offset = timeZone.getOffset(date.getTime()) - timeZone.getRawOffset();
            return offset;
        }
        return 0;
    }

    public static String getTimeInterval(long startMillisecond, long endMillisecond) {
        long second = Math.abs(startMillisecond - endMillisecond) / 1000L;
        long hour = second / 3600L;
        long minute = (second -= hour * 3600L) / 60L;
        return TimeUtil.getTimeString(hour, minute, second -= minute * 60L);
    }

    public static String getMillisecondTimeInterval(long startMillisecond, long endMillisecond) {
        long millisecond = Math.abs(startMillisecond - endMillisecond);
        long hour = millisecond / 3600000L;
        long minute = (millisecond -= hour * 3600000L) / 60000L;
        long second = (millisecond -= minute * 60000L) / 1000L;
        return TimeUtil.getMillisecondTimeString(hour, minute, second, millisecond -= second * 1000L);
    }

    public static boolean isTimeBefore(String time1, String time2) {
        return TimeUtil.isTimeBefore(time1, time2, TimeUtil.getDateTimeFormat());
    }

    public static boolean isTimeBefore(String time1, String time2, DateFormat dateFormat) {
        time1 = time1.trim();
        time2 = time2.trim();
        try {
            return dateFormat.parse(time1).before(dateFormat.parse(time2));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTimeBefore(String time) {
        return TimeUtil.isTimeBefore(time, TimeUtil.getDateTimeFormat());
    }

    public static boolean isTimeBefore(String time, DateFormat dateFormat) {
        time = time.trim();
        try {
            Date currentTime = new Date();
            return dateFormat.parse(time).before(currentTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTimeAfter(String time1, String time2) {
        return TimeUtil.isTimeAfter(time1, time2, TimeUtil.getDateTimeFormat());
    }

    public static boolean isTimeAfter(String time1, String time2, DateFormat dateFormat) {
        time1 = time1.trim();
        time2 = time2.trim();
        try {
            return dateFormat.parse(time1).after(dateFormat.parse(time2));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTimeAfter(String time) {
        return TimeUtil.isTimeAfter(time, TimeUtil.getDateTimeFormat());
    }

    public static boolean isTimeAfter(String time, DateFormat dateFormat) {
        time = time.trim();
        try {
            Date currentTime = new Date();
            return dateFormat.parse(time).after(currentTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getDateMillisecond(Date date) {
        return date.getTime() - TimeUtil.getTimeMillisecond(date);
    }

    public static long getTimeMillisecond(Date date) {
        return date.getTime() % 86400000L;
    }

    public static long getSecond(int[] timeArray) {
        return timeArray[0] * 24 * 60 * 60 + timeArray[1] * 60 * 60 + timeArray[2] * 60 + timeArray[3];
    }

    public static long getMillisecond(int[] timeArray) {
        return TimeUtil.getSecond(timeArray) * 1000L + (long)timeArray[4];
    }

    public static int[] parseTimeArray(String timeString, String delimiter) {
        int[] timeArray = new int[4];
        StringTokenizer st = new StringTokenizer(timeString, delimiter);
        int i = 0;
        while (st.hasMoreTokens()) {
            timeArray[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return timeArray;
    }

    public static int[] parseMillisecondTimeArray(String timeString, String delimiter) {
        int[] timeArray = new int[5];
        StringTokenizer st = new StringTokenizer(timeString, delimiter);
        int i = 0;
        while (st.hasMoreTokens()) {
            timeArray[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return timeArray;
    }

    public static String getDateString(long year, long month, long day) {
        String yearString = year + "";
        String monthString = null;
        String dayString = null;
        monthString = month < 10L ? "0" + month : "" + month;
        dayString = day < 10L ? "0" + day : "" + day;
        return yearString + "-" + monthString + "-" + dayString;
    }

    public static String getTimeString(long hour, long minute, long second) {
        String hourString = null;
        String minuteString = null;
        String secondString = null;
        hourString = hour < 10L ? "0" + hour : "" + hour;
        minuteString = minute < 10L ? "0" + minute : "" + minute;
        secondString = second < 10L ? "0" + second : "" + second;
        return hourString + ":" + minuteString + ":" + secondString;
    }

    public static String getMillisecondTimeString(long hour, long minute, long second, long millisecond) {
        String hourString = null;
        String minuteString = null;
        String secondString = null;
        String millisecondString = null;
        hourString = hour < 10L ? "0" + hour : "" + hour;
        minuteString = minute < 10L ? "0" + minute : "" + minute;
        secondString = second < 10L ? "0" + second : "" + second;
        millisecondString = millisecond < 10L ? "00" + millisecond : (millisecond < 100L ? "0" + millisecond : "" + millisecond);
        return hourString + ":" + minuteString + ":" + secondString + ":" + millisecondString;
    }

    public static String getDateTimeString(Date date, String formatString) {
        String dateTimeString = null;
        if (formatString.equals("yyyy-MM-dd HH:mm:ss")) {
            dateTimeString = TimeUtil.getDateTime(date);
        } else if (formatString.equals("yyyy-MM-dd HH:mm:ss:SSS")) {
            dateTimeString = TimeUtil.getMillisecondDateTime(date);
        } else if (formatString.equals("yyyy-MM-dd HH:mm:ss zzzz")) {
            dateTimeString = TimeUtil.getTimeZoneDateTime(date);
        } else if (formatString.equals("yyyy-MM-dd")) {
            dateTimeString = TimeUtil.getDate(date);
        } else if (formatString.equals("HH:mm:ss")) {
            dateTimeString = TimeUtil.getTime(date);
        } else if (formatString.equals("HH:mm:ss:SSS")) {
            dateTimeString = TimeUtil.getMillisecondTime(date);
        }
        if (dateTimeString == null) {
            dateTimeString = TimeUtil.getDateTime(date);
        }
        return dateTimeString;
    }

    public static synchronized DateFormat getDateTimeFormat() {
        return DATE_TIME_FORMAT;
    }

    public static synchronized DateFormat getMillisecondDateTimeFormat() {
        return MILLISECOND_DATE_TIME_FORMAT;
    }

    public static synchronized DateFormat getTimeZoneDateTimeFormat() {
        return TIME_ZONE_DATE_TIME_FORMAT;
    }

    public static synchronized DateFormat getDateFormat() {
        return DATE_FORMAT;
    }

    public static synchronized DateFormat getTimeFormat() {
        return TIME_FORMAT;
    }

    public static synchronized DateFormat getMillisecondTimeFormat() {
        return MILLISECOND_TIME_FORMAT;
    }

    public static Date calculateDateTime(Date dateTime, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static List delimitDateTime(Date startDateTime, Date endDateTime, int delimitedSecond) throws IllegalArgumentException {
        long delimitedMillisecond;
        long interval = endDateTime.getTime() - startDateTime.getTime();
        if (interval < (delimitedMillisecond = (long)(delimitedSecond * 1000))) {
            throw new IllegalArgumentException();
        }
        int splitCount = (int)(interval / delimitedMillisecond);
        ArrayList<Date> dateTimes = new ArrayList<Date>();
        dateTimes.add(startDateTime);
        for (int i = 0; i < splitCount; ++i) {
            Date lastDateTime = (Date)dateTimes.get(dateTimes.size() - 1);
            Date dateTime = new Date(lastDateTime.getTime() + delimitedMillisecond);
            dateTimes.add(dateTime);
        }
        Date lastDateTime = (Date)dateTimes.get(dateTimes.size() - 1);
        if (lastDateTime.getTime() < endDateTime.getTime()) {
            Date dateTime = new Date(lastDateTime.getTime() + delimitedMillisecond);
            dateTimes.add(dateTime);
        }
        return dateTimes;
    }

    public static Date[] getRangeDateTimes(List dateTimes, Date dateTime, boolean millisecondIgnored) {
        for (int i = 0; i < dateTimes.size() - 1; ++i) {
            Date dateTime1 = (Date)dateTimes.get(i);
            Date dateTime2 = (Date)dateTimes.get(i + 1);
            long time = dateTime.getTime();
            long time1 = dateTime1.getTime();
            long time2 = dateTime2.getTime();
            if (millisecondIgnored) {
                time1 -= time1 % 1000L;
                time2 -= time2 % 1000L;
            }
            if (time < time1 || time > time2) continue;
            return new Date[]{dateTime1, dateTime2};
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

