/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import twaver.PolySubNetwork;
import twaver.TWaverConst;
import twaver.base.A.D.K;
import twaver.base.A.E.b;
import twaver.base.A.E.d;
import twaver.network.TNetwork;
import twaver.network.ui.BorderUI;
import twaver.network.ui.DefaultBorderUI;
import twaver.network.ui.SubNetworkUI;

public class PolySubNetworkUI
extends SubNetworkUI {
    private static final int d = 1;
    private int a = twaver.base.A.E.b.J(this.element, "poly.outline.width");
    private Color Z = twaver.base.A.E.b.P(this.element, "poly.outline.color");
    private boolean c = twaver.base.A.E.b.K(this.element, "poly.fill");
    private boolean b = twaver.base.A.E.b.K(this.element, "poly.3d");
    private Rectangle _ = null;

    public PolySubNetworkUI(TNetwork network, PolySubNetwork subnetwork) {
        super(network, subnetwork);
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        super.elementPropertyChange(evt);
        String propertyName = twaver.base.A.E.b.A(evt);
        if (propertyName.equals("location")) {
            this.updateBounds();
        }
    }

    public PolySubNetwork getPolySubNetwork() {
        return (PolySubNetwork)this.element;
    }

    public void paintBody(Graphics2D g2d) {
        GeneralPath shape = this.getPolySubNetwork().getShape();
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        this.A(g2d, shape);
        g2d.setStroke(oldStroke);
        g2d.setPaint(oldPaint);
    }

    private void A(Graphics g2, Shape shape) {
        Area area;
        Shape newShape;
        Color stateOutlineColor;
        Graphics2D g2d = (Graphics2D)g2;
        AffineTransform atShadow1 = AffineTransform.getTranslateInstance(-1.0, -1.0);
        AffineTransform atShadow2 = AffineTransform.getTranslateInstance(1.0, 1.0);
        if (this.c) {
            Paint oldpaint = g2d.getPaint();
            this.setBodyPaint(g2d, this.getPaintBodyColor(this.color));
            g2d.fill(shape);
            g2d.setPaint(oldpaint);
        }
        if (this.a > 0) {
            g2d.setStroke(twaver.base.A.E.d.B(this.a));
            Color paintedColor = this.getPaintBodyColor(this.Z);
            if (this.b) {
                g2d.setColor(paintedColor.brighter().brighter());
                g2d.draw(atShadow1.createTransformedShape(shape));
                g2d.setColor(paintedColor.darker().darker());
                g2d.draw(atShadow2.createTransformedShape(shape));
            }
            g2d.setColor(paintedColor);
            g2d.draw(shape);
        }
        if ((stateOutlineColor = this.getStateOutlineColor()) != null) {
            g2d.setColor(stateOutlineColor);
            newShape = twaver.base.A.E.d.B(this.a + 4).createStrokedShape(shape);
            area = new Area(newShape);
            area.add(new Area(shape));
            g2d.setStroke(TWaverConst.DOUBLE_WIDTH_STROKE);
            g2d.draw(area);
        }
        if (this.element.isSelected() && this.network.isSelectedStatePaintable(this.element)) {
            newShape = twaver.base.A.E.d.B(this.a + 4).createStrokedShape(shape);
            area = new Area(newShape);
            g2d.setColor(this.getColor());
            g2d.setStroke(twaver.base.A.E.b.F(this.element, "border.stroke"));
            g2d.draw(area);
        }
    }

    public void paintBorder(Graphics2D g2d) {
        if (this.isCustomDraw()) {
            super.paintBorder(g2d);
        }
    }

    public void paintStateOutline(Graphics2D g2d) {
    }

    protected void updateBounds() {
        this._ = null;
    }

    public Rectangle getUIBounds() {
        if (this._ != null) {
            return this._;
        }
        return super.getUIBounds();
    }

    public boolean contains(int x, int y) {
        if (this.isCustomDraw()) {
            return super.contains(x, y);
        }
        BasicStroke stroke = twaver.base.A.E.d.B(this.a);
        Area area = new Area(stroke.createStrokedShape(this.getPolySubNetwork().getShape()));
        area.add(new Area(this.getPolySubNetwork().getShape()));
        Area attachmentArea = this.getSeletableAttachementsArea();
        if (attachmentArea != null) {
            area.add(attachmentArea);
        }
        return area.contains(x, y);
    }

    public void updateClientProperty(String propertyName) {
        if (!propertyName.startsWith("poly.")) {
            super.updateClientProperty(propertyName);
            return;
        }
        if (propertyName.equals("poly.outline.width")) {
            this.a = twaver.base.A.E.b.J(this.element, "poly.outline.width");
        } else if (propertyName.equals("poly.outline.color")) {
            this.Z = twaver.base.A.E.b.P(this.element, "poly.outline.color");
        } else if (propertyName.equals("poly.fill")) {
            this.c = twaver.base.A.E.b.K(this.element, "poly.fill");
        } else if (propertyName.equals("poly.3d")) {
            this.b = twaver.base.A.E.b.K(this.element, "poly.3d");
        }
    }

    public Point getHotspot() {
        if (this.isCustomDraw()) {
            K shapeFactory = this.getShapeFactory();
            return shapeFactory.B(this, this.element.getBounds());
        }
        Rectangle bounds = this.element.getBounds();
        Point hotSpot = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        if (bounds.width > 3) {
            hotSpot.x -= 3;
        }
        if (bounds.height > 3) {
            hotSpot.y += 3;
        }
        return hotSpot;
    }

    public BorderUI getBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = new DefaultBorderUI(this);
        }
        return this.defaultBorder;
    }
}

