/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.window;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;

public class WindowManager {
    public static void setCenter(Window window) {
        WindowManager.setCenter(window, null);
    }

    public static void setCenter(Window window, Dimension windowDimension) {
        Rectangle screenBounds = WindowManager.getPreferredBounds(window);
        if (windowDimension == null) {
            windowDimension = new Dimension(screenBounds.width, screenBounds.height);
        }
        WindowManager.setCenter(window, screenBounds, windowDimension);
    }

    public static void setCenter(Window window, Rectangle screenBounds, Dimension windowDimension) {
        window.setSize(windowDimension);
        window.setLocation((screenBounds.width - windowDimension.width) / 2 + screenBounds.x, (screenBounds.height - windowDimension.height) / 2 + screenBounds.y);
    }

    public static void setAlwaysOnTop(Window window, boolean isAlwaysOnTop) {
        window.setAlwaysOnTop(isAlwaysOnTop);
    }

    public static Rectangle getPreferredBounds(Window window) {
        GraphicsConfiguration configuration = window.getGraphicsConfiguration();
        Rectangle bounds = configuration.getBounds();
        Insets screenInsets = window.getToolkit().getScreenInsets(configuration);
        bounds = new Rectangle(screenInsets.left, screenInsets.top, bounds.width - screenInsets.right - screenInsets.left, bounds.height - screenInsets.bottom - screenInsets.top);
        return bounds;
    }
}

