/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TLayoutType;
import com.nepxion.cots.twaver.graph.TLiteLayouter;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.checkbox.JBasicCheckBox;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.layout.table.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TLiteLayoutPanel
extends JPanel {
    private JLabel typeLabel;
    private JBasicComboBox typeComboBox;
    private JLabel gapLabel;
    private JSlider gapSlider;
    private JLabel animationLabel;
    private JBasicCheckBox animationCheckBox;
    private JBasicButton runButton;
    private JBasicButton stopButton;
    private TLiteLayouter liteLayouter;

    public TLiteLayoutPanel(TGraph graph) {
        this.liteLayouter = new TLiteLayouter(graph);
        this.typeLabel = new JLabel(TLocale.getString("layout_type"));
        this.typeComboBox = new JBasicComboBox((Object[])new TLayoutType[]{TLayoutType.LITE_ORGANIC_LAYOUT_TYPE, TLayoutType.LITE_SMART_ORGANIC_LAYOUT_TYPE, TLayoutType.LITE_HIERARCHIC_LAYOUT_TYPE, TLayoutType.LITE_ORTHOGONAL_LAYOUT_TYPE, TLayoutType.LITE_CIRCULAR_LAYOUT_TYPE, TLayoutType.LITE_SINGLE_CYCLE_LAYOUT_TYPE, TLayoutType.LITE_TREE_LAYOUT_TYPE, TLayoutType.LITE_BALLOON_TREE_LAYOUT_TYPE, TLayoutType.LITE_RANDOM_LAYOUT_TYPE});
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLiteLayoutPanel.this.doLayout(TLiteLayoutPanel.this.stopButton.isEnabled());
            }
        });
        double[][] size1 = new double[][]{{0.35, 0.65}, {22.0}};
        JPanel layoutModePanel = new JPanel();
        layoutModePanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("layout_type_setting")));
        layoutModePanel.setLayout((LayoutManager)new TableLayout((double[][])size1));
        layoutModePanel.add((Component)this.typeLabel, "0, 0");
        layoutModePanel.add((Component)this.typeComboBox, "1, 0");
        this.gapLabel = new JLabel(TLocale.getString("layout_gap"));
        this.gapSlider = new JSlider(1, 500, 100);
        this.gapSlider.setToolTipText(this.gapSlider.getValue() + "");
        this.gapSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLiteLayoutPanel.this.doLayout(TLiteLayoutPanel.this.stopButton.isEnabled());
                TLiteLayoutPanel.this.gapSlider.setToolTipText(TLiteLayoutPanel.this.gapSlider.getValue() + "");
            }
        });
        this.animationLabel = new JLabel(TLocale.getString("layout_effect"));
        this.animationCheckBox = new JBasicCheckBox(TLocale.getString("layout_effect_animation"), true);
        double[][] size2 = new double[][]{{0.35, 0.65}, {22.0, 22.0}};
        JPanel layoutParamPanel = new JPanel();
        layoutParamPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("layout_parameter_setting")));
        layoutParamPanel.setLayout((LayoutManager)new TableLayout((double[][])size2));
        layoutParamPanel.add((Component)this.gapLabel, "0, 0");
        layoutParamPanel.add((Component)this.gapSlider, "1, 0");
        layoutParamPanel.add((Component)this.animationLabel, "0, 1");
        layoutParamPanel.add((Component)this.animationCheckBox, "1, 1");
        this.runButton = new JBasicButton(TLocale.getString("layout_run"), (Icon)TIconFactory.getContextIcon("run.png"), TLocale.getString("layout_run_description"));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLiteLayoutPanel.this.doLayout(true);
                TLiteLayoutPanel.this.runButton.setEnabled(false);
                TLiteLayoutPanel.this.stopButton.setEnabled(true);
            }
        });
        this.stopButton = new JBasicButton(TLocale.getString("layout_stop"), (Icon)TIconFactory.getContextIcon("stop.png"), TLocale.getString("layout_stop_description"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLiteLayoutPanel.this.runButton.setEnabled(true);
                TLiteLayoutPanel.this.stopButton.setEnabled(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add((Component)this.runButton);
        buttonPanel.add((Component)this.stopButton);
        buttonPanel.add(Box.createGlue());
        ButtonManager.updateUI((Container)buttonPanel, (Dimension)new Dimension(55, 25));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(layoutModePanel);
        this.add(layoutParamPanel);
        this.add(buttonPanel);
        this.typeComboBox.setSelectedIndex(0);
    }

    private void doLayout(boolean enabled) {
        if (enabled) {
            TLayoutType layoutType = (TLayoutType)this.typeComboBox.getSelectedItem();
            this.doLayout(layoutType);
        }
    }

    private void doLayout(TLayoutType layoutType) {
        if (layoutType.equals(TLayoutType.LITE_ORGANIC_LAYOUT_TYPE)) {
            this.liteLayouter.doOrganicLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_SMART_ORGANIC_LAYOUT_TYPE)) {
            this.liteLayouter.doSmartOrganicLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_HIERARCHIC_LAYOUT_TYPE)) {
            this.liteLayouter.doHierarchicLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_ORTHOGONAL_LAYOUT_TYPE)) {
            this.liteLayouter.doOrthogonalLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_CIRCULAR_LAYOUT_TYPE)) {
            this.liteLayouter.doCircularLayout(this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_SINGLE_CYCLE_LAYOUT_TYPE)) {
            this.liteLayouter.doSingleCycleLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_TREE_LAYOUT_TYPE)) {
            this.liteLayouter.doTreeLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_AR_TREE_LAYOUT_TYPE)) {
            this.liteLayouter.doARTreeLayout(this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_HV_TREE_LAYOUT_TYPE)) {
            this.liteLayouter.doHVTreeLayout(this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_BALLOON_TREE_LAYOUT_TYPE)) {
            this.liteLayouter.doBalloonTreeLayout(this.gapSlider.getValue(), this.animationCheckBox.isSelected());
        } else if (layoutType.equals(TLayoutType.LITE_RANDOM_LAYOUT_TYPE)) {
            this.liteLayouter.doRandomLayout(this.animationCheckBox.isSelected());
        }
    }
}

