/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.shrinkbar.BasicShrinkBar;
import com.nepxion.swing.shrinkbar.JShrinkOutlook;
import com.nepxion.swing.style.texture.shrink.IHeaderTextureStyle;
import com.nepxion.swing.style.texture.shrink.IOutlookTextureStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JShrinkOutlookBar
extends BasicShrinkBar {
    private TableLayout tableLayout;
    private Map tableLayoutMap;
    private JComponent contentPane;
    private JComponent outlookContentPane;
    private JComponent fillContentPane;
    private IOutlookTextureStyle outlookTextureStyle;

    public JShrinkOutlookBar(int placement) {
        this(placement, 2);
    }

    public JShrinkOutlookBar(int placement, IHeaderTextureStyle headerTextureStyle, IOutlookTextureStyle outlookTextureStyle) {
        this(placement, 2, headerTextureStyle, outlookTextureStyle);
    }

    public JShrinkOutlookBar(int placement, int contentPaneType) {
        this(placement, contentPaneType, DEFAULT_HEADER_TEXTURE_STYLE, DEFAULT_OUTLOOK_TEXTURE_STYLE);
    }

    public JShrinkOutlookBar(int placement, int contentPaneType, IHeaderTextureStyle headerTextureStyle, IOutlookTextureStyle outlookTextureStyle) {
        super(placement, contentPaneType, headerTextureStyle);
        this.outlookTextureStyle = outlookTextureStyle;
        this.initComponents();
    }

    private void initComponents() {
        this.tableLayout = new TableLayout();
        this.tableLayout.insertColumn(0, -1.0);
        this.tableLayoutMap = new Hashtable();
        this.outlookContentPane = new JPanel();
        this.outlookContentPane.setLayout(this.tableLayout);
        this.fillContentPane = new JPanel();
        this.fillContentPane.setLayout(new BorderLayout());
        this.fillContentPane.setBackground(UIManager.getColor("Panel.background"));
        this.fillContentPane.setPreferredSize(new Dimension(0, 0));
        this.fillContentPane.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(JShrinkOutlookBar.this.outlookTextureStyle.getBorderColor());
                g.drawLine(0, 0, width, 0);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 0, 0, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createLineBorder(this.outlookTextureStyle.getBorderColor()));
        this.contentPane.add((Component)this.outlookContentPane, "North");
        this.contentPane.add((Component)this.fillContentPane, "Center");
        this.shrinkContentPane.add((Component)this.contentPane, "Center");
    }

    public IOutlookTextureStyle getOutlookTextureStyle() {
        return this.outlookTextureStyle;
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, String toolTipText) {
        return this.addShrinkOutlook(title, icon, toolTipText, (Component)null);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, String toolTipText, Component contentPane) {
        return this.addShrinkOutlook(title, icon, icon, toolTipText, null, contentPane);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, String toolTipText, Font titleFont) {
        return this.addShrinkOutlook(title, icon, toolTipText, titleFont, null);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, String toolTipText, Font titleFont, Component contentPane) {
        return this.addShrinkOutlook(title, icon, icon, toolTipText, titleFont, contentPane);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, Icon selectedIcon, String toolTipText) {
        return this.addShrinkOutlook(title, icon, selectedIcon, toolTipText, (Component)null);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, Icon selectedIcon, String toolTipText, Component contentPane) {
        return this.addShrinkOutlook(title, icon, selectedIcon, toolTipText, null, contentPane);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, Icon selectedIcon, String toolTipText, Font titleFont) {
        return this.addShrinkOutlook(title, icon, selectedIcon, toolTipText, titleFont, null);
    }

    public JShrinkOutlook addShrinkOutlook(String title, Icon icon, Icon selectedIcon, String toolTipText, Font titleFont, Component contentPane) {
        JShrinkOutlook shrinkOutlook = new JShrinkOutlook(this);
        shrinkOutlook.setTitle(title);
        shrinkOutlook.setToolTipText(toolTipText);
        shrinkOutlook.setIcon(icon);
        shrinkOutlook.setSelectedIcon(selectedIcon);
        if (titleFont != null) {
            shrinkOutlook.setTitleFont(titleFont);
        }
        shrinkOutlook.setSelected(false);
        if (contentPane != null) {
            shrinkOutlook.setContentPane(contentPane);
        }
        int rowCount = this.tableLayout.getRow().length;
        this.tableLayout.insertRow(rowCount, -2.0);
        this.outlookContentPane.add((Component)shrinkOutlook, "0, " + rowCount);
        this.tableLayoutMap.put(shrinkOutlook, rowCount);
        this.tableLayout.insertRow(++rowCount, -3.0);
        this.outlookContentPane.add((Component)shrinkOutlook.getScrollPane(), "0," + rowCount);
        this.tableLayoutMap.put(shrinkOutlook.getScrollPane(), rowCount);
        return shrinkOutlook;
    }

    protected void updateLayoutConstraint(Component component, boolean selected) {
        Integer rowIndexValue = (Integer)this.tableLayoutMap.get(component);
        int rowIndex = rowIndexValue;
        double constraint = -1.0;
        if (!selected) {
            constraint = -3.0;
        }
        this.tableLayout.setRow(rowIndex, constraint);
    }

    protected void setFillContentPaneVisible(boolean visible) {
        this.contentPane.remove(this.outlookContentPane);
        this.contentPane.remove(this.fillContentPane);
        if (visible) {
            this.contentPane.add((Component)this.outlookContentPane, "North");
            this.contentPane.add((Component)this.fillContentPane, "Center");
        } else {
            this.contentPane.add((Component)this.outlookContentPane, "Center");
        }
    }

    @Override
    protected void shrinkChanged(boolean shrinked) {
        super.shrinkChanged(shrinked);
        for (int i = 0; i < this.outlookContentPane.getComponentCount(); ++i) {
            JShrinkOutlook shrinkOutlook;
            Component contentPane;
            Component component = this.outlookContentPane.getComponent(i);
            if (!(component instanceof JShrinkOutlook) || (contentPane = (shrinkOutlook = (JShrinkOutlook)component).getContentPane()) == null || !(contentPane instanceof JList)) continue;
            JList list = (JList)contentPane;
            list.firePropertyChange("layoutOrientation", true, false);
        }
    }

    public JComponent getFillContentPane() {
        return this.fillContentPane;
    }

    public JComponent getOutlookContentPane() {
        return this.outlookContentPane;
    }

    public void closeAllShrinkOutlooks() {
        for (int i = 0; i < this.outlookContentPane.getComponentCount(); ++i) {
            JShrinkOutlook shrinkOutlook;
            Component component = this.outlookContentPane.getComponent(i);
            if (!(component instanceof JShrinkOutlook) || !(shrinkOutlook = (JShrinkOutlook)component).isSelected()) continue;
            shrinkOutlook.setSelected(false);
        }
    }

    public JShrinkOutlook getSelectedShrinkOutlook() {
        for (int i = 0; i < this.outlookContentPane.getComponentCount(); ++i) {
            JShrinkOutlook shrinkOutlook;
            Component component = this.outlookContentPane.getComponent(i);
            if (!(component instanceof JShrinkOutlook) || !(shrinkOutlook = (JShrinkOutlook)component).isSelected()) continue;
            return shrinkOutlook;
        }
        return null;
    }

    public JShrinkOutlook getShrinkOutlook(int index) {
        Component component = this.outlookContentPane.getComponent(index);
        if (component instanceof JShrinkOutlook) {
            JShrinkOutlook shrinkOutlook = (JShrinkOutlook)component;
            return shrinkOutlook;
        }
        return null;
    }

    public JShrinkOutlook getShrinkOutlook(String title) {
        for (int i = 0; i < this.outlookContentPane.getComponentCount(); ++i) {
            JShrinkOutlook shrinkOutlook;
            Component component = this.outlookContentPane.getComponent(i);
            if (!(component instanceof JShrinkOutlook) || !(shrinkOutlook = (JShrinkOutlook)component).getTitle().equals(title)) continue;
            return shrinkOutlook;
        }
        return null;
    }
}

