/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.util.List;
import twaver.BaseEquipment;
import twaver.TUIManager;
import twaver.base.A.E.b;

public class Grid
extends BaseEquipment {
    private int q = 1;
    private int l = 1;
    private int p = Integer.MIN_VALUE;
    private int m = Integer.MIN_VALUE;
    private int o = 1;
    private int v = 1;
    private Insets r = TUIManager.getInsets("padding");
    private Insets h = TUIManager.getInsets("border");
    private int i = TUIManager.getInt("followerPadding");
    private int j = TUIManager.getInt("followerPaddingTop");
    private int u = TUIManager.getInt("followerPaddingBottom");
    private int n = TUIManager.getInt("followerPaddingLeft");
    private int k = TUIManager.getInt("followerPaddingRight");
    private List s = null;
    private List g = null;
    private boolean t = TUIManager.getBoolean("paintCell");

    public Grid() {
        this.R();
    }

    public Grid(Object id) {
        super(id);
        this.R();
    }

    private void R() {
        this.setSize(100, 80);
    }

    public String getUIClassID() {
        return "GridUI";
    }

    public String getSVGUIClassID() {
        return "GridSVGUI";
    }

    public int getRowCount() {
        return this.q;
    }

    public void setRowCount(int rowCount) {
        int oldValue = this.q;
        this.q = rowCount;
        this.firePropertyChange("rowCount", oldValue, rowCount);
    }

    public int getColumnCount() {
        return this.l;
    }

    public void setColumnCount(int columnCount) {
        int oldValue = this.l;
        this.l = columnCount;
        this.firePropertyChange("columnCount", oldValue, columnCount);
    }

    public int getRowIndex() {
        return this.p;
    }

    public void setRowIndex(int rowIndex) {
        int oldValue = this.p;
        this.p = rowIndex;
        this.firePropertyChange("rowIndex", oldValue, rowIndex);
        this.adjustBounds();
    }

    public int getColumnIndex() {
        return this.m;
    }

    public void setColumnIndex(int columnIndex) {
        int oldValue = this.m;
        this.m = columnIndex;
        this.firePropertyChange("columnIndex", oldValue, columnIndex);
        this.adjustBounds();
    }

    public int getRowSpan() {
        return this.o;
    }

    public void setRowSpan(int rowSpan) {
        int oldValue = this.o;
        this.o = rowSpan;
        this.firePropertyChange("rowSpan", oldValue, rowSpan);
        this.adjustBounds();
    }

    public int getColumnSpan() {
        return this.v;
    }

    public void setColumnSpan(int columnSpan) {
        int oldValue = this.v;
        this.v = columnSpan;
        this.firePropertyChange("columnSpan", oldValue, columnSpan);
        this.adjustBounds();
    }

    public Insets getPadding() {
        return this.r;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            padding = new Insets(0, 0, 0, 0);
        }
        Insets oldValue = this.r;
        this.r = padding;
        this.firePropertyChange("padding", oldValue, padding);
    }

    public Insets getBorder() {
        return this.h;
    }

    public void setBorder(Insets border) {
        if (border == null) {
            border = new Insets(0, 0, 0, 0);
        }
        Insets oldValue = this.h;
        this.h = border;
        this.firePropertyChange("border", oldValue, border);
    }

    public boolean isPaintCell() {
        return this.t;
    }

    public void setPaintCell(boolean paintCell) {
        boolean oldValue = this.t;
        this.t = paintCell;
        this.firePropertyChange("paintCell", oldValue, paintCell);
    }

    public List getColumnPercents() {
        return this.s;
    }

    public void setColumnPercents(List columnPercents) {
        List oldValue = this.s;
        this.s = columnPercents;
        this.firePropertyChange("columnPercents", oldValue, columnPercents);
    }

    public List getRowPercents() {
        return this.g;
    }

    public void setRowPercents(List rowPercents) {
        List oldValue = this.g;
        this.g = rowPercents;
        this.firePropertyChange("rowPercents", oldValue, rowPercents);
    }

    protected void hostPropertyChange(PropertyChangeEvent evt) {
        String propertyName = b.A(evt);
        if (propertyName.equals("rowCount") || propertyName.equals("columnCount") || propertyName.equals("padding") || propertyName.equals("border") || propertyName.equals("columnPercents") || propertyName.equals("rowPercents") || propertyName.equals("size") || propertyName.equals("location")) {
            this.adjustBounds();
        }
    }

    public void adjustBounds() {
        Rectangle rect2;
        if (!(this.getHost() instanceof Grid)) {
            return;
        }
        if (this.p == Integer.MIN_VALUE || this.m == Integer.MIN_VALUE) {
            return;
        }
        Grid grid = (Grid)this.getHost();
        Rectangle rect = grid.getCellRect(this.m, this.p);
        if (rect == null) {
            return;
        }
        if ((this.o != 1 || this.v != 1) && (rect2 = grid.getCellRect(this.m + this.v - 1, this.p + this.o - 1)) != null) {
            rect.add((Rectangle2D)rect2);
        }
        this.A(rect);
        this.setLocation(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY());
        this.setWidthSize((int)((RectangularShape)rect).getWidth());
        this.setHeightSize((int)((RectangularShape)rect).getHeight());
    }

    private void A(Rectangle2D rect) {
        double padding = this.i;
        if (padding != 0.0) {
            rect.setRect(rect.getX() + padding, rect.getY() + padding, rect.getWidth() - 2.0 * padding, rect.getHeight() - 2.0 * padding);
        }
        if ((padding = (double)this.n) != 0.0) {
            rect.setRect(rect.getX() + padding, rect.getY(), rect.getWidth() - padding, rect.getHeight());
        }
        if ((padding = (double)this.k) != 0.0) {
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth() - padding, rect.getHeight());
        }
        if ((padding = (double)this.j) != 0.0) {
            rect.setRect(rect.getX(), rect.getY() + padding, rect.getWidth(), rect.getHeight() - padding);
        }
        if ((padding = (double)this.u) != 0.0) {
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() - padding);
        }
        if (rect.getWidth() < 0.0) {
            rect.setRect(rect.getX() + rect.getWidth(), rect.getY(), -rect.getWidth(), rect.getHeight());
        }
        if (rect.getHeight() < 0.0) {
            rect.setRect(rect.getX(), rect.getY() + rect.getHeight(), rect.getHeight(), -rect.getHeight());
        }
    }

    public Rectangle2D.Double getCellRectangle(int columnIndex, int rowIndex) {
        Point location = this.getLocation();
        int x = location.x + this.h.left;
        int y = location.y + this.h.top;
        int w = this.getWidth() - (this.h.left + this.h.right);
        int h2 = this.getHeight() - (this.h.top + this.h.bottom);
        double left = this.A(w, this.l, columnIndex, this.s);
        double top = this.A(h2, this.q, rowIndex, this.g);
        double rx = (double)(x + this.r.left) + left;
        double ry = (double)(y + this.r.top) + top;
        double rw = this.B(w, columnIndex) - (double)(this.r.left + this.r.right);
        double rh = this.A(h2, rowIndex) - (double)(this.r.top + this.r.bottom);
        return new Rectangle2D.Double(rx, ry, rw, rh);
    }

    public Rectangle2D.Double getCellBounds(int columnIndex, int rowIndex) {
        Point location = this.getLocation();
        int x = location.x + this.h.left;
        int y = location.y + this.h.top;
        int w = this.getWidth() - (this.h.left + this.h.right);
        int h2 = this.getHeight() - (this.h.top + this.h.bottom);
        double left = this.A(w, this.l, columnIndex, this.s);
        double top = this.A(h2, this.q, rowIndex, this.g);
        double rx = (double)x + left;
        double ry = (double)y + top;
        double rw = this.B(w, columnIndex);
        double rh = this.A(h2, rowIndex);
        return new Rectangle2D.Double(rx, ry, rw, rh);
    }

    public Rectangle getCellRect(int columnIndex, int rowIndex) {
        Point location = this.getLocation();
        int x = location.x + this.h.left;
        int y = location.y + this.h.top;
        int w = this.getWidth() - (this.h.left + this.h.right);
        int h2 = this.getHeight() - (this.h.top + this.h.bottom);
        double left = this.A(w, this.l, columnIndex, this.s);
        double top = this.A(h2, this.q, rowIndex, this.g);
        double rx = (double)(x + this.r.left) + left;
        double ry = (double)(y + this.r.top) + top;
        double rw = this.B(w, columnIndex) - (double)(this.r.left + this.r.right);
        double rh = this.A(h2, rowIndex) - (double)(this.r.top + this.r.bottom);
        return new Rectangle((int)rx, (int)ry, (int)rw, (int)rh);
    }

    private double A(int width, int columnCount, int columnIndex, List percents) {
        if (percents != null && !percents.isEmpty()) {
            double leftPercent = 0.0;
            int size = percents.size();
            for (int i2 = 0; i2 < columnIndex && i2 < size; ++i2) {
                double percent = (Double)percents.get(i2);
                leftPercent += percent;
            }
            double allw = (double)width * leftPercent;
            if (columnIndex >= size) {
                if (percents == this.s) {
                    int restCount = this.getColumnCount() - size;
                    double restCellW = this.getRestWidth() / (double)restCount;
                    allw += restCellW * (double)(columnIndex - size);
                } else {
                    int restCount = this.getRowCount() - size;
                    double restCellH = this.getRestHeight() / (double)restCount;
                    allw += restCellH * (double)(columnIndex - size);
                }
            }
            return allw;
        }
        return width * columnIndex / columnCount;
    }

    public double getRestWidth() {
        int size = this.s.size();
        int width = this.getWidth() - (this.h.left + this.h.right);
        double sum = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            sum += Double.parseDouble(this.s.get(i2).toString());
        }
        if (sum >= 1.0) {
            return 0.0;
        }
        double restPercent = 1.0 - sum;
        double w = (double)width * restPercent;
        return w;
    }

    public double getRestHeight() {
        int size = this.g.size();
        double sum = 0.0;
        int height = this.getHeight() - (this.h.top + this.h.bottom);
        for (int i2 = 0; i2 < size; ++i2) {
            sum += Double.parseDouble(this.g.get(i2).toString());
        }
        if (sum >= 1.0) {
            return 0.0;
        }
        double restPercent = 1.0 - sum;
        double w = (double)height * restPercent;
        return w;
    }

    private double B(int width, int columnIndex) {
        if (this.s != null && !this.s.isEmpty()) {
            if (columnIndex < this.s.size()) {
                return (Double)this.s.get(columnIndex) * (double)width;
            }
            double restW = this.getRestWidth();
            int restCount = this.getColumnCount() - this.s.size();
            return restW / (double)restCount;
        }
        return width / this.l;
    }

    private double A(int height, int rowIndex) {
        if (this.g != null && !this.g.isEmpty()) {
            if (rowIndex < this.g.size()) {
                return (Double)this.g.get(rowIndex) * (double)height;
            }
            double restH = this.getRestHeight();
            int restCount = this.getRowCount() - this.g.size();
            return restH / (double)restCount;
        }
        return height / this.q;
    }

    public int getFollowerPadding() {
        return this.i;
    }

    public void setFollowerPadding(int followerPadding) {
        int old = this.i;
        if (old == followerPadding) {
            return;
        }
        this.i = followerPadding;
        this.firePropertyChange("followerPadding", old, followerPadding);
        this.adjustBounds();
    }

    public int getFollowerPaddingTop() {
        return this.j;
    }

    public void setFollowerPaddingTop(int followerPaddingTop) {
        int old = this.j;
        if (old == followerPaddingTop) {
            return;
        }
        this.j = followerPaddingTop;
        this.firePropertyChange("followerPaddingTop", old, followerPaddingTop);
        this.adjustBounds();
    }

    public int getFollowerPaddingBottom() {
        return this.u;
    }

    public void setFollowerPaddingBottom(int followerPaddingBottom) {
        int old = this.u;
        if (old == followerPaddingBottom) {
            return;
        }
        this.u = followerPaddingBottom;
        this.firePropertyChange("followerPaddingBottom", old, followerPaddingBottom);
        this.adjustBounds();
    }

    public int getFollowerPaddingLeft() {
        return this.n;
    }

    public void setFollowerPaddingLeft(int followerPaddingLeft) {
        int old = this.n;
        if (old == followerPaddingLeft) {
            return;
        }
        this.n = followerPaddingLeft;
        this.firePropertyChange("followerPaddingLeft", old, followerPaddingLeft);
        this.adjustBounds();
    }

    public int getFollowerPaddingRight() {
        return this.k;
    }

    public void setFollowerPaddingRight(int followerPaddingRight) {
        int old = this.k;
        if (old == followerPaddingRight) {
            return;
        }
        this.k = followerPaddingRight;
        this.firePropertyChange("followerPaddingRight", old, followerPaddingRight);
        this.adjustBounds();
    }
}

