/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import twaver.AlarmSeverityChangeListener;
import twaver.AlarmSeverityComparator;
import twaver.TWaverUtil;
import twaver.base.A.F.A;

public class AlarmSeverity
implements Serializable,
Comparable {
    public static final String NAME_CRITICAL = "Critical";
    public static final String NAME_MAJOR = "Major";
    public static final String NAME_MINOR = "Minor";
    public static final String NAME_WARNING = "Warning";
    public static final String NAME_INDETERMINATE = "Indeterminate";
    public static final String NAME_CLEARED = "Cleared";
    public static final String NICKNAME_INDETERMINATE = "N";
    public static final String NICKNAME_CRITICAL = "C";
    public static final String NICKNAME_MAJOR = "M";
    public static final String NICKNAME_MINOR = "m";
    public static final String NICKNAME_WARNING = "W";
    public static final String NICKNAME_CLEARED = "R";
    public static final int VALUE_CRITICAL = 500;
    public static final int VALUE_MAJOR = 400;
    public static final int VALUE_MINOR = 300;
    public static final int VALUE_WARNING = 200;
    public static final int VALUE_INDETERMINATE = 100;
    public static final int VALUE_CLEARED = 0;
    public static final Color COLOR_CRITICAL = Color.RED;
    public static final Color COLOR_MAJOR = new Color(255, 160, 0);
    public static final Color COLOR_MINOR = Color.YELLOW;
    public static final Color COLOR_WARNING = Color.CYAN;
    public static final Color COLOR_INDETERMINATE = new Color(200, 0, 255);
    public static final Color COLOR_CLEARED = Color.GREEN;
    public static AlarmSeverity INDETERMINATE;
    public static AlarmSeverity CRITICAL;
    public static AlarmSeverity MAJOR;
    public static AlarmSeverity MINOR;
    public static AlarmSeverity WARNING;
    public static AlarmSeverity CLEARED;
    private static final Map K;
    private static final Map C;
    private static List E;
    private static List H;
    private static AlarmSeverity A;
    private static Comparator B;
    public static final Random random;
    private final int I;
    private final String D;
    private Color F;
    private String J;
    private String G;

    public static synchronized void addAlarmSeverityChangeListener(AlarmSeverityChangeListener l2) {
        H.add(new A(l2));
    }

    private static synchronized void A() {
        Iterator it = H.iterator();
        while (it.hasNext()) {
            AlarmSeverityChangeListener l2 = (AlarmSeverityChangeListener)it.next();
            if (!l2.alarmSeverityChange()) continue;
            it.remove();
        }
    }

    public static void setClearedAlarmSeverity(AlarmSeverity severity) {
        A = severity;
    }

    public static AlarmSeverity getClearedAlarmSeverity() {
        return A;
    }

    private AlarmSeverity(String name, String nickName, int value, Color color, String displayName) {
        if (color == null) {
            throw new NullPointerException("color can't be null.");
        }
        if (name == null) {
            throw new NullPointerException("name can't be null.");
        }
        if (nickName == null) {
            throw new NullPointerException("nickName can't be null.");
        }
        this.F = color;
        this.D = name;
        this.J = nickName;
        this.I = value;
        this.G = displayName;
        switch (this.I) {
            case 500: {
                CRITICAL = this;
                break;
            }
            case 400: {
                MAJOR = this;
                break;
            }
            case 300: {
                MINOR = this;
                break;
            }
            case 200: {
                WARNING = this;
                break;
            }
            case 100: {
                INDETERMINATE = this;
                break;
            }
            case 0: {
                CLEARED = this;
            }
        }
    }

    public static AlarmSeverity getRandomSeverity() {
        return (AlarmSeverity)E.get(random.nextInt(E.size()));
    }

    public static AlarmSeverity getNonClearedRandomSeverity() {
        AlarmSeverity severity;
        while (CLEARED.equals(severity = (AlarmSeverity)E.get(random.nextInt(E.size())))) {
        }
        return severity;
    }

    public static boolean isNonClearedSeverity(AlarmSeverity severity) {
        if (severity == null || A == null) {
            return false;
        }
        return !A.equals(severity);
    }

    public static synchronized AlarmSeverity registerAlarmSeverity(String name, String nickName, int value, Color color, String displayName) {
        if (K.containsKey(name)) {
            throw new IllegalArgumentException("AlarmSeverity with name '" + name + "' already exist");
        }
        if (C.containsKey(TWaverUtil.valueOf(value))) {
            throw new IllegalArgumentException("AlarmSeverity with value '" + value + "' already exist");
        }
        AlarmSeverity severity = new AlarmSeverity(name, nickName, value, color, displayName);
        K.put(severity.getName(), severity);
        C.put(TWaverUtil.valueOf(value), severity);
        AlarmSeverity.setSeverityComparator(B);
        AlarmSeverity.A();
        return severity;
    }

    public static synchronized void clearAlarmSeverity() {
        K.clear();
        C.clear();
        E.clear();
    }

    public static synchronized List getAllSeverity() {
        return new ArrayList(E);
    }

    public static synchronized Iterator iterator() {
        return E.iterator();
    }

    public static synchronized int size() {
        return E.size();
    }

    public static synchronized AlarmSeverity getByName(String name) {
        return (AlarmSeverity)K.get(name);
    }

    public static synchronized AlarmSeverity getByValue(int value) {
        return (AlarmSeverity)C.get(TWaverUtil.valueOf(value));
    }

    public Color getColor() {
        return this.F;
    }

    public String getName() {
        return this.D;
    }

    public String getNickName() {
        return this.J;
    }

    public int getValue() {
        return this.I;
    }

    public void setColor(Color color) {
        this.F = color;
        AlarmSeverity.A();
    }

    public void setDisplayName(String displayName) {
        this.G = displayName;
        AlarmSeverity.A();
    }

    public void setNickName(String nickName) {
        this.J = nickName;
        AlarmSeverity.A();
    }

    public boolean equals(Object object) {
        if (object instanceof AlarmSeverity) {
            return ((AlarmSeverity)object).getValue() == this.I;
        }
        return false;
    }

    public int hashCode() {
        return this.I;
    }

    public String toString() {
        return this.getName();
    }

    public String getDisplayName() {
        if (this.G == null || this.G.trim().equals("")) {
            return TWaverUtil.getString("Alarm.Severity." + this.D);
        }
        return this.G;
    }

    public int compareTo(Object o2) {
        return B.compare(this, o2);
    }

    public static Comparator getSeverityComparator() {
        return B;
    }

    public static void setSeverityComparator(Comparator severityComparator) {
        if (severityComparator == null) {
            throw new IllegalArgumentException("severityComparator should not be null.");
        }
        B = severityComparator;
        TreeMap sortedMap = new TreeMap(severityComparator);
        Iterator it = K.values().iterator();
        while (it.hasNext()) {
            AlarmSeverity s = (AlarmSeverity)it.next();
            sortedMap.put(s, null);
        }
        E = new ArrayList(sortedMap.keySet());
        Collections.reverse(E);
        AlarmSeverity.A();
    }

    static {
        K = new HashMap();
        C = new HashMap();
        E = new ArrayList();
        H = new ArrayList();
        A = null;
        B = AlarmSeverityComparator.ASCENDING;
        random = new Random();
        AlarmSeverity.registerAlarmSeverity(NAME_INDETERMINATE, NICKNAME_INDETERMINATE, 100, COLOR_INDETERMINATE, null);
        AlarmSeverity.registerAlarmSeverity(NAME_CRITICAL, NICKNAME_CRITICAL, 500, COLOR_CRITICAL, null);
        AlarmSeverity.registerAlarmSeverity(NAME_MAJOR, NICKNAME_MAJOR, 400, COLOR_MAJOR, null);
        AlarmSeverity.registerAlarmSeverity(NAME_MINOR, NICKNAME_MINOR, 300, COLOR_MINOR, null);
        AlarmSeverity.registerAlarmSeverity(NAME_WARNING, NICKNAME_WARNING, 200, COLOR_WARNING, null);
        AlarmSeverity.registerAlarmSeverity(NAME_CLEARED, NICKNAME_CLEARED, 0, COLOR_CLEARED, null);
        AlarmSeverity.setClearedAlarmSeverity(CLEARED);
    }
}

