/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import twaver.TWaverUtil;
import twaver.base.A.E.d;

public abstract class AbstractCanvasRenderer
extends JComponent
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    protected static Icon icon = d.A();
    protected JTable table = null;
    protected Object value = null;
    protected boolean isSelected = false;
    protected boolean hasFocus = false;
    protected int row;
    protected int column;
    protected boolean considerDropDownIcon = true;
    protected boolean draw = false;
    protected JList list = null;

    public AbstractCanvasRenderer() {
        this("false");
    }

    public AbstractCanvasRenderer(String considerDropDownIcon) {
        this.considerDropDownIcon = TWaverUtil.stringToBoolean(considerDropDownIcon);
        this.setPreferredSize(new Dimension(30, 20));
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        Stroke oldStroke = g22.getStroke();
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color background = null;
        background = this.isSelected ? (this.list != null ? this.list.getSelectionBackground() : this.table.getSelectionBackground()) : (this.list != null ? this.list.getBackground() : this.table.getBackground());
        g22.setColor(background);
        Dimension size = this.getSize();
        g22.fillRect(0, 0, size.width, size.height);
        int w = size.width - 5;
        if (this.draw) {
            w = w - icon.getIconWidth() + 1;
            icon.paintIcon(this, g22, w + 4, (size.height - icon.getIconHeight()) / 2);
        }
        this.paintContent(g22, w, size.height);
        g22.setStroke(oldStroke);
    }

    public abstract void paintContent(Graphics2D var1, int var2, int var3);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.value = value;
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
        this.row = row;
        this.column = column;
        boolean bl = this.draw = this.considerDropDownIcon && table.isCellEditable(row, column);
        if (hasFocus || isSelected) {
            this.setBorder(focusBorder);
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }

    public boolean isConsiderDropDownIcon() {
        return this.considerDropDownIcon;
    }

    public void setConsiderDropDownIcon(boolean considerDropDownIcon) {
        this.considerDropDownIcon = considerDropDownIcon;
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }
}

