/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.locale.SwingLocale;
import java.awt.Color;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class UIExplorerTableModel
extends AbstractTableModel {
    protected Map rowDatas;
    protected Object[] rowKeys;
    protected String[] columnNames;

    public UIExplorerTableModel(Map rowDatas) {
        this(rowDatas, new String[]{SwingLocale.getString("ui_key"), SwingLocale.getString("ui_value"), SwingLocale.getString("ui_hint")});
    }

    public UIExplorerTableModel(Map rowDatas, String[] columnNames) {
        this.rowDatas = rowDatas;
        this.rowKeys = rowDatas.keySet().toArray();
        this.columnNames = columnNames;
    }

    @Override
    public int getRowCount() {
        return this.rowDatas.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 2;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public synchronized void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.fireTableStructureChanged();
    }

    public Map getRowDatas() {
        return this.rowDatas;
    }

    public synchronized void setRowData(Map rowDatas) {
        this.rowDatas = rowDatas;
        this.rowKeys = rowDatas.keySet().toArray();
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object key = this.rowKeys[row];
        Object value = this.rowDatas.get(key);
        switch (column) {
            case 0: {
                return key;
            }
            case 1: {
                if (value instanceof Color) {
                    Color color = (Color)value;
                    return color.toString().substring(0, color.toString().length() - 1) + ",a=" + color.getAlpha() + "]";
                }
                return value;
            }
            case 2: {
                return value;
            }
        }
        return null;
    }
}

