/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.renderer.list.CellRendererLabel;
import com.nepxion.swing.renderer.list.MultiRadioButtonCellRendererPanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class MultiRadioButtonListCellRenderer
extends MultiRadioButtonCellRendererPanel
implements ListCellRenderer {
    private JList list;
    private int cellHeight = -1;
    private JRadioButton ignoredRadioButton;
    private JRadioButton containedRadioButton;
    private JRadioButton notContainedRadioButton;
    private CellRendererLabel cellLabel;

    public MultiRadioButtonListCellRenderer(JList list) {
        this(list, -1);
    }

    public MultiRadioButtonListCellRenderer(JList list, int cellHeight) {
        this(list, cellHeight, SwingLocale.getString("select_ignored"), SwingLocale.getString("select_contained"), SwingLocale.getString("select_not_contained"));
    }

    public MultiRadioButtonListCellRenderer(JList list, String ignoredText, String containedText, String notContainedText) {
        this(list, -1, ignoredText, containedText, notContainedText);
    }

    public MultiRadioButtonListCellRenderer(JList list, int cellHeight, String ignoredText, String containedText, String notContainedText) {
        super(ignoredText, containedText, notContainedText);
        this.list = list;
        this.cellLabel = this.getLabel();
        this.ignoredRadioButton = this.getIgnoredRadioButton();
        this.containedRadioButton = this.getContainedRadioButton();
        this.notContainedRadioButton = this.getNotContainedRadioButton();
        list.addMouseListener(new RadioButtonListMouseListener());
        this.setCellHeight(cellHeight);
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        if (this.list != null && cellHeight > 0) {
            this.list.setFixedCellHeight(cellHeight);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        IElementNode elementNode = (IElementNode)value;
        switch (elementNode.getSelectedIndex()) {
            case 0: {
                this.ignoredRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.containedRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.notContainedRadioButton.setSelected(true);
                break;
            }
            default: {
                this.ignoredRadioButton.setSelected(true);
            }
        }
        this.cellLabel.setText(elementNode.getText());
        this.cellLabel.setIcon(elementNode.getIcon());
        this.cellLabel.setToolTipText(elementNode.getToolTipText());
        this.cellLabel.setSelected(isSelected);
        this.cellLabel.setFont(list.getFont());
        this.cellLabel.setFocus(hasFocus);
        this.cellLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.cellLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setToolTipText(elementNode.getToolTipText());
        return this;
    }

    private void adaptSelection(int x) {
        int selectedRadioIndex;
        int index = this.list.getSelectedIndex();
        if (index > -1 && (selectedRadioIndex = this.getSelectedRadioIndex(x)) > -1) {
            IElementNode elementNode = (IElementNode)this.list.getModel().getElementAt(index);
            elementNode.setSelectedIndex(selectedRadioIndex);
            Rectangle rectangle = this.list.getCellBounds(index, index);
            this.list.repaint(rectangle);
        }
    }

    public class RadioButtonListMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            MultiRadioButtonListCellRenderer.this.adaptSelection(e.getX());
        }
    }
}

