/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.listener.DisplayAbilityListener;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JClassicMenuButton
extends JClassicButton
implements MouseListener,
PopupMenuListener {
    protected int widthInset = 5;
    protected int heightInset = 5;
    protected JPopupMenu popupMenu;
    protected boolean isShowArrow = true;
    protected boolean isShowArrowRight = true;

    public JClassicMenuButton() {
        this.initComponents();
    }

    public JClassicMenuButton(Action action) {
        super(action);
        this.initComponents();
    }

    public JClassicMenuButton(String text) {
        super(text);
        this.initComponents();
    }

    public JClassicMenuButton(Icon icon) {
        super(icon);
        this.initComponents();
    }

    public JClassicMenuButton(String text, Icon icon) {
        super(text, icon);
        this.initComponents();
    }

    public JClassicMenuButton(String text, String toolTipText) {
        super(text);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JClassicMenuButton(Icon icon, String toolTipText) {
        super(icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JClassicMenuButton(String text, Icon icon, String toolTipText) {
        super(text, icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    private void initComponents() {
        this.addMouseListener(this);
        this.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                JClassicMenuButton.this.adaptDimension();
                JClassicMenuButton.this.removeHierarchyListener(this);
            }
        });
    }

    private void adaptDimension() {
        if (!this.isShowArrow) {
            return;
        }
        if (!this.isShowArrowRight) {
            return;
        }
        Insets insets = this.getMargin();
        if (this.getParent() instanceof JToolBar) {
            if (insets.right < this.widthInset + 5) {
                this.setMargin(new Insets(insets.top, insets.left, insets.bottom, this.widthInset + 5));
            }
        } else if (insets.right < this.widthInset) {
            this.setMargin(new Insets(insets.top, insets.left, insets.bottom, this.widthInset));
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        this.popupMenu.addPopupMenuListener(this);
    }

    public boolean isShowArrow() {
        return this.isShowArrow;
    }

    public void setShowArrow(boolean isShowArrow) {
        this.isShowArrow = isShowArrow;
    }

    public boolean isShowArrowRight() {
        return this.isShowArrowRight;
    }

    public void setShowArrowRight(boolean isShowArrowRight) {
        this.isShowArrowRight = isShowArrowRight;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ButtonModel buttonModel = this.getModel();
        if (!buttonModel.isEnabled()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e) && this.popupMenu != null) {
            this.popupMenu.show(this, 2, this.getSize().height - 2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isShowArrow) {
            ButtonModel buttonModel = this.getModel();
            if (!buttonModel.isEnabled()) {
                g.setColor(UIManager.getColor("controlShadow"));
            }
            if (this.isShowArrowRight) {
                g.drawLine(this.getWidth() - 6 - 5, this.getHeight() / 2 - 1, this.getWidth() - 6 - 1, this.getHeight() / 2 - 1);
                g.drawLine(this.getWidth() - 6 - 4, this.getHeight() / 2, this.getWidth() - 6 - 2, this.getHeight() / 2);
                g.drawLine(this.getWidth() - 6 - 3, this.getHeight() / 2 + 1, this.getWidth() - 6 - 3, this.getHeight() / 2 + 1);
            } else {
                g.drawLine(this.getWidth() / 2 - 1, this.getHeight() - 6 - 3, this.getWidth() / 2 + 3, this.getHeight() - 6 - 3);
                g.drawLine(this.getWidth() / 2, this.getHeight() - 6 - 2, this.getWidth() / 2 + 2, this.getHeight() - 6 - 2);
                g.drawLine(this.getWidth() / 2 + 1, this.getHeight() - 6 - 1, this.getWidth() / 2 + 1, this.getHeight() - 6 - 1);
            }
        }
    }
}

