/*
 * Decompiled with CFR 0.152.
 */
package twaver.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.JLabel;
import twaver.base.A.A.C;
import twaver.base.A.E.M;

public class RotatableLabel
extends JLabel {
    private static final JLabel F = new RotatableLabel(1);
    private static final JLabel D = new RotatableLabel(2);
    private static final JLabel B = new RotatableLabel(3);
    private static final JLabel G = new RotatableLabel(4);
    private boolean E = false;
    private int A = 1;
    private C C;

    public static JLabel getLabelRenderer(int orientation) {
        switch (orientation) {
            case 1: {
                return F;
            }
            case 2: {
                return D;
            }
            case 3: {
                return B;
            }
            case 4: {
                return G;
            }
        }
        return F;
    }

    public RotatableLabel(int orientation) {
        this(orientation, 1);
    }

    public RotatableLabel(int orientation, int thickness) {
        this.A = orientation;
        this.C = new C(thickness);
        this.setBorder(this.C);
        this.setHorizontalAlignment(0);
    }

    public void setBorderVisible(boolean visible) {
        this.C.B(visible);
    }

    public void setBorderStroke(Stroke stroke) {
        this.C.A(stroke);
    }

    public void setBorderColor(Color color) {
        this.C.A(color);
    }

    public void setUnderlineVisible(boolean visible) {
        this.C.A(visible);
    }

    public void setUnderlineStroke(Stroke stroke) {
        this.C.B(stroke);
    }

    public void setUnderlineColor(Color color) {
        this.C.B(color);
    }

    protected void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        if (this.A == 3) {
            g2d.rotate(Math.toRadians(-90.0));
        } else if (this.A == 4) {
            g2d.rotate(Math.toRadians(90.0));
        }
        if (this.A == 4) {
            g2d.translate(0, -this.getWidth());
        } else if (this.A == 3) {
            g2d.translate(-this.getHeight(), 0);
        }
        this.E = true;
        super.paintComponent(g2d);
        this.E = false;
        if (this.A == 3) {
            g2d.rotate(Math.toRadians(90.0));
        } else if (this.A == 4) {
            g2d.rotate(Math.toRadians(-90.0));
        }
        if (this.A == 4) {
            g2d.translate(-this.getWidth(), 0);
        } else if (this.A == 3) {
            g2d.translate(0, -this.getHeight());
        }
    }

    public Insets getInsets(Insets insets) {
        insets = super.getInsets(insets);
        if (this.E && this.isRotated()) {
            if (this.A == 3) {
                int temp = insets.bottom;
                insets.bottom = insets.left;
                insets.left = insets.top;
                insets.top = insets.right;
                insets.right = temp;
            } else if (this.A == 4) {
                int temp = insets.bottom;
                insets.bottom = insets.right;
                insets.right = insets.top;
                insets.top = insets.left;
                insets.left = temp;
            }
        }
        return insets;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.E && this.isRotated()) {
            if (this.A == 3) {
                int temp = insets.bottom;
                insets.bottom = insets.left;
                insets.left = insets.top;
                insets.top = insets.right;
                insets.right = temp;
            } else if (this.A == 4) {
                int temp = insets.bottom;
                insets.bottom = insets.right;
                insets.right = insets.top;
                insets.top = insets.left;
                insets.left = temp;
            }
        }
        return insets;
    }

    public boolean isRotated() {
        return this.A == 3 || this.A == 4;
    }

    public int getWidth() {
        if (this.E && this.isRotated()) {
            return super.getHeight();
        }
        return super.getWidth();
    }

    public int getHeight() {
        if (this.E && this.isRotated()) {
            return super.getWidth();
        }
        return super.getHeight();
    }

    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        if (this.isRotated()) {
            int width = d2.width;
            d2.width = d2.height;
            d2.height = width;
        }
        return d2;
    }

    public Dimension getMinimumSize() {
        Dimension d2 = super.getMinimumSize();
        if (this.isRotated()) {
            int width = d2.width;
            d2.width = d2.height;
            d2.height = width;
        }
        return d2;
    }

    public Dimension getMaximumSize() {
        Dimension d2 = super.getMaximumSize();
        if (this.isRotated()) {
            int width = d2.width;
            d2.width = d2.height + 10;
            d2.height = width + 10;
        }
        return d2;
    }

    public void setText(String text) {
        if (this.A == 2 && text != null) {
            Font font = this.getFont();
            int margin = font.getSize() / 4;
            StringBuffer sb = new StringBuffer(text.length() * 5 + 30);
            sb.append("<html><head><style type='text/css'>");
            sb.append("p { margin-bottom: -" + margin + ";}");
            sb.append("body { margin-bottom: " + margin + ";}");
            sb.append("</style></head><center>");
            for (int i2 = 0; i2 < text.length(); ++i2) {
                char c2 = text.charAt(i2);
                sb.append("<p>" + M.A(c2) + "</p>");
            }
            sb.append("</center></html>");
            super.setText(sb.toString());
        } else {
            super.setText(text);
        }
    }

    public int getOrientation() {
        return this.A;
    }

    static {
        F.setDoubleBuffered(false);
        D.setDoubleBuffered(false);
        B.setDoubleBuffered(false);
        G.setDoubleBuffered(false);
    }
}

