/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.graphics.GraphicsUtilities;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.image.FastBlurFilter;

public class JReflectionPanel
extends JPanel {
    private ReflectionRepaintManager manager;
    private FastBlurFilter blurFilter;
    private JPanel contentPane;
    private Component content;
    private BufferedImage contentBuffer;
    private BufferedImage reflectionBuffer;
    private Graphics2D contentGraphics;
    private Graphics2D reflectionGraphics;
    private GradientPaint alphaMask;
    private int maxReflectHeight = 50;
    private float opacity = 0.5f;
    private boolean initialized = false;

    public JReflectionPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.blurFilter = new FastBlurFilter(1);
        this.buildContentPane();
        this.buildFiller();
        this.installRepaintManager();
        this.initialized = true;
    }

    public void installRepaintManager() {
        if (this.manager == null) {
            this.manager = new ReflectionRepaintManager(RepaintManager.currentManager(this));
        }
        RepaintManager.setCurrentManager((RepaintManager)((Object)this.manager));
    }

    private void buildContentPane() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(false);
        this.add((Component)this.contentPane, "Center");
    }

    private void buildFiller() {
        this.add(Box.createRigidArea(new Dimension(this.maxReflectHeight, this.maxReflectHeight)), "South");
    }

    @Override
    public void paint(Graphics g) {
        this.paintContent(g);
        this.paintReflection(g);
    }

    private void paintReflection(Graphics g) {
        if (this.contentPane.getWidth() <= 0 || this.contentPane.getHeight() <= 0) {
            return;
        }
        int width = this.contentPane.getWidth();
        int height = this.contentPane.getHeight() > this.maxReflectHeight ? this.maxReflectHeight : this.contentPane.getHeight();
        this.createReflection(g, width, height);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.scale(1.0, -1.0);
        g2.drawImage((Image)this.reflectionBuffer, 0, -this.contentPane.getHeight() - height - 5, null);
        g2.dispose();
    }

    private void createReflection(Graphics g, int width, int height) {
        if (this.contentPane.getWidth() <= 0 || this.contentPane.getHeight() <= 0) {
            return;
        }
        if (this.reflectionBuffer == null || this.reflectionBuffer.getWidth() != width || this.reflectionBuffer.getHeight() != height) {
            if (this.reflectionBuffer != null) {
                this.reflectionBuffer.flush();
                this.reflectionGraphics.dispose();
            }
            this.reflectionBuffer = GraphicsUtilities.createCompatibleImage(this.contentBuffer, width, height);
            this.reflectionGraphics = this.reflectionBuffer.createGraphics();
            this.alphaMask = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, height, new Color(0.0f, 0.0f, 0.0f, this.opacity), true);
        }
        int yOffset = this.contentPane.getHeight() - height;
        Rectangle clip = g.getClipBounds();
        Graphics2D g2 = this.reflectionGraphics;
        g2.setClip(clip.x, clip.y - yOffset, clip.width, clip.height);
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(clip.x, clip.y - yOffset, clip.width, clip.height);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.translate(0, -yOffset);
        g2.drawImage((Image)this.contentBuffer, 0, 0, null);
        g2.translate(0, yOffset);
        g2.setComposite(AlphaComposite.DstIn);
        g2.setPaint(this.alphaMask);
        g2.fillRect(clip.x, clip.y - yOffset, clip.width, clip.height);
    }

    private void paintContent(Graphics g) {
        if (this.contentPane.getWidth() <= 0 || this.contentPane.getHeight() <= 0) {
            return;
        }
        if (this.contentBuffer == null || this.contentBuffer.getWidth() != this.contentPane.getWidth() || this.contentBuffer.getHeight() != this.contentPane.getHeight()) {
            if (this.contentBuffer != null) {
                this.contentBuffer.flush();
                this.contentGraphics.dispose();
            }
            this.contentBuffer = GraphicsUtilities.createCompatibleTranslucentImage(this.contentPane.getWidth(), this.contentPane.getHeight());
            this.contentGraphics = this.contentBuffer.createGraphics();
        }
        Graphics2D g2 = this.contentGraphics;
        g2.clipRect(this.contentPane.getX(), this.contentPane.getY(), this.contentPane.getWidth(), this.contentPane.getHeight());
        g2.setComposite(AlphaComposite.Clear);
        Rectangle clip = g.getClipBounds();
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(g.getColor());
        g2.setFont(g.getFont());
        super.paint(g2);
        g.drawImage(this.contentBuffer, 0, 0, null);
    }

    public void setContent(Component content) {
        if (this.content == content) {
            return;
        }
        if (this.content != null) {
            this.contentPane.remove(this.content);
        }
        this.content = content;
        this.contentPane.add(content, "Center");
        ContainerManager.update(this.contentPane);
    }

    public Component getContent() {
        return this.content;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.contentPane.getPreferredSize();
        size.height = size.height + (size.height > this.maxReflectHeight ? this.maxReflectHeight : size.height);
        return size;
    }

    @Override
    public void remove(int index) {
        this.contentPane.remove(index);
    }

    @Override
    public void remove(Component comp) {
        this.contentPane.remove(comp);
    }

    @Override
    public void removeAll() {
        this.contentPane.removeAll();
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.initialized) {
            this.contentPane.setLayout(layout);
        } else {
            super.setLayout(layout);
        }
    }

    private class ReflectionRepaintManager
    extends RepaintManagerX {
        public ReflectionRepaintManager(RepaintManager repaintManager) {
            super(repaintManager);
        }

        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            Rectangle dirtyRegion = this.getDirtyRegion(c);
            int lastDeltaX = c.getX();
            int lastDeltaY = c.getY();
            Container parent = c.getParent();
            while (parent instanceof JComponent) {
                if (!parent.isVisible()) {
                    return;
                }
                if (parent instanceof JReflectionPanel) {
                    x += lastDeltaX;
                    int gap = JReflectionPanel.this.contentPane.getHeight() - h - (y += lastDeltaY);
                    h += 2 * gap + h;
                    lastDeltaY = 0;
                    lastDeltaX = 0;
                    c = (JComponent)parent;
                }
                lastDeltaX += parent.getX();
                lastDeltaY += parent.getY();
                parent = parent.getParent();
            }
            super.addDirtyRegion(c, x, y, w, h);
        }
    }
}

