/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraphBackground;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class TGraphPointBackground
extends TGraphBackground {
    private int pointGap = 10;
    private Color pointColor = Color.gray;

    public TGraphPointBackground(Color color, Color gradientColor) {
        super(color, gradientColor);
    }

    public int getPointGap() {
        return this.pointGap;
    }

    public void setPointGap(int pointGap) {
        this.pointGap = pointGap;
    }

    public Color getPointColor() {
        return this.pointColor;
    }

    public void setPointColor(Color pointColor) {
        this.pointColor = pointColor;
    }

    @Override
    public void paintContent(Graphics2D g, double zoom, Rectangle viewportRect) {
        super.paintContent(g, zoom, viewportRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(this.pointColor);
        int width = viewportRect.width;
        int height = viewportRect.height;
        int xCount = width / this.pointGap;
        int yCount = height / this.pointGap;
        for (int i = 1; i < xCount; ++i) {
            for (int j = 1; j < yCount; ++j) {
                g2d.drawString(".", i * this.pointGap, j * this.pointGap);
            }
        }
    }
}

