/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.gis;

import com.nepxion.cots.twaver.element.TType;
import com.nepxion.cots.twaver.gis.TGisGraphControlBarGenerator;
import com.nepxion.cots.twaver.gis.TGisNavigator;
import com.nepxion.cots.twaver.gis.TGisOverview;
import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TGraphToolBar;
import com.nepxion.swing.listener.VisibilityListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.SwingUtilities;
import twaver.TDataBox;
import twaver.gis.GeographyMap;
import twaver.gis.GisNetworkAdapter;
import twaver.gis.TWaverGisConst;
import twaver.network.TNetwork;

public class TGisGraph
extends TGraph {
    private TGisNavigator gisNavigator;
    private TGisOverview gisOverview;
    private GisNetworkAdapter gisAdapter;

    public TGisGraph() {
        this(new TDataBox());
    }

    public TGisGraph(TDataBox dataBox) {
        this(dataBox, null);
    }

    public TGisGraph(TType type) {
        this(new TDataBox(), type);
    }

    public TGisGraph(TDataBox dataBox, TType type) {
        super(dataBox, type);
        this.initComponents();
    }

    private void initComponents() {
        this.gisAdapter = new GisNetworkAdapter((TNetwork)this);
        this.gisAdapter.installAdapter();
        this.gisNavigator = new TGisNavigator(this);
        GeographyMap map = this.gisAdapter.getMap();
        map.setGroundingColor(TWaverGisConst.GOOGLE_COLOR);
        new TGraphToolBar(this);
        new TGisGraphControlBarGenerator(this);
        this.addHierarchyListener((HierarchyListener)new VisibilityListener(){

            public void visibilityChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TGisGraph.this.gisNavigator.showout(true);
                    }
                });
                TGisGraph.this.removeHierarchyListener((HierarchyListener)((Object)this));
            }
        });
    }

    public TGisOverview getGisOverview() {
        return this.gisOverview;
    }

    public void setOverview(TGisOverview gisOverview) {
        this.gisOverview = gisOverview;
    }

    public TGisNavigator getGisNavigator() {
        return this.gisNavigator;
    }

    public GeographyMap getMap() {
        return this.gisAdapter.getMap();
    }
}

