/*
 * Decompiled with CFR 0.152.
 */
package y.layout.circular;

import java.awt.Rectangle;
import java.util.Comparator;
import y.algo.Trees;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.circular.SingleCycleLayouter;
import y.layout.circular.a;
import y.layout.circular.if;
import y.layout.tree.BalloonLayouter;
import y.util.D;
import y.util.GraphHider;

public class CircularLayouter
extends CanonicMultiStageLayouter {
    public static byte BCC_COMPACT = 0;
    public static byte BCC_ISOLATED = 1;
    public static byte SINGLE_CYCLE = (byte)2;
    private byte jl = BCC_COMPACT;
    private LayoutGraph jn;
    private SingleCycleLayouter jm = new SingleCycleLayouter();
    private a jk = new a();

    public void setMaximalDeviationAngle(int n) {
        this.jk.f(n);
    }

    public int getMaximalDeviationAngle() {
        return (int)this.jk.bv();
    }

    public void setLayoutStyle(byte by) {
        this.jl = by;
    }

    public byte getLayoutStyle() {
        return this.jl;
    }

    public SingleCycleLayouter getSingleCycleLayouter() {
        return this.jm;
    }

    public BalloonLayouter getBalloonLayouter() {
        return this.jk;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        if (layoutGraph.nodeCount() < 2) {
            return;
        }
        this.jn = layoutGraph;
        if (this.getLayoutStyle() == SINGLE_CYCLE) {
            this.jm.doLayoutCore(layoutGraph);
        } else {
            this.bt();
        }
    }

    void bt() {
        Object object;
        Object object2;
        Object object3;
        Node node;
        LayoutTool.resetPaths(this.jn);
        LayoutTool.resetPorts(this.jn);
        if if_ = new if(this.jn);
        if_.a(this.jl);
        if_.g();
        if_.h();
        GraphHider graphHider = new GraphHider(this.jn);
        graphHider.hideAll();
        NodeCursor nodeCursor = if_.nodes();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            object3 = if_.c(node);
            if (((YList)object3).size() > 1) {
                object2 = if_.d(node);
                GraphHider.unhideSubgraph(this.jn, ((EdgeList)object2).edges());
                this.jm.doLayoutCore(this.jn);
                object = this.jn.getBoundingBox();
                if_.setSize(node, ((Rectangle)object).getWidth(), ((Rectangle)object).getHeight());
            } else if (((YList)object3).size() == 1) {
                object2 = ((NodeList)object3).firstNode();
                if_.setSize(node, this.jn.getSize((Node)object2));
                this.jn.setCenter((Node)object2, 0.0, 0.0);
            } else {
                if_.setSize(node, 1.0, 1.0);
            }
            GraphHider.hideSubgraph(this.jn, this.jn.edges());
            nodeCursor.next();
        }
        graphHider.unhideAll();
        if_.f();
        node = this.a(if_);
        Trees.directTree(if_, node);
        object3 = if_.createNodeMap();
        object2 = if_.createEdgeMap();
        this.a(if_, (EdgeMap)object2, (NodeMap)object3);
        this.a((Graph)if_, (EdgeMap)object2);
        this.a(if_, node, (EdgeMap)object2);
        this.jk.a((EdgeMap)object2, (NodeMap)object3);
        this.jk.doLayoutCore(if_);
        this.a(if_, node, (NodeMap)object3);
        object = if_.nodes();
        while (object.ok()) {
            Node node2 = object.node();
            YPoint yPoint = if_.getCenter(node2);
            YDimension yDimension = if_.getSize(node2);
            NodeCursor nodeCursor2 = if_.c(node2).nodes();
            while (nodeCursor2.ok()) {
                Node node3 = nodeCursor2.node();
                this.jn.setCenter(node3, yPoint.getX() + this.jn.getCenterX(node3), yPoint.getY() + this.jn.getCenterY(node3));
                nodeCursor2.next();
            }
            object.next();
        }
    }

    Node a(if if_) {
        int n = -1;
        Node node = null;
        NodeCursor nodeCursor = if_.nodes();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            if (if_.c(node2).size() > n) {
                node = node2;
                n = if_.c(node2).size();
            }
            nodeCursor.next();
        }
        return node;
    }

    void a(Graph graph, EdgeMap edgeMap) {
        _a _a2 = new _a(edgeMap);
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            nodeCursor.node().sortOutEdges(_a2);
            nodeCursor.next();
        }
    }

    void a(if if_, EdgeMap edgeMap, NodeMap nodeMap) {
        Node node;
        int[] nArray = new int[this.jn.nodeCount()];
        NodeCursor nodeCursor = if_.nodes();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            NodeList nodeList = if_.c(node);
            NodeCursor nodeCursor2 = nodeList.nodes();
            while (nodeCursor2.ok()) {
                Node node2 = nodeCursor2.node();
                nArray[node2.index()] = node.index();
                nodeCursor2.next();
            }
            nodeCursor.next();
        }
        node = Trees.getRoot(if_);
        this.a(if_, node, nArray, edgeMap, nodeMap);
    }

    void a(if if_, Node node, EdgeMap edgeMap) {
        if (if_.c(node).size() > 1) {
            Object object;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                double d5 = edgeMap.getDouble(object);
                if (d5 - d2 > d3) {
                    d3 = d5 - d2;
                    d4 = (d2 + d5) / 2.0;
                }
                d2 = d5;
                edgeCursor.next();
            }
            if (360.0 - d2 > d3) {
                d4 = (360.0 + d2) / 2.0;
            }
            this.a(if_, node, d4);
            object = node.outEdges();
            while (object.ok()) {
                Edge edge = object.edge();
                double d6 = edgeMap.getDouble(edge);
                d6 -= d4;
                while (d6 < 0.0) {
                    d6 += 360.0;
                }
                edgeMap.setDouble(edge, d6);
                object.next();
            }
            node.sortOutEdges(new _a(edgeMap));
        }
    }

    void a(if if_, Node node, int[] nArray, EdgeMap edgeMap, NodeMap nodeMap) {
        int n = node.index();
        double d2 = nodeMap.getDouble(node);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            EdgeList edgeList = if_.b(edge);
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            EdgeCursor edgeCursor2 = edgeList.edges();
            while (edgeCursor2.ok()) {
                Edge edge2 = edgeCursor2.edge();
                Node node2 = null;
                Node node3 = null;
                if (nArray[edge2.source().index()] == n) {
                    node2 = edge2.source();
                    node3 = edge2.target();
                } else {
                    node2 = edge2.target();
                    node3 = edge2.source();
                }
                d5 -= this.jn.getCenterX(node2);
                d6 += this.jn.getCenterY(node2);
                d3 -= this.jn.getCenterX(node3);
                d4 += this.jn.getCenterY(node3);
                edgeCursor2.next();
            }
            if (d5 != 0.0 || d6 != 0.0) {
                double d7 = Math.toDegrees(Math.atan2(d6, d5)) - d2;
                while (d7 < 0.0) {
                    d7 += 360.0;
                }
                edgeMap.setDouble(edge, d7);
            }
            if (d3 != 0.0 && d4 != 0.0) {
                double d8 = Math.toDegrees(Math.atan2(d4, d3));
                if (d8 < 0.0) {
                    d8 += 360.0;
                }
                nodeMap.setDouble(edge.target(), d8);
            }
            this.a(if_, edge.target(), nArray, edgeMap, nodeMap);
            edgeCursor.next();
        }
    }

    void a(if if_, Node node, NodeMap nodeMap) {
        YPoint yPoint = if_.getCenter(node);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            YPoint yPoint2 = if_.getCenter(node2);
            double d2 = yPoint2.getX() - yPoint.getX();
            double d3 = yPoint2.getY() - yPoint.getY();
            double d4 = Math.toDegrees(Math.atan2(d3, d2));
            if (nodeMap.get(node2) != null) {
                double d5 = nodeMap.getDouble(node2);
                d4 += d5;
            }
            this.a(if_, node2, d4);
            this.a(if_, node2, nodeMap);
            edgeCursor.next();
        }
    }

    void a(if if_, Node node, double d2) {
        d2 = Math.toRadians(d2);
        NodeList nodeList = if_.c(node);
        if (nodeList.size() <= 1) {
            return;
        }
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            double d3 = this.jn.getCenterX(node2);
            double d4 = this.jn.getCenterY(node2);
            double d5 = Math.cos(d2);
            double d6 = Math.sin(d2);
            double d7 = d3 * d5 - d6 * d4;
            double d8 = d3 * d6 + d5 * d4;
            this.jn.setCenter(node2, d7, d8);
            nodeCursor.next();
        }
    }

    private void a(Graph graph, Object object, EdgeMap edgeMap, NodeMap nodeMap) {
        D.bug(object);
        D.bug("nodes: " + graph.nodeCount());
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            D.bug(node + " inAngle: " + nodeMap.get(node));
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                Node node2 = edge.target();
                D.bug(" >edge to " + node2 + " outAngle: " + edgeMap.get(edge));
                edgeCursor.next();
            }
            nodeCursor.next();
        }
    }

    private void a(Graph graph, Object object) {
        D.bug(object);
        D.bug("nodes: " + graph.nodeCount());
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            D.bug(nodeCursor.node());
            nodeCursor.next();
        }
        D.bug("edges: " + graph.edgeCount());
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            D.bug(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    class _a
    implements Comparator {
        EdgeMap a;

        _a(EdgeMap edgeMap) {
            this.a = edgeMap;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            double d2 = this.a.getDouble(edge) - this.a.getDouble(edge2);
            if (d2 > 0.0) {
                return 1;
            }
            if (d2 < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

