/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tooltip.snap;

import com.nepxion.swing.border.LineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class JSnapToolTip
extends JToolTip {
    private Component snapComponent;
    private Map snapComponentMap;
    private double scaleRatio = 0.3;

    public JSnapToolTip(Component snapComponent) {
        this(snapComponent, 0.3);
    }

    public JSnapToolTip(Component snapComponent, double scaleRatio) {
        this.snapComponent = snapComponent;
        this.scaleRatio = scaleRatio;
        this.setBorder(new LineBorder(Color.gray));
    }

    public JSnapToolTip(Map snapComponentMap) {
        this(snapComponentMap, 0.3);
    }

    public JSnapToolTip(Map snapComponentMap, double scaleRatio) {
        this.snapComponentMap = snapComponentMap;
        this.scaleRatio = scaleRatio;
        this.setBorder(new LineBorder(Color.gray));
    }

    public Component getSnapComponent() {
        return this.snapComponent;
    }

    public void setComponent(Component snapComponent) {
        this.snapComponent = snapComponent;
        this.repaint();
    }

    public Map getSnapComponentMap() {
        return this.snapComponentMap;
    }

    public void setSnapComponentMap(Map snapComponentMap) {
        this.snapComponentMap = snapComponentMap;
        this.repaint();
    }

    public double getScaleRatio() {
        return this.scaleRatio;
    }

    public void setScaleRatio(double scaleRatio) {
        this.scaleRatio = scaleRatio;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.snapComponent != null) {
            return this.calculatePreferredSize(this.snapComponent);
        }
        if (this.snapComponentMap != null) {
            String tipText = this.getTipText();
            Component component = (Component)this.snapComponentMap.get(tipText);
            if (component != null) {
                return this.calculatePreferredSize(component);
            }
            return super.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    private Dimension calculatePreferredSize(Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        return new Dimension((int)((double)width * this.scaleRatio), (int)((double)height * this.scaleRatio));
    }

    private void updateDoubleBuffered(JComponent component, List components) {
        if (component.isDoubleBuffered()) {
            components.add(component);
            component.setDoubleBuffered(false);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component c = component.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            this.updateDoubleBuffered((JComponent)c, components);
        }
    }

    private void resetDoubleBuffered(List components) {
        for (JComponent component : components) {
            component.setDoubleBuffered(true);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        String tipText;
        Component component;
        if (this.snapComponent != null) {
            this.paintComponent(g, this.snapComponent);
        } else if (this.snapComponentMap != null && (component = (Component)this.snapComponentMap.get(tipText = this.getTipText())) != null) {
            this.paintComponent(g, component);
        }
    }

    public void paintComponent(Graphics g, Component component) {
        if (component instanceof JComponent) {
            JComponent c = (JComponent)component;
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform at = g2d.getTransform();
            g2d.transform(AffineTransform.getScaleInstance(this.scaleRatio, this.scaleRatio));
            ArrayList components = new ArrayList();
            this.updateDoubleBuffered(c, components);
            c.paint(g);
            this.resetDoubleBuffered(components);
            g2d.setTransform(at);
        }
    }
}

