/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import twaver.AlarmSeverity;
import twaver.AlarmStateChangeEvent;
import twaver.Element;
import twaver.TWaverConst;
import twaver.TWaverUtil;

public class AlarmState
implements Serializable,
Cloneable,
Comparable {
    private Element H = null;
    private Map C = new HashMap(1);
    private Map D = new HashMap(1);
    private AlarmSeverity K = null;
    private AlarmSeverity L = null;
    private AlarmSeverity A = null;
    private AlarmSeverity E = null;
    private AlarmSeverity G = null;
    private boolean B = false;
    private int F = 0;
    private int J = 0;
    private boolean I = true;

    public AlarmState() {
    }

    public AlarmState(Element element) {
        this.H = element;
    }

    void A(Element element) {
        this.H = element;
        this.A(2);
    }

    private void A(int type) {
        this.E();
        this.G();
        this.A();
        this.F();
        this.C();
        this.B();
        this.D();
        if (this.H != null) {
            AlarmStateChangeEvent event = new AlarmStateChangeEvent(this.H, type);
            this.H.firePropertyChange(event);
        }
    }

    private void E() {
        AlarmSeverity result = null;
        Iterator it = this.D.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            if (!AlarmSeverity.isNonClearedSeverity(severity) || this.getAcknowledgedAlarmCount(severity) == 0) continue;
            if (result == null) {
                result = severity;
                continue;
            }
            result = AlarmSeverity.getSeverityComparator().compare(result, severity) > 0 ? result : severity;
        }
        this.L = result;
    }

    public AlarmSeverity getHighestAcknowledgedAlarmSeverity() {
        return this.L;
    }

    private void G() {
        AlarmSeverity result = null;
        Iterator it = this.C.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            if (!AlarmSeverity.isNonClearedSeverity(severity) || this.getNewAlarmCount(severity) == 0) continue;
            if (result == null) {
                result = severity;
                continue;
            }
            result = AlarmSeverity.getSeverityComparator().compare(result, severity) > 0 ? result : severity;
        }
        this.A = result;
    }

    public AlarmSeverity getHighestNewAlarmSeverity() {
        return this.A;
    }

    private void A() {
        if (this.A == null) {
            this.B = false;
            return;
        }
        Iterator it = this.C.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            if (!AlarmSeverity.isNonClearedSeverity(severity) || this.getNewAlarmCount(severity) == 0 || AlarmSeverity.getSeverityComparator().compare(this.A, severity) <= 0) continue;
            this.B = true;
            return;
        }
        this.B = false;
    }

    public boolean hasLessSevereNewAlarms() {
        return this.B;
    }

    private void F() {
        AlarmSeverity ackResult = this.getHighestAcknowledgedAlarmSeverity();
        AlarmSeverity newResult = this.getHighestNewAlarmSeverity();
        AlarmSeverity propagatedResult = this.K;
        this.E = ackResult;
        if (AlarmSeverity.getSeverityComparator().compare(newResult, this.E) > 0) {
            this.E = newResult;
        }
        if (AlarmSeverity.getSeverityComparator().compare(propagatedResult, this.E) > 0) {
            this.E = propagatedResult;
        }
    }

    public AlarmSeverity getHighestOverallAlarmSeverity() {
        return this.E;
    }

    private void C() {
        AlarmSeverity ackResult = this.getHighestAcknowledgedAlarmSeverity();
        AlarmSeverity newResult = this.getHighestNewAlarmSeverity();
        this.G = ackResult;
        if (AlarmSeverity.getSeverityComparator().compare(newResult, this.G) > 0) {
            this.G = newResult;
        }
    }

    public AlarmSeverity getHighestNativeAlarmSeverity() {
        return this.G;
    }

    private void A(AlarmSeverity severity) {
        if (this.D.get(severity) == null) {
            this.D.put(severity, TWaverConst.INTEGER0);
        }
        if (this.C.get(severity) == null) {
            this.C.put(severity, TWaverConst.INTEGER0);
        }
    }

    public void increaseAcknowledgedAlarm(AlarmSeverity severity, int increment) {
        if (this.D.get(severity) == null) {
            this.A(severity);
        }
        int count = (Integer)this.D.get(severity);
        this.setAcknowledgedAlarmCount(severity, count += increment);
    }

    public void increaseNewAlarm(AlarmSeverity severity, int increment) {
        if (this.C.get(severity) == null) {
            this.A(severity);
        }
        int count = (Integer)this.C.get(severity);
        this.setNewAlarmCount(severity, count += increment);
    }

    public void decreaseAcknowledgedAlarm(AlarmSeverity severity, int decrement) {
        if (this.D.get(severity) == null) {
            this.A(severity);
            return;
        }
        int count = (Integer)this.D.get(severity);
        this.setAcknowledgedAlarmCount(severity, count -= decrement);
    }

    public void decreaseNewAlarm(AlarmSeverity severity, int decrement) {
        if (this.C.get(severity) == null) {
            this.A(severity);
            return;
        }
        int count = (Integer)this.C.get(severity);
        this.setNewAlarmCount(severity, count -= decrement);
    }

    public void acknowledgeAlarm(AlarmSeverity severity) {
        if (this.getNewAlarmCount(severity) > 0) {
            this.decreaseNewAlarm(severity, 1);
            this.increaseAcknowledgedAlarm(severity, 1);
        }
    }

    public void acknowledgeAllAlarms(AlarmSeverity severity) {
        if (this.D.get(severity) == null) {
            this.A(severity);
            return;
        }
        if (this.getNewAlarmCount(severity) > 0) {
            int count = this.getNewAlarmCount(severity);
            this.decreaseNewAlarm(severity, count);
            this.increaseAcknowledgedAlarm(severity, count);
        }
    }

    public void acknowledgeAllAlarms() {
        Iterator it = this.C.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.acknowledgeAllAlarms(severity);
        }
    }

    public void addAcknowledgedAlarm(AlarmSeverity severity) {
        this.increaseAcknowledgedAlarm(severity, 1);
    }

    public void addNewAlarm(AlarmSeverity severity) {
        this.increaseNewAlarm(severity, 1);
    }

    private void B() {
        this.F = 0;
        Iterator it = this.D.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.F += this.getAcknowledgedAlarmCount(severity);
        }
    }

    public int getAcknowledgedAlarmCount() {
        return this.F;
    }

    public int getAcknowledgedAlarmCount(AlarmSeverity severity) {
        if (this.D.get(severity) == null) {
            this.A(severity);
        }
        return (Integer)this.D.get(severity);
    }

    public int getAlarmCount() {
        return this.F + this.J;
    }

    public int getAlarmCount(AlarmSeverity severity) {
        return this.getAcknowledgedAlarmCount(severity) + this.getNewAlarmCount(severity);
    }

    private int D() {
        this.J = 0;
        Iterator it = this.C.keySet().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.J += this.getNewAlarmCount(severity);
        }
        return this.J;
    }

    public int getNewAlarmCount() {
        return this.J;
    }

    public int getNewAlarmCount(AlarmSeverity severity) {
        if (this.C.get(severity) == null) {
            this.A(severity);
        }
        return (Integer)this.C.get(severity);
    }

    public void setNewAlarmCount(AlarmSeverity severity, int count) {
        if (this.C.get(severity) == null) {
            this.A(severity);
        }
        count = count >= 0 ? count : 0;
        this.C.put(severity, TWaverUtil.valueOf(count));
        this.A(2);
    }

    public void removeNewAlarm(AlarmSeverity severity) {
        this.decreaseNewAlarm(severity, 1);
    }

    public void removeAllNewAlarms(AlarmSeverity severity) {
        this.C.remove(severity);
        this.A(2);
    }

    public void removeAllNewAlarms() {
        this.C.clear();
        this.A(2);
    }

    public void setAcknowledgedAlarmCount(AlarmSeverity severity, int count) {
        if (this.D.get(severity) == null) {
            this.A(severity);
        }
        count = count >= 0 ? count : 0;
        this.D.put(severity, TWaverUtil.valueOf(count));
        this.A(2);
    }

    public void removeAcknowledgedAlarm(AlarmSeverity severity) {
        this.decreaseAcknowledgedAlarm(severity, 1);
    }

    public void removeAllAcknowledgedAlarms(AlarmSeverity severity) {
        this.D.remove(severity);
        this.A(2);
    }

    public void removeAllAcknowledgedAlarms() {
        this.D.clear();
        this.A(2);
    }

    public void clear() {
        this.C.clear();
        this.D.clear();
        this.A(2);
    }

    public void copyFrom(AlarmState alarmState) {
        this.C.clear();
        this.D.clear();
        Iterator it = AlarmSeverity.iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.C.put(severity, TWaverUtil.valueOf(alarmState.getNewAlarmCount(severity)));
            this.D.put(severity, TWaverUtil.valueOf(alarmState.getAcknowledgedAlarmCount(severity)));
        }
        this.A(2);
    }

    public AlarmSeverity getPropagateSeverity() {
        return this.K;
    }

    public void setPropagateSeverity(AlarmSeverity propagateSeverity) {
        if (this.K == propagateSeverity) {
            return;
        }
        this.K = propagateSeverity;
        this.A(1);
    }

    public boolean isEmpty() {
        return this.getHighestOverallAlarmSeverity() == null;
    }

    public Object clone() {
        AlarmState state = new AlarmState();
        state.copyFrom(this);
        return state;
    }

    public int compareTo(Object o2) {
        if (o2 instanceof AlarmState) {
            AlarmSeverity severity1 = this.getHighestNativeAlarmSeverity();
            AlarmSeverity severity2 = ((AlarmState)o2).getHighestNativeAlarmSeverity();
            if (severity1 != null && severity2 != null) {
                return severity1.compareTo(severity2);
            }
            if (severity1 != null && severity2 == null) {
                return 1;
            }
            if (severity1 == null && severity2 != null) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isEnablePropagationFromChildren() {
        return this.I;
    }

    public void setEnablePropagationFromChildren(boolean enablePropagationOfChildren) {
        if (this.I == enablePropagationOfChildren) {
            return;
        }
        boolean oldValue = this.I;
        this.I = enablePropagationOfChildren;
        if (this.H != null) {
            this.H.firePropertyChange("enableAlarmPropagationFromChildren", oldValue, this.I);
        }
    }
}

