/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.Grid;
import twaver.Node;
import twaver.ResizableNode;
import twaver.ShapeLink;
import twaver.ShapeNode;
import twaver.TWaverUtil;
import twaver.UndoRedoEvent;
import twaver.base.A.E.D;
import twaver.base.A.E.m;
import twaver.network.CanvasMarker;
import twaver.network.InteractionEvent;
import twaver.network.InteractionListener;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;
import twaver.network.ui.BorderUI;
import twaver.network.ui.EditableBorderUI;
import twaver.network.ui.LinkUI;
import twaver.network.ui.ShapeLinkBorderUI;
import twaver.network.ui.ShapeNodeBorderUI;

public class ResizeInputHandler
extends InputAdapter
implements CanvasMarker {
    private static final int j = 6;
    private TNetwork r = null;
    private ResizableNode m = null;
    private Point Y = null;
    private Rectangle h = null;
    private Rectangle k = null;
    private Rectangle f = null;
    private ShapeNode b = null;
    private ShapeLink X = null;
    private int n = -1;
    private Point2D i = null;
    private Grid d = null;
    private int p = -1;
    private int o = -1;
    private boolean l = false;
    private double e = -1.0;
    private double c = -1.0;
    private double q = 4.0;
    private double a = 15.0;
    private float _ = -1.0f;
    private Rectangle Z = null;
    private InteractionListener g = new InteractionListener(){

        public void interactionPerformed(InteractionEvent event) {
            Element element = ResizeInputHandler.this.r.getDataBox().getLastSelectedElement();
            if (element instanceof Grid) {
                if (event.getType() == 3) {
                    Element bottomElement;
                    ResizeInputHandler.this.Z = null;
                    ResizeInputHandler.this.r.removeCanvasMarker(ResizeInputHandler.this);
                    Point location = ResizeInputHandler.this.r.getLogicalPoint(event.getMouseEvent().getPoint());
                    Grid grid = (Grid)element;
                    List elements = ResizeInputHandler.this.r.getElementsLogicalAt(location);
                    elements.remove(element);
                    int size = elements.size();
                    if (ResizeInputHandler.this._ != -1.0f) {
                        grid.putRenderAlpha(ResizeInputHandler.this._);
                        ResizeInputHandler.this._ = -1.0f;
                    }
                    if (size > 0 && (bottomElement = (Element)elements.get(0)) instanceof Grid) {
                        Grid host = (Grid)bottomElement;
                        if (grid.getHost() != host) {
                            grid.setHost(host);
                        }
                        int cols = host.getColumnCount();
                        int rows = host.getRowCount();
                        for (int i2 = 0; i2 < cols; ++i2) {
                            for (int j2 = 0; j2 < rows; ++j2) {
                                Rectangle rect = ResizeInputHandler.this.A(host, i2, j2);
                                if (!rect.contains(location)) continue;
                                grid.setColumnIndex(i2);
                                grid.setRowIndex(j2);
                                return;
                            }
                        }
                    }
                    grid.setHost(null);
                } else if (event.getType() == 2) {
                    Element bottomElement;
                    if (ResizeInputHandler.this.Z != null) {
                        ResizeInputHandler.this.r.getRenderer().repaintLogicalBounds(ResizeInputHandler.this.Z);
                    }
                    Point location = ResizeInputHandler.this.r.getLogicalPoint(event.getMouseEvent().getPoint());
                    Grid grid = (Grid)element;
                    List elements = ResizeInputHandler.this.r.getElementsLogicalAt(location);
                    elements.remove(element);
                    int size = elements.size();
                    if (size > 0 && (bottomElement = (Element)elements.get(0)) instanceof Grid) {
                        Grid host = (Grid)bottomElement;
                        Insets border = host.getBorder();
                        int cols = host.getColumnCount();
                        int rows = host.getRowCount();
                        for (int i3 = 0; i3 < cols; ++i3) {
                            for (int j3 = 0; j3 < rows; ++j3) {
                                Rectangle rect = ResizeInputHandler.this.A(host, i3, j3);
                                if (!rect.contains(location)) continue;
                                if (ResizeInputHandler.this._ == -1.0f) {
                                    ResizeInputHandler.this._ = grid.getRenderAlpha();
                                    float dragAlpha = ResizeInputHandler.this._ > 0.5f ? 0.5f : ResizeInputHandler.this._;
                                    grid.putRenderAlpha(dragAlpha);
                                }
                                ResizeInputHandler.this.Z = rect;
                                if (border != null) {
                                    if (i3 == 0) {
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.width -= border.left;
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.x += border.left;
                                    }
                                    if (i3 == cols - 1) {
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.width -= border.right;
                                    }
                                    if (j3 == 0) {
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.height -= border.top;
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.y += border.top;
                                    }
                                    if (j3 == rows - 1) {
                                        ((ResizeInputHandler)ResizeInputHandler.this).Z.height -= border.bottom;
                                    }
                                }
                                ResizeInputHandler.this.r.addCanvasMarker(ResizeInputHandler.this);
                                ResizeInputHandler.this.r.getRenderer().repaintLogicalBounds(ResizeInputHandler.this.Z);
                                ResizeInputHandler.this.r.getRenderer().repaint(grid);
                                return;
                            }
                        }
                    }
                    if (ResizeInputHandler.this._ != -1.0f) {
                        grid.putRenderAlpha(ResizeInputHandler.this._);
                        ResizeInputHandler.this._ = -1.0f;
                    }
                    ResizeInputHandler.this.Z = null;
                    ResizeInputHandler.this.r.removeCanvasMarker(ResizeInputHandler.this);
                }
            }
        }
    };

    public void init() {
        super.init();
        this.r.addInteractionListener(this.g);
    }

    public void cleanup() {
        this.r.removeInteractionListener(this.g);
        super.cleanup();
    }

    public ResizeInputHandler(TNetwork network) {
        this.r = network;
    }

    public void mousePressed(MouseEvent e2) {
        if (this.C(e2)) {
            this.b = null;
            this.X = null;
            this.n = -1;
            return;
        }
        if (this.m == null || !twaver.base.A.E.m.G(this.r)) {
            return;
        }
        this.Y = this.r.getLogicalPoint(e2.getPoint());
        this.h = null;
        this.f = null;
    }

    private boolean C(MouseEvent e2) {
        if (!e2.isAltDown() || !SwingUtilities.isLeftMouseButton(e2) || this.r.getSelectionModel().size() != 1) {
            return false;
        }
        Element element = this.r.getLastSelectedElement();
        if (element == null || !element.isSelected()) {
            return false;
        }
        if (!this.r.isResizable(element)) {
            return false;
        }
        Point2D.Double p2 = new Point2D.Double(e2.getX(), e2.getY());
        double zoom = this.r.getZoom();
        p2.x = p2.getX() / zoom;
        p2.y = p2.getY() / zoom;
        if (element instanceof ShapeNode) {
            ShapeNode shape = (ShapeNode)element;
            List points = shape.getPoints();
            int count = points.size();
            if (count > 1) {
                Point2D p1 = (Point2D)points.get(0);
                if (D.A((Point2D)p2, p1) < 6.0) {
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                    shape.removePoint(0);
                    this.r.fireInteractionPerformed(shape, 11, 0, e2);
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                    UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, 0, p1, false);
                    this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                    return true;
                }
                for (int i2 = 1; i2 < count; ++i2) {
                    Point2D p22 = (Point2D)points.get(i2);
                    if (D.A((Point2D)p2, p22) < 6.0) {
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                        shape.removePoint(i2);
                        this.r.fireInteractionPerformed(shape, 11, i2, e2);
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                        UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, i2, p22, false);
                        this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                        return true;
                    }
                    if (D.A(p2.x, p2.y, p1.getX(), p1.getY(), p22.getX(), p22.getY(), 6.0)) {
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                        shape.insertPoint(i2, new Point2D.Double(p2.getX(), p2.getY()));
                        this.r.fireInteractionPerformed(shape, 10, i2, e2);
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                        UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, i2, (Point2D)p2, true);
                        this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                        return true;
                    }
                    p1 = p22;
                }
            }
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            shape.addPoint(p2);
            this.r.fireInteractionPerformed(shape, 10, shape.getPoints().size() - 1, e2);
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
            UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, shape.getPoints().size() - 1, (Point2D)p2, true);
            this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
            return true;
        }
        if (element instanceof ShapeLink) {
            ShapeLink shape = (ShapeLink)element;
            List points = shape.getPoints();
            int count = points.size();
            if (count > 0) {
                Point2D p1 = (Point2D)points.get(0);
                if (D.A((Point2D)p2, p1) < 6.0) {
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                    shape.removePoint(0);
                    this.r.fireInteractionPerformed(shape, 11, 0, e2);
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                    UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, 0, p1, false);
                    this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                    return true;
                }
                LinkUI ui = (LinkUI)this.r.getElementUI(shape);
                Point from = ui.getFromPoint();
                if (D.A(p2.x, p2.y, from.getX(), from.getY(), p1.getX(), p1.getY(), 6.0)) {
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                    shape.insertPoint(0, p2);
                    this.r.fireInteractionPerformed(shape, 10, 0, e2);
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                    UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, 0, (Point2D)p2, true);
                    this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                    return true;
                }
                for (int i3 = 1; i3 < count; ++i3) {
                    Point2D p23 = (Point2D)points.get(i3);
                    if (D.A((Point2D)p2, p23) < 6.0) {
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                        shape.removePoint(i3);
                        this.r.fireInteractionPerformed(shape, 11, i3, e2);
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                        UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, i3, p23, false);
                        this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                        return true;
                    }
                    if (D.A(p2.x, p2.y, p1.getX(), p1.getY(), p23.getX(), p23.getY(), 6.0)) {
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                        shape.insertPoint(i3, p2);
                        this.r.fireInteractionPerformed(shape, 10, i3, e2);
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                        UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, i3, (Point2D)p2, true);
                        this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                        return true;
                    }
                    p1 = p23;
                }
            }
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            shape.addPoint(p2);
            this.r.fireInteractionPerformed(shape, 10, shape.getPoints().size() - 1, e2);
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
            UndoRedoEvent undoRedoEvent = new UndoRedoEvent(shape, shape.getPoints().size() - 1, (Point2D)p2, true);
            this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
            return true;
        }
        return false;
    }

    public void mouseReleased(final MouseEvent e2) {
        if (twaver.base.A.E.m.G(this.r)) {
            if (this.k != null && this.d != null && (this.c != -1.0 || this.e != -1.0)) {
                this.r.removeCanvasMarker(this);
                Rectangle2D.Double rectangle = this.getGridContent(this.d);
                if (this.p != -1) {
                    int rowCount = this.d.getRowCount();
                    ArrayList<Double> rowHList = new ArrayList<Double>();
                    ArrayList<Double> rowList = new ArrayList<Double>(rowCount);
                    List rowPercents = this.d.getRowPercents();
                    if (rowPercents == null) {
                        for (int i2 = 0; i2 < rowCount; ++i2) {
                            rowHList.add(new Double(rectangle.getHeight() / (double)rowCount));
                        }
                    } else {
                        int size = rowPercents.size();
                        double restH = this.d.getRestHeight();
                        double restCount = rowCount - size;
                        for (int i3 = 0; i3 < rowCount; ++i3) {
                            if (i3 >= size) {
                                rowHList.add(new Double(restH / restCount));
                                continue;
                            }
                            rowHList.add(new Double(Double.parseDouble(rowPercents.get(i3).toString()) * rectangle.getHeight()));
                        }
                    }
                    Rectangle2D.Double oldRect = this.getRowRectangle(this.d, this.p);
                    double gap = oldRect.getY() + this.q / 2.0 - this.c;
                    this.d.setHeightSize((int)((double)this.d.getHeight() - gap));
                    rectangle = this.getGridContent(this.d);
                    for (int i4 = 0; i4 < rowCount; ++i4) {
                        double value = (Double)rowHList.get(i4) / rectangle.getHeight();
                        if (i4 == this.p) {
                            value = ((double)((int)((Double)rowHList.get(i4)).doubleValue()) - gap) / rectangle.getHeight();
                        }
                        rowList.add(new Double(value));
                    }
                    this.d.setRowPercents(rowList);
                } else {
                    int i5;
                    int colCount = this.d.getColumnCount();
                    ArrayList<Double> colHList = new ArrayList<Double>();
                    ArrayList<Double> colList = new ArrayList<Double>(colCount);
                    List columnPercents = this.d.getColumnPercents();
                    if (columnPercents == null) {
                        for (int i6 = 0; i6 < colCount; ++i6) {
                            colHList.add(new Double(rectangle.getWidth() * 1.0 / (double)colCount));
                        }
                    } else {
                        int size = columnPercents.size();
                        int restCount = colCount - size;
                        double restW = this.d.getRestWidth();
                        for (i5 = 0; i5 < colCount; ++i5) {
                            if (i5 >= size) {
                                colHList.add(new Double(restW / (double)restCount));
                                continue;
                            }
                            colHList.add(new Double(Double.parseDouble(columnPercents.get(i5).toString()) * rectangle.getWidth()));
                        }
                    }
                    Rectangle2D.Double oldRect = this.getColRectangle(this.d, this.o);
                    double gap = oldRect.getX() + this.q / 2.0 - this.e;
                    int newW = (int)((double)this.d.getWidth() - gap);
                    this.d.setWidthSize(newW);
                    rectangle = this.getGridContent(this.d);
                    for (i5 = 0; i5 < colCount; ++i5) {
                        double value = (Double)colHList.get(i5) / rectangle.getWidth();
                        if (i5 == this.o) {
                            value = ((double)((int)((Double)colHList.get(i5)).doubleValue()) - gap) / rectangle.getWidth();
                        }
                        colList.add(new Double(value));
                    }
                    this.d.setColumnPercents(colList);
                }
                this.setHostAttribute(this.d);
                this.h = null;
            } else if (this.h != null) {
                if (this.d == null) {
                    this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                    if (!this.r.isAnimateElementResize()) {
                        this.m.setLocation(this.h.x, this.h.y);
                        this.m.setSize(this.h.width, this.h.height);
                        this.r.fireInteractionPerformed(this.m, 7, e2);
                        this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                        UndoRedoEvent undoRedoEvent = new UndoRedoEvent(this.m, this.f, this.h);
                        this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                    } else {
                        final ResizableNode copyResizableNode = this.m;
                        final Rectangle copyResizingRect = this.h;
                        final Rectangle copyOriginalRect = this.f;
                        HashMap<ResizableNode, Rectangle> map = new HashMap<ResizableNode, Rectangle>();
                        map.put(copyResizableNode, copyResizingRect);
                        Runnable r = new Runnable(){

                            public void run() {
                                ResizeInputHandler.this.r.fireInteractionPerformed(copyResizableNode, 7, e2);
                                ResizeInputHandler.this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                                UndoRedoEvent undoRedoEvent = new UndoRedoEvent(copyResizableNode, copyOriginalRect, copyResizingRect);
                                ResizeInputHandler.this.r.getDataBox().getUndoRedoManager().addEvent(undoRedoEvent);
                            }
                        };
                        TWaverUtil.animateResize(map, r, -1, -1);
                    }
                }
                this.r.removeCanvasMarker(this);
                this.r.getRenderer().repaintLogicalBounds(this.f);
                this.r.getRenderer().repaint(this.m);
            } else if (this.b != null && this.n >= 0) {
                Point point = this.r.getLogicalPoint(e2.getPoint());
                this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                this.b.setPoint(this.n, new Point2D.Double(point.getX(), point.getY()));
                this.r.fireInteractionPerformed(this.b, 9, this.n, e2);
                this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                UndoRedoEvent event = new UndoRedoEvent(this.b, this.n, this.i, (Point2D)point);
                this.r.getDataBox().getUndoRedoManager().addEvent(event);
            } else if (this.X != null && this.n >= 0) {
                Point point = this.r.getLogicalPoint(e2.getPoint());
                this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                this.X.setPoint(this.n, new Point2D.Double(point.getX(), point.getY()));
                this.r.fireInteractionPerformed(this.X, 9, this.n, e2);
                this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                UndoRedoEvent event = new UndoRedoEvent(this.X, this.n, this.i, (Point2D)point);
                this.r.getDataBox().getUndoRedoManager().addEvent(event);
            }
            this.r.adjustCanvasSize();
        }
        this.Y = null;
        this.h = null;
        this.f = null;
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 27 && this.h != null) {
            this.r.removeCanvasMarker(this);
            this.r.fireInteractionPerformed(this.m, 13, null);
            this.r.getCanvas().setCursor(this.r.getDefaultCursor());
            this.r.getRenderer().repaintLogicalBounds(this.h);
            this.Y = null;
            this.h = null;
            this.f = null;
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (!twaver.base.A.E.m.G(this.r)) {
            return;
        }
        if (this.m != null) {
            if (this.k != null && this.d != null) {
                Point point = this.r.getLogicalPoint(e2.getPoint());
                if (this.l) {
                    Rectangle repaintRect;
                    if (this.k != null) {
                        repaintRect = new Rectangle(this.k);
                        repaintRect.grow(2, 2);
                        this.r.getRenderer().repaintLogicalBounds(repaintRect);
                    }
                    if (this.p != -1) {
                        Rectangle2D.Double rect = this.getRowRectangle(this.d, this.p - 1);
                        double minY = rect.getY() + this.a;
                        this.k = new Rectangle((int)rect.x, (int)rect.getCenterY(), (int)rect.width, (int)(point.getY() - rect.getCenterY()));
                        this.c = point.getY();
                        if (rect != null && point.getY() < minY) {
                            this.k = new Rectangle((int)rect.x, (int)rect.getCenterY(), (int)rect.width, (int)(minY - rect.getCenterY()));
                            this.c = minY;
                        }
                        repaintRect = new Rectangle(this.k);
                    } else {
                        Rectangle2D.Double rect = this.getColRectangle(this.d, this.o - 1);
                        double minX = rect.getX() + this.a;
                        this.k = new Rectangle((int)rect.getCenterX(), (int)rect.getY(), (int)(point.getX() - rect.getCenterX()), (int)rect.height);
                        this.e = point.getX();
                        if (rect != null && point.getX() < minX) {
                            this.k = new Rectangle((int)rect.getCenterX(), (int)rect.getY(), (int)(minX - rect.getCenterX()), (int)rect.height);
                            this.e = minX;
                        }
                        repaintRect = new Rectangle(this.k);
                    }
                    repaintRect.grow(2, 2);
                    this.r.getRenderer().repaintLogicalBounds(repaintRect);
                    this.r.addCanvasMarker(this);
                } else {
                    this.k = null;
                    this.r.removeCanvasMarker(this);
                }
            } else {
                BorderUI borderUI = this.r.getRenderer().getElementUI(this.m).getBorder();
                if (!(borderUI instanceof EditableBorderUI)) {
                    return;
                }
                Cursor cursor = this.r.getCanvas().getCursor();
                if (((EditableBorderUI)borderUI).getNewBounds(cursor, this.Y) == null) {
                    return;
                }
                if (this.h == null) {
                    this.r.addCanvasMarker(this);
                    this.f = this.r.getElementBounds(this.m);
                } else {
                    this.r.getRenderer().repaintLogicalBounds(this.h);
                }
                this.Y = this.r.getLogicalPoint(e2.getPoint());
                this.h = ((EditableBorderUI)borderUI).getNewBounds(cursor, this.Y);
                this.r.getRenderer().repaintLogicalBounds(this.h);
                this.r.fireInteractionPerformed(this.m, 6, e2);
            }
        } else if (this.b != null && this.n >= 0) {
            Point point = this.r.getLogicalPoint(e2.getPoint());
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            this.b.setPoint(this.n, new Point2D.Double(point.getX(), point.getY()));
            this.r.fireInteractionPerformed(this.b, 8, this.n, e2);
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
        } else if (this.X != null && this.n >= 0) {
            Point point = this.r.getLogicalPoint(e2.getPoint());
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            this.X.setPoint(this.n, new Point2D.Double(point.getX(), point.getY()));
            this.r.fireInteractionPerformed(this.X, 8, this.n, e2);
            this.r.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
        }
    }

    public void mouseMoved(MouseEvent e2) {
        this.m = this.B(e2.getPoint());
        this.e = -1.0;
        this.c = -1.0;
        if (this.m != null) {
            twaver.base.A.E.m.A(this.r, true);
            this.k = null;
            this.r.removeCanvasMarker(this);
            if (this.d != null) {
                int i2;
                this.p = -1;
                this.o = -1;
                this.l = false;
                twaver.base.A.E.m.A(this.r, false);
                this.r.getCanvas().setCursor(this.r.getDefaultCursor());
                Point point = this.r.getLogicalPoint(e2.getPoint());
                int rows = this.d.getRowCount();
                int cols = this.d.getColumnCount();
                for (i2 = 0; i2 < rows; ++i2) {
                    Rectangle2D.Double rowRect = this.getRowRectangle(this.d, i2);
                    if (!rowRect.contains(point)) continue;
                    this.p = i2;
                    this.l = true;
                    Rectangle2D.Double rect = this.getRowRectangle(this.d, this.p - 1);
                    double minSize = rect.getY() + this.a;
                    this.r.getCanvas().setCursor(Cursor.getPredefinedCursor(8));
                    twaver.base.A.E.m.A(this.r, true);
                    this.r.addCanvasMarker(this);
                    this.k = new Rectangle((int)rect.x, (int)rect.getCenterY(), (int)rect.width, (int)(rowRect.getCenterY() - rect.getCenterY()));
                    if (rect != null && point.getY() < minSize) {
                        this.k = new Rectangle((int)rect.x, (int)rect.getCenterY(), (int)rect.width, (int)(minSize - rect.getCenterY()));
                    }
                    return;
                }
                for (i2 = 0; i2 < cols; ++i2) {
                    Rectangle2D.Double colRect = this.getColRectangle(this.d, i2);
                    if (!colRect.contains(point)) continue;
                    this.o = i2;
                    this.l = true;
                    Rectangle2D.Double rect = this.getColRectangle(this.d, this.o - 1);
                    double minSize = rect.getX() + this.a;
                    this.r.getCanvas().setCursor(Cursor.getPredefinedCursor(10));
                    this.r.addCanvasMarker(this);
                    this.k = new Rectangle((int)rect.getCenterX(), (int)rect.getY(), (int)(colRect.getCenterX() - rect.getCenterX()), (int)rect.height);
                    if (rect != null && point.getX() < minSize) {
                        this.k = new Rectangle((int)rect.getCenterX(), (int)rect.getY(), (int)(minSize - rect.getCenterX()), (int)rect.height);
                    }
                    twaver.base.A.E.m.A(this.r, true);
                    return;
                }
            }
            return;
        }
        twaver.base.A.E.m.A(this.r, false);
        this.r.getCanvas().setCursor(this.r.getDefaultCursor());
        this.b = this.C(e2.getPoint());
        if (this.b != null) {
            twaver.base.A.E.m.A(this.r, true);
            return;
        }
        twaver.base.A.E.m.A(this.r, false);
        this.r.getCanvas().setCursor(this.r.getDefaultCursor());
        this.X = this.D(e2.getPoint());
        if (this.X == null) {
            twaver.base.A.E.m.A(this.r, false);
            this.r.getCanvas().setCursor(this.r.getDefaultCursor());
        } else {
            twaver.base.A.E.m.A(this.r, true);
        }
    }

    public void setHostAttribute(Grid grid) {
        int rowIndex = grid.getRowIndex();
        int colIndex = grid.getColumnIndex();
        if (rowIndex == Integer.MIN_VALUE || colIndex == Integer.MIN_VALUE) {
            return;
        }
        Node hostNode = grid.getHost();
        if (hostNode != null && hostNode instanceof Grid) {
            Grid host = (Grid)hostNode;
            Rectangle2D.Double rectangle = this.getGridContent(host);
            if (this.p != -1) {
                int rowCount = host.getRowCount();
                ArrayList<Double> rowList = new ArrayList<Double>(rowCount);
                ArrayList<Double> rowHList = new ArrayList<Double>();
                List rowPercents = host.getRowPercents();
                if (rowPercents == null) {
                    for (int i2 = 0; i2 < rowCount; ++i2) {
                        rowHList.add(new Double(rectangle.getHeight() / (double)rowCount));
                    }
                } else {
                    int size = rowPercents.size();
                    int restCount = rowCount - size;
                    double restH = host.getRestHeight();
                    for (int i3 = 0; i3 < rowCount; ++i3) {
                        if (i3 >= size) {
                            rowHList.add(new Double(restH / (double)restCount));
                            continue;
                        }
                        Double rh = (Double)rowPercents.get(i3);
                        rowHList.add(new Double(rh * rectangle.getHeight()));
                    }
                }
                Rectangle2D.Double oldRectangle = this.getRowRectangle(host, rowIndex);
                double gap = oldRectangle.getY() + this.q / 2.0 - (grid.getY() + (double)grid.getHeight());
                host.setHeightSize((int)((double)host.getHeight() - gap));
                rectangle = this.getGridContent(host);
                for (int i4 = 0; i4 < rowCount; ++i4) {
                    double value = (Double)rowHList.get(i4) / rectangle.getHeight();
                    if (i4 == rowIndex) {
                        value = ((double)((int)((Double)rowHList.get(i4)).doubleValue()) - gap) / rectangle.getHeight();
                    }
                    rowList.add(new Double(value));
                }
                host.setRowPercents(rowList);
            } else {
                int colCount = host.getColumnCount();
                ArrayList<Double> colList = new ArrayList<Double>(colCount);
                ArrayList<Double> colHList = new ArrayList<Double>();
                List columnPercents = host.getColumnPercents();
                if (columnPercents == null) {
                    for (int i5 = 0; i5 < colCount; ++i5) {
                        colHList.add(new Double(rectangle.getWidth() / (double)colCount));
                    }
                } else {
                    int size = columnPercents.size();
                    int restCount = colCount - size;
                    double restW = host.getRestWidth();
                    for (int i6 = 0; i6 < colCount; ++i6) {
                        if (i6 >= size) {
                            colHList.add(new Double(restW / (double)restCount));
                            continue;
                        }
                        Double ch = (Double)columnPercents.get(i6);
                        colHList.add(new Double(ch * rectangle.getWidth()));
                    }
                }
                Rectangle2D.Double oldRectangle = this.getColRectangle(host, colIndex);
                double gap = oldRectangle.getX() + this.q / 2.0 - (grid.getX() + (double)grid.getWidth());
                host.setWidthSize((int)((double)host.getWidth() - gap));
                rectangle = this.getGridContent(host);
                for (int i7 = 0; i7 < colCount; ++i7) {
                    double value = (Double)colHList.get(i7) / rectangle.getWidth();
                    if (i7 == colIndex) {
                        value = ((double)((int)((Double)colHList.get(i7)).doubleValue()) - gap) / rectangle.getWidth();
                    }
                    colList.add(new Double(value));
                }
                host.setColumnPercents(colList);
            }
            this.setHostAttribute(host);
        }
    }

    public Rectangle2D.Double getGridContent(Grid grid) {
        Rectangle rectangle = grid.getBounds();
        Rectangle2D.Double r2d = new Rectangle2D.Double();
        Insets border = grid.getBorder();
        if (border == null) {
            r2d = new Rectangle2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            return r2d;
        }
        r2d.x = rectangle.x + border.left;
        r2d.y = rectangle.y + border.top;
        r2d.height = rectangle.getHeight() - (double)border.top - (double)border.bottom;
        r2d.width = rectangle.getWidth() - (double)border.left - (double)border.right;
        return r2d;
    }

    public Rectangle2D.Double getColRectangle(Grid grid, int colIndex) {
        double x;
        List colPercents = grid.getColumnPercents();
        Rectangle2D.Double r2d = this.getGridContent(grid);
        double y = r2d.getY();
        double w = this.q;
        double h2 = r2d.getHeight();
        if (colPercents == null) {
            int cols = grid.getColumnCount();
            double cellW = r2d.getWidth() / (double)cols;
            x = cellW * (double)(colIndex + 1) - w / 2.0 + r2d.getX();
        } else {
            int size = colPercents.size();
            if (colIndex >= size) {
                double allPercent = 0.0;
                for (int i2 = 0; i2 < size; ++i2) {
                    allPercent += Double.parseDouble(colPercents.get(i2).toString());
                }
                double restW = grid.getRestWidth();
                int restCount = grid.getColumnCount() - size;
                double restCellW = restW / (double)restCount;
                x = r2d.getX() - w / 2.0 + allPercent * r2d.getWidth() + restCellW * (double)(colIndex - restCount + 1);
            } else {
                double allPercent = 0.0;
                for (int i3 = 0; i3 <= colIndex; ++i3) {
                    allPercent += Double.parseDouble(colPercents.get(i3).toString());
                }
                x = r2d.getX() - w / 2.0 + allPercent * r2d.getWidth();
            }
        }
        Rectangle2D.Double colRectangle = new Rectangle2D.Double(x, y, w, h2);
        return colRectangle;
    }

    public Rectangle2D.Double getRowRectangle(Grid grid, int rowIndex) {
        double y;
        List rowPercents = grid.getRowPercents();
        Rectangle2D.Double r2d = this.getGridContent(grid);
        double x = r2d.getX();
        double w = r2d.getWidth();
        double h2 = this.q;
        if (rowPercents == null) {
            int rows = grid.getRowCount();
            double cellH = r2d.getHeight() / (double)rows;
            y = cellH * (double)(rowIndex + 1) - h2 / 2.0 + r2d.getY();
        } else {
            int size = rowPercents.size();
            if (rowIndex >= size) {
                double allPercent = 0.0;
                for (int i2 = 0; i2 < size; ++i2) {
                    allPercent += Double.parseDouble(rowPercents.get(i2).toString());
                }
                double restH = grid.getRestHeight();
                int restCount = grid.getRowCount() - size;
                double restCellH = restH / (double)restCount;
                y = r2d.getY() - h2 / 2.0 + allPercent * r2d.getHeight() + restCellH * (double)(rowIndex - size + 1);
            } else {
                double allPercent = 0.0;
                for (int i3 = 0; i3 <= rowIndex; ++i3) {
                    allPercent += Double.parseDouble(rowPercents.get(i3).toString());
                }
                y = r2d.getY() - h2 / 2.0 + allPercent * r2d.getHeight();
            }
        }
        Rectangle2D.Double rowRectangle = new Rectangle2D.Double(x, y, w, h2);
        return rowRectangle;
    }

    private ResizableNode B(Point point) {
        point = this.r.getLogicalPoint(point);
        if (this.r.getSelectionModel().size() != 1) {
            return null;
        }
        Element selectedElement = this.r.getLastSelectedElement();
        BorderUI borderUI = this.r.getRenderer().getElementUI(selectedElement).getBorder();
        this.d = null;
        this.k = null;
        if (selectedElement instanceof ResizableNode && borderUI instanceof EditableBorderUI && this.r.isResizable(selectedElement) && this.r.isVisible(selectedElement)) {
            EditableBorderUI editableBorderUI = (EditableBorderUI)borderUI;
            Cursor cursor = editableBorderUI.getCursor(point);
            if (cursor != null) {
                this.r.getCanvas().setCursor(cursor);
                return (ResizableNode)selectedElement;
            }
            if (selectedElement instanceof Grid) {
                if (((Grid)selectedElement).getRowCount() <= 1 && ((Grid)selectedElement).getColumnCount() <= 1) {
                    return null;
                }
                this.d = (Grid)selectedElement;
                return (ResizableNode)selectedElement;
            }
        }
        return null;
    }

    private ShapeNode C(Point point) {
        point = this.r.getLogicalPoint(point);
        if (this.r.getSelectionModel().size() != 1) {
            return null;
        }
        Element selectedElement = this.r.getLastSelectedElement();
        BorderUI borderUI = this.r.getRenderer().getElementUI(selectedElement).getBorder();
        if (borderUI instanceof ShapeNodeBorderUI && selectedElement instanceof ShapeNode && this.r.isResizable(selectedElement) && this.r.isVisible(selectedElement)) {
            ShapeNodeBorderUI shapeBorderUI = (ShapeNodeBorderUI)borderUI;
            this.n = shapeBorderUI.getPointIndex(point);
            if (this.n >= 0) {
                this.i = ((ShapeNode)selectedElement).getPoint(this.n);
                this.r.getCanvas().setCursor(Cursor.getPredefinedCursor(12));
                return (ShapeNode)selectedElement;
            }
        }
        return null;
    }

    private ShapeLink D(Point point) {
        point = this.r.getLogicalPoint(point);
        if (this.r.getSelectionModel().size() != 1) {
            return null;
        }
        Element selectedElement = this.r.getLastSelectedElement();
        BorderUI borderUI = this.r.getRenderer().getElementUI(selectedElement).getBorder();
        if (borderUI instanceof ShapeLinkBorderUI && selectedElement instanceof ShapeLink && this.r.isResizable(selectedElement) && this.r.isVisible(selectedElement)) {
            ShapeLinkBorderUI shapeBorderUI = (ShapeLinkBorderUI)borderUI;
            this.n = shapeBorderUI.getPointIndex(point);
            if (this.n >= 0) {
                this.i = ((ShapeLink)selectedElement).getPoint(this.n);
                this.r.getCanvas().setCursor(Cursor.getPredefinedCursor(12));
                return (ShapeLink)selectedElement;
            }
        }
        return null;
    }

    private Rectangle A(Grid grid, int i2, int j2) {
        int cols = grid.getColumnCount();
        int rows = grid.getRowCount();
        Rectangle rect = grid.getCellRect(i2, j2);
        Insets border = grid.getBorder();
        Insets padding = grid.getPadding();
        if (padding != null) {
            rect.width = rect.width + padding.left + padding.right;
            rect.height = rect.height + padding.top + padding.bottom;
            rect.x -= padding.left;
            rect.y -= padding.top;
        }
        if (border != null) {
            if (i2 == 0) {
                rect.width += border.left;
                rect.x -= border.left;
            }
            if (i2 == cols - 1) {
                rect.width += border.right;
            }
            if (j2 == 0) {
                rect.height += border.top;
                rect.y -= border.top;
            }
            if (j2 == rows - 1) {
                rect.height += border.bottom;
            }
        }
        return rect;
    }

    public void mark(Graphics2D g2) {
        if (this.h != null) {
            TWaverUtil.drawDashShape(g2, this.h);
        } else if (this.k != null) {
            TWaverUtil.drawDashShape(g2, this.k);
        } else if (this.Z != null) {
            TWaverUtil.drawDashShape(g2, this.Z);
        }
    }
}

