/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DefaultUndoRedoInterceptor;
import twaver.TDataBox;
import twaver.UndoRedoEvent;
import twaver.UndoRedoInterceptor;
import twaver.UndoRedoListener;

public class UndoRedoManager {
    private int C = -1;
    private TDataBox F = null;
    private boolean G = true;
    private boolean D = false;
    private int H = -1;
    private LinkedList L = new LinkedList();
    private List K = new ArrayList();
    private UndoRedoInterceptor I = new DefaultUndoRedoInterceptor(this);
    private int E = 0;
    private PropertyChangeListener J = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            UndoRedoManager.this.addEvent(new UndoRedoEvent(UndoRedoManager.this.F, event.getPropertyName(), event.getOldValue(), event.getNewValue()));
        }
    };
    private PropertyChangeListener B = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            UndoRedoManager.this.addEvent(event);
        }
    };
    private DataBoxListener A = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            UndoRedoManager.this.addEvent(e2);
        }

        public void elementRemoved(DataBoxEvent e2) {
            UndoRedoManager.this.addEvent(e2);
        }

        public void elementsCleared(DataBoxEvent e2) {
            UndoRedoManager.this.addEvent(e2);
        }
    };

    public boolean isIgnorePropertyChange() {
        return this.E != 0;
    }

    public void setIgnorePropertyChange(boolean ignorePropertyChange) {
        this.E = ignorePropertyChange ? ++this.E : --this.E;
    }

    UndoRedoManager(TDataBox box) {
        this.F = box;
    }

    public TDataBox getDataBox() {
        return this.F;
    }

    public void addUndoRedoListener(UndoRedoListener l2) {
        if (l2 != null && !this.K.contains(l2)) {
            this.K.add(l2);
        }
    }

    public void removeUndoRedoListener(UndoRedoListener l2) {
        this.K.remove(l2);
    }

    public List getUndoRedoListeners() {
        return new ArrayList(this.K);
    }

    public void reset() {
        this.L.clear();
        this.H = -1;
        for (int i2 = 0; i2 < this.K.size(); ++i2) {
            UndoRedoListener l2 = (UndoRedoListener)this.K.get(i2);
            l2.reset();
        }
    }

    public boolean canUndo() {
        return this.H >= 0;
    }

    public boolean canRedo() {
        return this.H < this.L.size() - 1;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        Object event = this.L.get(this.H--);
        this.D = true;
        this.I.undo(this.F, event);
        this.D = false;
        for (int i2 = 0; i2 < this.K.size(); ++i2) {
            UndoRedoListener l2 = (UndoRedoListener)this.K.get(i2);
            l2.undid(event);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Object event = this.L.get(++this.H);
        this.D = true;
        this.I.redo(this.F, event);
        this.D = false;
        for (int i2 = 0; i2 < this.K.size(); ++i2) {
            UndoRedoListener l2 = (UndoRedoListener)this.K.get(i2);
            l2.redid(event);
        }
    }

    public void addEvent(Object event) {
        EventObject e2;
        if (!this.G || this.C <= 0 || this.D) {
            return;
        }
        if (event instanceof PropertyChangeEvent) {
            e2 = (PropertyChangeEvent)event;
            if (this.isIgnorePropertyChange()) {
                return;
            }
            if (!this.I.isInterested((PropertyChangeEvent)e2)) {
                return;
            }
        } else if (event instanceof DataBoxEvent && !this.I.isInterested((DataBoxEvent)(e2 = (DataBoxEvent)event))) {
            return;
        }
        while (this.canRedo()) {
            this.L.removeLast();
        }
        this.L.addLast(event);
        this.H = this.L.size() - 1;
        for (int i2 = 0; i2 < this.K.size(); ++i2) {
            UndoRedoListener l2 = (UndoRedoListener)this.K.get(i2);
            l2.eventAdded(event);
        }
        this.A();
    }

    private void A() {
        while (this.L.size() > 0 && this.L.size() > this.C) {
            Object event = this.L.removeFirst();
            --this.H;
            for (int i2 = 0; i2 < this.K.size(); ++i2) {
                UndoRedoListener l2 = (UndoRedoListener)this.K.get(i2);
                l2.eventRemoved(event);
            }
        }
    }

    public int getLimit() {
        return this.C;
    }

    public void setLimit(int limit) {
        if (this.C == limit) {
            return;
        }
        int oldValue = this.C;
        this.C = limit;
        this.A();
        if (oldValue > 0 && this.C <= 0) {
            this.F.removeElementPropertyChangeListener(this.B);
            this.F.getPropertyChangeSupport().removePropertyChangeListener(this.J);
            this.F.removeDataBoxListener(this.A);
        } else if (oldValue <= 0 && this.C > 0) {
            this.F.addElementPropertyChangeListener(this.B);
            this.F.getPropertyChangeSupport().addPropertyChangeListener(this.J);
            this.F.addDataBoxListener(this.A);
        }
    }

    public LinkedList getEvents() {
        return this.L;
    }

    public int getPosition() {
        return this.H;
    }

    public UndoRedoInterceptor getInterceptor() {
        return this.I;
    }

    public void setInterceptor(UndoRedoInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("UndoRedoInterceptor can not be Null");
        }
        this.I = interceptor;
    }

    public boolean isUndoRedoing() {
        return this.D;
    }

    public boolean isEnable() {
        return this.G;
    }

    public void setEnable(boolean enable) {
        this.G = enable;
    }
}

