/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import y.base.ListCell;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.view.Bend;
import y.view.BendCursor;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.if;

public class PolyLineEdgeRealizer
extends EdgeRealizer {
    private boolean aa;

    public PolyLineEdgeRealizer() {
        this.aa = false;
    }

    public PolyLineEdgeRealizer(EdgeRealizer edgeRealizer) {
        super(edgeRealizer);
        this.aa = edgeRealizer instanceof PolyLineEdgeRealizer ? ((PolyLineEdgeRealizer)edgeRealizer).getSmoothedBends() : false;
    }

    public EdgeRealizer createCopy(EdgeRealizer edgeRealizer) {
        PolyLineEdgeRealizer polyLineEdgeRealizer = new PolyLineEdgeRealizer(edgeRealizer);
        return polyLineEdgeRealizer;
    }

    public void setSmoothedBends(boolean bl) {
        if (bl != this.aa) {
            this.aa = bl;
            this.setDirty();
        }
    }

    public boolean getSmoothedBends() {
        return this.aa;
    }

    public Bend createBend(double d2, double d3, Bend bend, int n) {
        Bend bend2 = new Bend(this, d2, d3);
        this.reInsertBend(bend2, bend, n);
        return bend2;
    }

    public void reInsertBend(Bend bend, Bend bend2, int n) {
        if (n == 0) {
            this.bends.insertAfter(bend, this.bends.findCell(bend2));
        } else {
            this.bends.insertBefore(bend, this.bends.findCell(bend2));
        }
        this.setDirty();
    }

    public Bend insertBend(double d2, double d3) {
        int n = this.containsSeg(d2, d3);
        if (n > 0) {
            return this.createBend(d2, d3, (Bend)this.bends.elementAt(n - 1), 1);
        }
        return this.appendBend(d2, d3);
    }

    public Bend removeBend(Bend bend) {
        this.bends.remove(bend);
        this.setDirty();
        return bend;
    }

    public int containsSeg(double d2, double d3) {
        double d4;
        double d5;
        if (this.getEdge().isSelfLoop() && this.bendCount() < 2) {
            return super.containsSeg(d2, d3);
        }
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        Point2D point2D = this.getSourceIntersection();
        double d6 = point2D.getX();
        double d7 = point2D.getY();
        int n = 1;
        BendCursor bendCursor = this.bends();
        while (bendCursor.ok()) {
            Bend bend = bendCursor.bend();
            d5 = bend.getX();
            if (Line2D.ptSegDist(d6, d7, d5, d4 = bend.getY(), d2, d3) < 5.0) {
                return n;
            }
            d6 = d5;
            d7 = d4;
            bendCursor.next();
            ++n;
        }
        point2D = this.getTargetIntersection();
        d5 = point2D.getX();
        if (Line2D.ptSegDist(d6, d7, d5, d4 = point2D.getY(), d2, d3) < 5.0) {
            return n;
        }
        return 0;
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        Object object;
        if (this.getEdge().isSelfLoop() && this.bendCount() < 2) {
            super.calcUnionRect(rectangle2D);
            return;
        }
        ListCell listCell = this.bends.firstCell();
        while (listCell != null) {
            object = (Bend)listCell.getInfo();
            rectangle2D.add(((Bend)object).getX(), ((Bend)object).getY());
            listCell = listCell.succ();
        }
        object = this.getSourcePort();
        Port port = this.getTargetPort();
        ((Port)object).calcUnionRect(rectangle2D, this.getSourceRealizer());
        port.calcUnionRect(rectangle2D, this.getTargetRealizer());
        int n = this.labelCount() - 1;
        while (n >= 0) {
            EdgeLabel edgeLabel = this.getLabel(n);
            if (edgeLabel.isVisible() && edgeLabel.getText().length() > 0) {
                YRectangle yRectangle = edgeLabel.getBox();
                double d2 = Math.min(yRectangle.getX(), rectangle2D.getX());
                double d3 = Math.max(yRectangle.getX() + yRectangle.getWidth(), rectangle2D.getX() + rectangle2D.getWidth());
                double d4 = Math.min(yRectangle.getY(), rectangle2D.getY());
                double d5 = Math.max(yRectangle.getY() + yRectangle.getHeight(), rectangle2D.getY() + rectangle2D.getHeight());
                rectangle2D.setFrame(d2, d4, d3 - d2, d5 - d4);
            }
            --n;
        }
    }

    protected void calculatePath() {
        boolean bl = false;
        if (this.getEdge().isSelfLoop()) {
            if (this.bendCount() == 0) {
                NodeRealizer nodeRealizer = this.getSourceRealizer();
                this.appendBend(this.getSourcePort().getX(nodeRealizer), this.getSourcePort().getY(nodeRealizer) - 10.0 - nodeRealizer.getHeight());
                bl = true;
            } else if (this.bendCount() == 1) {
                bl = true;
            }
        }
        if (bl) {
            if.a(this, this.path);
        } else if (this.aa) {
            this.path = if.c(this, this.path);
        } else {
            if.b(this, this.path);
        }
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        super.write(objectOutputStream);
        objectOutputStream.writeBoolean(this.aa);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                this.aa = false;
                break;
            }
            case 1: {
                super.read(objectInputStream);
                this.aa = objectInputStream.readBoolean();
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

